/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gradle.api.tasks.bundling.ZipEntryCompression;

public class ZipReprocessorUtil {
    private static final String META_INF = "META-INF/";

    private ZipReprocessorUtil() {
    }

    private static boolean isSpecialFile(String zipEntryName) {
        if (!zipEntryName.startsWith(META_INF)) {
            return false;
        }
        String[] parts = zipEntryName.split("/");
        if (parts.length != 2) {
            return false;
        }
        return parts[1].startsWith("SIG-") || parts[1].endsWith(".SF") || parts[1].endsWith(".DSA") || parts[1].endsWith(".RSA") || parts[1].endsWith(".EC");
    }

    private static int specialOrdering(String name1, String name2) {
        if (name1.equals(name2)) {
            return 0;
        }
        if (name1.equals("META-INF/MANIFEST.MF")) {
            return -1;
        }
        if (name2.equals("META-INF/MANIFEST.MF")) {
            return 1;
        }
        boolean isName1Special = ZipReprocessorUtil.isSpecialFile(name1);
        boolean isName2Special = ZipReprocessorUtil.isSpecialFile(name2);
        if (isName1Special && isName2Special) {
            return name1.compareTo(name2);
        }
        if (isName1Special) {
            return -1;
        }
        if (isName2Special) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    public static void reprocessZip(Path file, boolean reproducibleFileOrder, boolean preserveFileTimestamps) throws IOException {
        ZipReprocessorUtil.reprocessZip(file, reproducibleFileOrder, preserveFileTimestamps, ZipEntryCompression.DEFLATED);
    }

    public static void reprocessZip(Path file, boolean reproducibleFileOrder, boolean preserveFileTimestamps, ZipEntryCompression zipEntryCompression) throws IOException {
        if (!reproducibleFileOrder && preserveFileTimestamps) {
            return;
        }
        Path tempFile = file.resolveSibling(file.getFileName() + ".tmp");
        try (ZipFile zipFile = new ZipFile(file.toFile());
             OutputStream fileOutputStream = Files.newOutputStream(tempFile, new OpenOption[0]);){
            ZipEntry[] entries = reproducibleFileOrder ? (ZipEntry[])zipFile.stream().sorted(Comparator.comparing(ZipEntry::getName, ZipReprocessorUtil::specialOrdering)).toArray(ZipEntry[]::new) : (ZipEntry[])zipFile.stream().toArray(ZipEntry[]::new);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
                zipOutputStream.setMethod(ZipReprocessorUtil.zipOutputStreamCompressionMethod(zipEntryCompression));
                ZipEntry[] zipEntryArray = entries;
                int n = zipEntryArray.length;
                for (int i = 0; i < n; ++i) {
                    ZipEntry entry;
                    ZipEntry newEntry = entry = zipEntryArray[i];
                    if (!preserveFileTimestamps) {
                        newEntry = new ZipEntry(entry.getName());
                        ZipReprocessorUtil.setConstantFileTime(newEntry);
                    }
                    newEntry.setMethod(ZipReprocessorUtil.zipEntryCompressionMethod(zipEntryCompression));
                    ZipReprocessorUtil.copyZipEntry(zipOutputStream, newEntry, zipFile.getInputStream(entry));
                }
            }
        }
        Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void appendZipEntry(Path file, String path, byte[] data) throws IOException {
        Path tempFile = file.resolveSibling(file.getFileName() + ".tmp");
        try (ZipFile zipFile = new ZipFile(file.toFile());
             OutputStream fileOutputStream = Files.newOutputStream(tempFile, new OpenOption[0]);){
            ZipEntry[] entries = (ZipEntry[])zipFile.stream().toArray(ZipEntry[]::new);
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
                for (ZipEntry entry : entries) {
                    if (entry.getName().equals(path)) {
                        throw new IllegalArgumentException("Zip file (%s) already contains entry (%s)".formatted(file.getFileName().toString(), path));
                    }
                    ZipReprocessorUtil.copyZipEntry(zipOutputStream, entry, zipFile.getInputStream(entry));
                }
                ZipEntry entry = new ZipEntry(path);
                ZipReprocessorUtil.setConstantFileTime(entry);
                zipOutputStream.putNextEntry(entry);
                zipOutputStream.write(data, 0, data.length);
                zipOutputStream.closeEntry();
            }
        }
        Files.move(tempFile, file, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void copyZipEntry(ZipOutputStream zipOutputStream, ZipEntry entry, InputStream inputStream) throws IOException {
        int length;
        zipOutputStream.putNextEntry(entry);
        byte[] buf = new byte[1024];
        while ((length = inputStream.read(buf)) > 0) {
            zipOutputStream.write(buf, 0, length);
        }
        zipOutputStream.closeEntry();
    }

    private static void setConstantFileTime(ZipEntry entry) {
        entry.setTime(new GregorianCalendar(1980, 0, 1, 0, 0, 0).getTimeInMillis());
    }

    private static int zipOutputStreamCompressionMethod(ZipEntryCompression compression) {
        return switch (compression) {
            default -> throw new IncompatibleClassChangeError();
            case ZipEntryCompression.STORED -> 0;
            case ZipEntryCompression.DEFLATED -> 8;
        };
    }

    private static int zipEntryCompressionMethod(ZipEntryCompression compression) {
        return switch (compression) {
            default -> throw new IncompatibleClassChangeError();
            case ZipEntryCompression.STORED -> 0;
            case ZipEntryCompression.DEFLATED -> 8;
        };
    }
}

