/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.Pair;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ZipUtils {
    public static boolean isZip(Path zip) throws IOException {
        if (Files.notExists(zip, new LinkOption[0])) {
            throw new NoSuchFileException("Cannot check if '" + zip + "' is a zip because it doesn't exist!");
        }
        if (Files.isRegularFile(zip, new LinkOption[0])) {
            try (DataInputStream in = new DataInputStream(Files.newInputStream(zip, new OpenOption[0]));){
                int header = in.readInt();
                boolean bl = header == 1347093252 || header == 1347093766 || header == 1347094280;
                return bl;
            }
        }
        return false;
    }

    public static boolean contains(Path zip, String path) {
        boolean bl;
        block8: {
            FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(zip, false);
            try {
                Path fsPath = fs.get().getPath(path, new String[0]);
                bl = Files.exists(fsPath, new LinkOption[0]);
                if (fs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to check file from zip", e);
                }
            }
            fs.close();
        }
        return bl;
    }

    public static void unpackAll(Path zip, Path output) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(zip, false);
             Stream<Path> walk = Files.walk(fs.get().getPath("/", new String[0]), new FileVisitOption[0]);){
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                Path fsPath = (Path)iterator.next();
                if (!Files.isRegularFile(fsPath, new LinkOption[0])) continue;
                Path dstPath = output.resolve(fs.get().getPath("/", new String[0]).relativize(fsPath).toString());
                Path dstPathParent = dstPath.getParent();
                if (dstPathParent != null) {
                    Files.createDirectories(dstPathParent, new FileAttribute[0]);
                }
                Files.copy(fsPath, dstPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
        }
    }

    public static byte @Nullable [] unpackNullable(Path zip, String path) throws IOException {
        try {
            return ZipUtils.unpack(zip, path);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    public static byte[] unpack(Path zip, String path) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(zip, false);){
            byte[] byArray = fs.readAllBytes(path);
            return byArray;
        }
    }

    public static <T> T unpackGson(Path zip, String path, Class<T> clazz) throws IOException {
        byte[] bytes = ZipUtils.unpack(zip, path);
        return (T)LoomGradlePlugin.GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), clazz);
    }

    @Nullable
    public static <T> T unpackGsonNullable(Path zip, String path, Class<T> clazz) throws IOException {
        try {
            return ZipUtils.unpackGson(zip, path, clazz);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    public static <T> T unpackJackson(Path zip, String path, Class<T> clazz) throws IOException {
        byte[] bytes = ZipUtils.unpack(zip, path);
        return (T)LoomGradlePlugin.GSON.fromJson(new String(bytes, StandardCharsets.UTF_8), clazz);
    }

    public static void pack(Path from, Path zip) throws IOException {
        Files.deleteIfExists(zip);
        if (!Files.isDirectory(from, new LinkOption[0])) {
            throw new IllegalArgumentException(from + " is not a directory!");
        }
        int count = 0;
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(zip, true);
             Stream<Path> walk = Files.walk(from, new FileVisitOption[0]);){
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                Path fromPath = (Path)iterator.next();
                if (!Files.isRegularFile(fromPath, new LinkOption[0])) continue;
                Path fsPath = fs.get().getPath(from.relativize(fromPath).toString(), new String[0]);
                Path fsPathParent = fsPath.getParent();
                if (fsPathParent != null) {
                    Files.createDirectories(fsPathParent, new FileAttribute[0]);
                }
                Files.copy(fromPath, fsPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                ++count;
            }
        }
        if (count == 0) {
            throw new IOException("Noting packed into %s from %s".formatted(zip, from));
        }
    }

    public static void add(Path zip, String path, String str) throws IOException {
        ZipUtils.add(zip, path, str.getBytes(StandardCharsets.UTF_8));
    }

    public static void add(Path zip, String path, byte[] bytes) throws IOException {
        ZipUtils.add(zip, Collections.singleton(new Pair<String, byte[]>(path, bytes)));
    }

    public static void add(Path zip, Iterable<Pair<String, byte[]>> files) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(zip, true);){
            for (Pair<String, byte[]> pair : files) {
                Path fsPath = fs.get().getPath(pair.left(), new String[0]);
                Path fsPathParent = fsPath.getParent();
                if (fsPathParent != null) {
                    Files.createDirectories(fsPathParent, new FileAttribute[0]);
                }
                Files.write(fsPath, pair.right(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
    }

    public static void replace(Path zip, String path, byte[] bytes) throws IOException {
        block7: {
            try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(zip, true);){
                Path fsPath = fs.get().getPath(path, new String[0]);
                if (Files.exists(fsPath, new LinkOption[0])) {
                    Files.write(fsPath, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    break block7;
                }
                throw new NoSuchFileException(fsPath.toString());
            }
        }
    }

    public static int transformString(Path zip, Collection<Pair<String, UnsafeUnaryOperator<String>>> transforms) throws IOException {
        return ZipUtils.transformString(zip, transforms.stream());
    }

    public static int transformString(Path zip, Stream<Pair<String, UnsafeUnaryOperator<String>>> transforms) throws IOException {
        return ZipUtils.transformString(zip, ZipUtils.collectTransformersStream(transforms));
    }

    public static int transformString(Path zip, Map<String, UnsafeUnaryOperator<String>> transforms) throws IOException {
        return ZipUtils.transformMapped(zip, transforms, bytes -> new String((byte[])bytes, StandardCharsets.UTF_8), s -> s.getBytes(StandardCharsets.UTF_8));
    }

    public static <T> int transformJson(Class<T> typeOfT, Path zip, Collection<Pair<String, UnsafeUnaryOperator<T>>> transforms) throws IOException {
        return ZipUtils.transformJson(typeOfT, zip, transforms.stream());
    }

    public static <T> int transformJson(Class<T> typeOfT, Path zip, Stream<Pair<String, UnsafeUnaryOperator<T>>> transforms) throws IOException {
        return ZipUtils.transformJson(typeOfT, zip, ZipUtils.collectTransformersStream(transforms));
    }

    public static <T> int transformJson(Class<T> typeOfT, Path zip, Map<String, UnsafeUnaryOperator<T>> transforms) throws IOException {
        return ZipUtils.transformMapped(zip, transforms, bytes -> LoomGradlePlugin.GSON.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream((byte[])bytes)), typeOfT), s -> LoomGradlePlugin.GSON.toJson(s, (Type)typeOfT).getBytes(StandardCharsets.UTF_8));
    }

    public static int transform(Path zip, Collection<Pair<String, UnsafeUnaryOperator<byte[]>>> transforms) throws IOException {
        return ZipUtils.transform(zip, transforms.stream());
    }

    public static int transform(Path zip, Stream<Pair<String, UnsafeUnaryOperator<byte[]>>> transforms) throws IOException {
        return ZipUtils.transform(zip, ZipUtils.collectTransformersStream(transforms));
    }

    public static <T> int transformMapped(Path zip, Map<String, UnsafeUnaryOperator<T>> transforms, Function<byte[], T> deserializer, Function<T, byte[]> serializer) throws IOException {
        HashMap<String, UnsafeUnaryOperator<byte[]>> newTransforms = new HashMap<String, UnsafeUnaryOperator<byte[]>>();
        for (Map.Entry entry : transforms.entrySet()) {
            if (entry.getValue() == null) continue;
            newTransforms.put(entry.getKey(), bytes -> (byte[])serializer.apply(((UnsafeUnaryOperator)entry.getValue()).apply(deserializer.apply((byte[])bytes))));
        }
        return ZipUtils.transform(zip, newTransforms);
    }

    public static int transform(Path zip, Map<String, UnsafeUnaryOperator<byte[]>> transforms) throws IOException {
        int replacedCount = 0;
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(zip, false);){
            for (Map.Entry<String, UnsafeUnaryOperator<byte[]>> entry : transforms.entrySet()) {
                Path fsPath = fs.get().getPath(entry.getKey(), new String[0]);
                if (!Files.exists(fsPath, new LinkOption[0]) || entry.getValue() == null) continue;
                Files.write(fsPath, entry.getValue().apply(Files.readAllBytes(fsPath)), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                ++replacedCount;
            }
        }
        return replacedCount;
    }

    private static <T> Map<String, UnsafeUnaryOperator<T>> collectTransformersStream(Stream<Pair<String, UnsafeUnaryOperator<T>>> transforms) {
        HashMap<String, UnsafeUnaryOperator<T>> map = new HashMap<String, UnsafeUnaryOperator<T>>();
        Iterator iterator = transforms.iterator();
        while (iterator.hasNext()) {
            Pair next = (Pair)iterator.next();
            map.put((String)next.left(), (UnsafeUnaryOperator)next.right());
        }
        return map;
    }

    @FunctionalInterface
    public static interface UnsafeUnaryOperator<T> {
        public T apply(T var1) throws IOException;
    }

    public static interface AsmClassOperator
    extends UnsafeUnaryOperator<byte[]> {
        public ClassVisitor visit(ClassVisitor var1);

        @Override
        default public byte[] apply(byte[] arg) throws IOException {
            ClassReader reader = new ClassReader(arg);
            ClassWriter writer = new ClassWriter(0);
            reader.accept(this.visit((ClassVisitor)writer), 0);
            return writer.toByteArray();
        }
    }
}

