/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.InterfaceInjectionExtensionAPI;
import net.fabricmc.loom.build.mixin.GroovyApInvoker;
import net.fabricmc.loom.build.mixin.JavaApInvoker;
import net.fabricmc.loom.build.mixin.KaptApInvoker;
import net.fabricmc.loom.build.mixin.ScalaApInvoker;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.ConfigContextImpl;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.LoomDependencyManager;
import net.fabricmc.loom.configuration.accesswidener.AccessWidenerJarProcessor;
import net.fabricmc.loom.configuration.ifaceinject.InterfaceInjectionProcessor;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.configuration.processors.ModJavadocProcessor;
import net.fabricmc.loom.configuration.providers.mappings.LayeredMappingsFactory;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.LegacyMergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJarConfiguration;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.AbstractMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.IntermediaryMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;
import net.fabricmc.loom.extension.MixinExtension;
import net.fabricmc.loom.util.Checksum;
import net.fabricmc.loom.util.ExceptionUtil;
import net.fabricmc.loom.util.ProcessUtil;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.service.ScopedSharedServiceManager;
import net.fabricmc.loom.util.service.SharedServiceManager;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;

public abstract class CompileConfiguration
implements Runnable {
    @Inject
    protected abstract Project getProject();

    @Inject
    protected abstract TaskContainer getTasks();

    @Override
    public void run() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        this.getTasks().named("javadoc", Javadoc.class).configure(javadoc -> {
            SourceSet main = SourceSetHelper.getMainSourceSet(this.getProject());
            javadoc.setClasspath(main.getOutput().plus(main.getCompileClasspath()));
        });
        this.afterEvaluationWithService(serviceManager -> {
            ConfigContextImpl configContext = new ConfigContextImpl(this.getProject(), (SharedServiceManager)serviceManager, extension);
            MinecraftSourceSets.get(this.getProject()).afterEvaluate(this.getProject());
            boolean previousRefreshDeps = extension.refreshDeps();
            LockResult lockResult = this.acquireProcessLockWaiting(this.getLockFile());
            if (lockResult != LockResult.ACQUIRED_CLEAN) {
                this.getProject().getLogger().lifecycle("Found existing cache lock file ({}), rebuilding loom cache. This may have been caused by a failed or canceled build.", new Object[]{lockResult});
                extension.setRefreshDeps(true);
            }
            try {
                this.setupMinecraft(configContext);
                LoomDependencyManager dependencyManager = new LoomDependencyManager();
                extension.setDependencyManager(dependencyManager);
                dependencyManager.handleDependencies(this.getProject(), (SharedServiceManager)serviceManager);
            }
            catch (Exception e) {
                ExceptionUtil.printFileLocks(e, this.getProject());
                this.disownLock();
                throw ExceptionUtil.createDescriptiveWrapper(RuntimeException::new, "Failed to setup Minecraft", e);
            }
            this.releaseLock();
            extension.setRefreshDeps(previousRefreshDeps);
            MixinExtension mixin = LoomGradleExtension.get(this.getProject()).getMixin();
            if (((Boolean)mixin.getUseLegacyMixinAp().get()).booleanValue()) {
                this.setupMixinAp(mixin);
            }
            this.configureDecompileTasks(configContext);
        });
        this.finalizedBy("idea", "genIdeaWorkspace");
        this.finalizedBy("eclipse", "genEclipseRuns");
        this.finalizedBy("cleanEclipse", "cleanEclipseRuns");
        this.getProject().artifacts(artifactHandler -> artifactHandler.add("namedElements", (Object)this.getTasks().named("jar")));
        this.getTasks().withType(AbstractCopyTask.class).configureEach(abstractCopyTask -> abstractCopyTask.setFilteringCharset(StandardCharsets.UTF_8.name()));
        this.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> javaCompile.getOptions().setEncoding(StandardCharsets.UTF_8.name()));
        if (this.getProject().getPluginManager().hasPlugin("org.jetbrains.kotlin.kapt")) {
            throw new IllegalArgumentException("fabric-loom must be applied BEFORE kapt in the plugins { } block.");
        }
    }

    private synchronized void setupMinecraft(ConfigContext configContext) throws Exception {
        Project project = configContext.project();
        LoomGradleExtension extension = configContext.extension();
        MinecraftMetadataProvider metadataProvider = MinecraftMetadataProvider.create(configContext);
        MinecraftJarConfiguration<LegacyMergedMinecraftProvider, NamedMinecraftProvider.LegacyMergedImpl, MappedMinecraftProvider> jarConfiguration = (MinecraftJarConfiguration<LegacyMergedMinecraftProvider, NamedMinecraftProvider.LegacyMergedImpl, MappedMinecraftProvider>)extension.getMinecraftJarConfiguration().get();
        if (jarConfiguration == MinecraftJarConfiguration.MERGED && !metadataProvider.getVersionMeta().isVersionOrNewer("2012-07-25T22:00:00+00:00")) {
            jarConfiguration = MinecraftJarConfiguration.LEGACY_MERGED;
        }
        MinecraftProvider minecraftProvider = jarConfiguration.createMinecraftProvider(metadataProvider, configContext);
        extension.setMinecraftProvider(minecraftProvider);
        minecraftProvider.provide();
        LayeredMappingsFactory.afterEvaluate(configContext);
        DependencyInfo mappingsDep = DependencyInfo.create(this.getProject(), "mappings");
        MappingConfiguration mappingConfiguration = MappingConfiguration.create(this.getProject(), configContext.serviceManager(), mappingsDep, minecraftProvider);
        extension.setMappingConfiguration(mappingConfiguration);
        mappingConfiguration.applyToProject(this.getProject(), mappingsDep);
        IntermediaryMinecraftProvider<LegacyMergedMinecraftProvider> intermediaryMinecraftProvider = jarConfiguration.createIntermediaryMinecraftProvider(project);
        NamedMinecraftProvider<LegacyMergedMinecraftProvider> namedMinecraftProvider = jarConfiguration.createNamedMinecraftProvider(project);
        this.registerGameProcessors(configContext);
        MinecraftJarProcessorManager minecraftJarProcessorManager = MinecraftJarProcessorManager.create(this.getProject());
        if (minecraftJarProcessorManager != null) {
            namedMinecraftProvider = jarConfiguration.createProcessedNamedMinecraftProvider(namedMinecraftProvider, minecraftJarProcessorManager);
        }
        AbstractMappedMinecraftProvider.ProvideContext provideContext = new AbstractMappedMinecraftProvider.ProvideContext(true, extension.refreshDeps(), configContext);
        extension.setIntermediaryMinecraftProvider(intermediaryMinecraftProvider);
        intermediaryMinecraftProvider.provide(provideContext);
        extension.setNamedMinecraftProvider(namedMinecraftProvider);
        namedMinecraftProvider.provide(provideContext);
    }

    private void registerGameProcessors(ConfigContext configContext) {
        InterfaceInjectionExtensionAPI interfaceInjection;
        LoomGradleExtension extension = configContext.extension();
        boolean enableTransitiveAccessWideners = (Boolean)extension.getEnableTransitiveAccessWideners().get();
        extension.addMinecraftJarProcessor(AccessWidenerJarProcessor.class, "fabric-loom:access-widener", enableTransitiveAccessWideners, extension.getAccessWidenerPath());
        if (((Boolean)extension.getEnableModProvidedJavadoc().get()).booleanValue()) {
            extension.addMinecraftJarProcessor(ModJavadocProcessor.class, "fabric-loom:mod-javadoc");
        }
        if ((interfaceInjection = extension.getInterfaceInjection()).isEnabled()) {
            extension.addMinecraftJarProcessor(InterfaceInjectionProcessor.class, "fabric-loom:interface-inject", interfaceInjection.getEnableDependencyInterfaceInjection().get());
        }
    }

    private void setupMixinAp(MixinExtension mixin) {
        mixin.init();
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("log4j.shutdownHookEnabled", "false");
        System.setProperty("log4j.skipJansi", "true");
        this.getProject().getLogger().info("Configuring compiler arguments for Java");
        new JavaApInvoker(this.getProject()).configureMixin();
        if (this.getProject().getPluginManager().hasPlugin("scala")) {
            this.getProject().getLogger().info("Configuring compiler arguments for Scala");
            new ScalaApInvoker(this.getProject()).configureMixin();
        }
        if (this.getProject().getPluginManager().hasPlugin("org.jetbrains.kotlin.kapt")) {
            this.getProject().getLogger().info("Configuring compiler arguments for Kapt plugin");
            new KaptApInvoker(this.getProject()).configureMixin();
        }
        if (this.getProject().getPluginManager().hasPlugin("groovy")) {
            this.getProject().getLogger().info("Configuring compiler arguments for Groovy");
            new GroovyApInvoker(this.getProject()).configureMixin();
        }
    }

    private void configureDecompileTasks(ConfigContext configContext) {
        LoomGradleExtension extension = configContext.extension();
        ((MinecraftJarConfiguration)extension.getMinecraftJarConfiguration().get()).createDecompileConfiguration(this.getProject()).afterEvaluation();
    }

    private LockFile getLockFile() {
        LoomGradleExtension extension = LoomGradleExtension.get(this.getProject());
        Path cacheDirectory = extension.getFiles().getUserCache().toPath();
        String pathHash = Checksum.projectHash(this.getProject());
        return new LockFile(cacheDirectory.resolve("." + pathHash + ".lock"), "Lock for cache='%s', project='%s'".formatted(cacheDirectory, this.getProject().absoluteProjectPath(this.getProject().getPath())));
    }

    private LockResult acquireProcessLockWaiting(LockFile lockFile) {
        return this.acquireProcessLockWaiting(lockFile, CompileConfiguration.getDefaultTimeout());
    }

    private LockResult acquireProcessLockWaiting(LockFile lockFile, Duration timeout) {
        try {
            return this.acquireProcessLockWaiting_(lockFile, timeout);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception acquiring lock " + lockFile, e);
        }
    }

    private LockResult acquireProcessLockWaiting_(LockFile lockFile, Duration timeout) throws IOException {
        long timeoutMs = timeout.toMillis();
        Logger logger = Logging.getLogger((String)"loom_acquireProcessLockWaiting");
        long currentPid = ProcessHandle.current().pid();
        boolean abrupt = false;
        boolean disowned = false;
        if (Files.exists(lockFile.file, new LinkOption[0])) {
            long lockingProcessId = -1L;
            try {
                String lockValue = Files.readString(lockFile.file);
                if ("disowned".equals(lockValue)) {
                    disowned = true;
                } else {
                    lockingProcessId = Long.parseLong(lockValue);
                    logger.lifecycle("\"{}\" is currently held by pid '{}'.", new Object[]{lockFile, lockingProcessId});
                }
            }
            catch (Exception lockValue) {
                // empty catch block
            }
            if (lockingProcessId == currentPid) {
                return LockResult.ACQUIRED_ALREADY_OWNED;
            }
            Optional<ProcessHandle> handle = ProcessHandle.of(lockingProcessId);
            if (disowned) {
                logger.lifecycle("Previous process has disowned the lock due to abrupt termination.");
                Files.deleteIfExists(lockFile.file);
            } else if (handle.isEmpty()) {
                logger.lifecycle("Locking process does not exist, assuming abrupt termination and deleting lock file.");
                Files.deleteIfExists(lockFile.file);
                abrupt = true;
            } else {
                ProcessUtil processUtil = ProcessUtil.create(this.getProject());
                logger.lifecycle(processUtil.printWithParents(handle.get()));
                logger.lifecycle("Waiting for lock to be released...");
                long sleptMs = 0L;
                while (Files.exists(lockFile.file, new LinkOption[0])) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if ((sleptMs += 100L) >= 60000L && sleptMs % 60000L == 0L) {
                        logger.lifecycle("Have been waiting on \"{}\" held by pid '{}' for {} minute(s).\nIf this persists for an unreasonable length of time, kill this process, run './gradlew --stop' and then try again.", new Object[]{lockFile, lockingProcessId, sleptMs / 1000L / 60L});
                    }
                    if (sleptMs < timeoutMs) continue;
                    throw new GradleException("Have been waiting on lock file '%s' for %s ms. Giving up as timeout is %s ms.".formatted(lockFile, sleptMs, timeoutMs));
                }
            }
        }
        if (!Files.exists(lockFile.file.getParent(), new LinkOption[0])) {
            Files.createDirectories(lockFile.file.getParent(), new FileAttribute[0]);
        }
        Files.writeString(lockFile.file, (CharSequence)String.valueOf(currentPid), new OpenOption[0]);
        if (disowned) {
            return LockResult.ACQUIRED_PREVIOUS_OWNER_DISOWNED;
        }
        if (abrupt) {
            return LockResult.ACQUIRED_PREVIOUS_OWNER_MISSING;
        }
        return LockResult.ACQUIRED_CLEAN;
    }

    private static Duration getDefaultTimeout() {
        if (System.getenv("CI") != null) {
            return Duration.ofMinutes(1L);
        }
        return Duration.ofHours(1L);
    }

    private void disownLock() {
        Path lock = this.getLockFile().file;
        try {
            Files.writeString(lock, (CharSequence)"disowned", new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void releaseLock() {
        Path lock = this.getLockFile().file;
        if (!Files.exists(lock, new LinkOption[0])) {
            return;
        }
        try {
            Files.delete(lock);
        }
        catch (IOException e1) {
            try {
                Path del = lock.resolveSibling(lock.getFileName() + ".del");
                Files.move(lock, del, new CopyOption[0]);
                Files.delete(del);
            }
            catch (IOException e2) {
                UncheckedIOException exception = new UncheckedIOException("Failed to release getProject() configuration lock", e2);
                exception.addSuppressed(e1);
                throw exception;
            }
        }
    }

    private void finalizedBy(String a, String b) {
        this.getTasks().named(a).configure(task -> task.finalizedBy(new Object[]{this.getTasks().named(b)}));
    }

    private void afterEvaluationWithService(Consumer<SharedServiceManager> consumer) {
        GradleUtils.afterSuccessfulEvaluation(this.getProject(), () -> {
            try (ScopedSharedServiceManager serviceManager = new ScopedSharedServiceManager();){
                consumer.accept(serviceManager);
            }
        });
    }

    record LockFile(Path file, String description) {
        @Override
        public String toString() {
            return this.description;
        }
    }

    static enum LockResult {
        ACQUIRED_CLEAN,
        ACQUIRED_ALREADY_OWNED,
        ACQUIRED_PREVIOUS_OWNER_MISSING,
        ACQUIRED_PREVIOUS_OWNER_DISOWNED;

    }
}

