/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.mods;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.InstallerData;
import net.fabricmc.loom.configuration.mods.ArtifactRef;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.fmj.FabricModJsonFactory;
import org.jetbrains.annotations.Nullable;

public record ArtifactMetadata(boolean isFabricMod, RemapRequirements remapRequirements, @Nullable InstallerData installerData, MixinRemapType mixinRemapType) {
    private static final String INSTALLER_PATH = "fabric-installer.json";

    public static ArtifactMetadata create(ArtifactRef artifact, String currentLoomVersion) throws IOException {
        boolean isFabricMod;
        RemapRequirements remapRequirements = RemapRequirements.DEFAULT;
        InstallerData installerData = null;
        MixinRemapType refmapRemapType = MixinRemapType.MIXIN;
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(artifact.path());){
            isFabricMod = FabricModJsonFactory.containsMod(fs);
            Path manifestPath = fs.getPath("META-INF/MANIFEST.MF", new String[0]);
            if (Files.exists(manifestPath, new LinkOption[0])) {
                Manifest manifest = new Manifest(new ByteArrayInputStream(Files.readAllBytes(manifestPath)));
                Attributes mainAttributes = manifest.getMainAttributes();
                String remapValue = mainAttributes.getValue("Fabric-Loom-Remap");
                String loomVersion = mainAttributes.getValue("Fabric-Loom-Version");
                String mixinRemapType = mainAttributes.getValue("Fabric-Loom-Mixin-Remap-Type");
                if (remapValue != null) {
                    RemapRequirements remapRequirements2 = remapRequirements = Boolean.parseBoolean(remapValue) ? RemapRequirements.OPT_IN : RemapRequirements.OPT_OUT;
                }
                if (mixinRemapType != null) {
                    try {
                        refmapRemapType = MixinRemapType.valueOf(mixinRemapType.toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Unknown mixin remap type: " + mixinRemapType);
                    }
                }
                if (loomVersion != null && refmapRemapType != MixinRemapType.STATIC) {
                    ArtifactMetadata.validateLoomVersion(loomVersion, currentLoomVersion);
                }
            }
            Path installerPath = fs.getPath(INSTALLER_PATH, new String[0]);
            if (isFabricMod && Files.exists(installerPath, new LinkOption[0])) {
                JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(installerPath, StandardCharsets.UTF_8), JsonObject.class);
                installerData = new InstallerData(artifact.version(), jsonObject);
            }
        }
        return new ArtifactMetadata(isFabricMod, remapRequirements, installerData, refmapRemapType);
    }

    private static void validateLoomVersion(String version, String currentLoomVersion) {
        if ("0.0.0+unknown".equals(currentLoomVersion)) {
            return;
        }
        String[] versionParts = version.split("\\.");
        String[] currentVersionParts = currentLoomVersion.split("\\.");
        for (int i = 0; i < 2; ++i) {
            int currentVersionPart;
            int versionPart = Integer.parseInt(versionParts[i]);
            if (versionPart > (currentVersionPart = Integer.parseInt(currentVersionParts[i]))) {
                throw new IllegalStateException("Mod was built with a newer version of Loom (%s), you are using Loom (%s)".formatted(version, currentLoomVersion));
            }
            if (versionPart < currentVersionPart) break;
        }
    }

    public boolean shouldRemap() {
        return this.remapRequirements().getShouldRemap().test(this);
    }

    public static enum RemapRequirements {
        DEFAULT(ArtifactMetadata::isFabricMod),
        OPT_IN(true),
        OPT_OUT(false);

        private final Predicate<ArtifactMetadata> shouldRemap;

        private RemapRequirements(Predicate<ArtifactMetadata> shouldRemap) {
            this.shouldRemap = shouldRemap;
        }

        private RemapRequirements(boolean shouldRemap) {
            this.shouldRemap = artifactMetadata -> shouldRemap;
        }

        private Predicate<ArtifactMetadata> getShouldRemap() {
            return this.shouldRemap;
        }
    }

    public static enum MixinRemapType {
        MIXIN,
        STATIC;


        public String manifestValue() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

