/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import javax.inject.Inject;
import net.fabricmc.loom.api.mappings.intermediate.IntermediateMappingsProvider;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsProviderInternal;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.util.download.DownloadBuilder;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public abstract class IntermediaryMappingsProvider
extends IntermediateMappingsProviderInternal {
    public static final String NAME = "intermediary-v2";
    private static final String FABRIC_INTERMEDIARY_GROUP_NAME = "net.fabricmc:intermediary";
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateMappingsProvider.class);

    public abstract Property<String> getIntermediaryUrl();

    public abstract Property<Boolean> getRefreshDeps();

    @Inject
    public abstract DependencyFactory getDependencyFactory();

    @Override
    public void provide(Path tinyMappings, @Nullable Project project) throws IOException {
        if (Files.exists(tinyMappings, new LinkOption[0]) && !((Boolean)this.getRefreshDeps().get()).booleanValue()) {
            return;
        }
        Path intermediaryJarPath = Files.createTempFile(this.getName(), ".jar", new FileAttribute[0]);
        String encodedMcVersion = UrlEscapers.urlFragmentEscaper().escape((String)this.getMinecraftVersion().get());
        String urlRaw = (String)this.getIntermediaryUrl().get();
        if (project != null && urlRaw.equals("https://maven.fabricmc.net/net/fabricmc/intermediary/%1$s/intermediary-%1$s-v2.jar")) {
            ExternalModuleDependency intermediaryDep = this.getDependencyFactory().create((CharSequence)("net.fabricmc:intermediary:" + encodedMcVersion));
            intermediaryDep.artifact((Action)new Action<DependencyArtifact>(){

                public void execute(DependencyArtifact dependencyArtifact) {
                    dependencyArtifact.setClassifier("v2");
                }
            });
            Configuration config = project.getConfigurations().detachedConfiguration(new Dependency[]{intermediaryDep});
            Files.copy(config.getSingleFile().toPath(), intermediaryJarPath, StandardCopyOption.REPLACE_EXISTING);
            Files.deleteIfExists(tinyMappings);
        } else {
            String url = urlRaw.formatted(encodedMcVersion);
            LOGGER.info("Downloading intermediary from {}", (Object)url);
            Files.deleteIfExists(tinyMappings);
            Files.deleteIfExists(intermediaryJarPath);
            ((DownloadBuilder)((Function)this.getDownloader().get()).apply(url)).defaultCache().downloadPath(intermediaryJarPath);
        }
        MappingConfiguration.extractMappings(intermediaryJarPath, tinyMappings);
    }

    @NotNull
    public String getName() {
        return NAME;
    }
}

