/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.mappings.IntermediateMappingsService;
import net.fabricmc.loom.configuration.providers.mappings.TinyMappingsService;
import net.fabricmc.loom.configuration.providers.mappings.tiny.MappingsMerger;
import net.fabricmc.loom.configuration.providers.mappings.tiny.TinyJarInfo;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.commands.CommandProposeFieldNames;
import org.apache.tools.ant.util.StringUtils;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingConfiguration.class);
    public final String mappingsIdentifier;
    private final Path mappingsWorkingDir;
    private final Path baseTinyMappings;
    public final Path tinyMappings;
    public final Path tinyMappingsJar;
    private final Path unpickDefinitions;
    private boolean hasUnpickDefinitions;
    private UnpickMetadata unpickMetadata;
    private Map<String, String> signatureFixes;

    private MappingConfiguration(String mappingsIdentifier, Path mappingsWorkingDir) {
        this.mappingsIdentifier = mappingsIdentifier;
        this.mappingsWorkingDir = mappingsWorkingDir;
        this.baseTinyMappings = mappingsWorkingDir.resolve("mappings-base.tiny");
        this.tinyMappings = mappingsWorkingDir.resolve("mappings.tiny");
        this.tinyMappingsJar = mappingsWorkingDir.resolve("mappings.jar");
        this.unpickDefinitions = mappingsWorkingDir.resolve("mappings.unpick");
    }

    public static MappingConfiguration create(Project project, SharedServiceManager serviceManager, DependencyInfo dependency, MinecraftProvider minecraftProvider) {
        String version = dependency.getResolvedVersion();
        Path inputJar = dependency.resolveFile().orElseThrow(() -> new RuntimeException("Could not resolve mappings: " + dependency)).toPath();
        String mappingsName = StringUtils.removeSuffix((String)(dependency.getDependency().getGroup() + "." + dependency.getDependency().getName()), (String)"-unmerged");
        TinyJarInfo jarInfo = TinyJarInfo.get(inputJar);
        jarInfo.minecraftVersionId().ifPresent(id -> {
            if (!minecraftProvider.minecraftVersion().equals(id)) {
                LOGGER.warn("The mappings (%s) were not built for Minecraft version %s, proceed with caution.".formatted(dependency.getDepString(), minecraftProvider.minecraftVersion()));
            }
        });
        String mappingsIdentifier = MappingConfiguration.createMappingsIdentifier(mappingsName, version, MappingConfiguration.getMappingsClassifier(dependency, jarInfo.v2()), minecraftProvider.minecraftVersion());
        Path workingDir = minecraftProvider.dir(mappingsIdentifier).toPath();
        MappingConfiguration mappingProvider = new MappingConfiguration(mappingsIdentifier, workingDir);
        try {
            mappingProvider.setup(project, serviceManager, minecraftProvider, inputJar);
        }
        catch (IOException e) {
            MappingConfiguration.cleanWorkingDirectory(workingDir);
            throw new UncheckedIOException("Failed to setup mappings: " + dependency.getDepString(), e);
        }
        return mappingProvider;
    }

    public TinyMappingsService getMappingsService(SharedServiceManager serviceManager) {
        return TinyMappingsService.create(serviceManager, Objects.requireNonNull(this.tinyMappings));
    }

    private void setup(Project project, SharedServiceManager serviceManager, MinecraftProvider minecraftProvider, Path inputJar) throws IOException {
        if (minecraftProvider.refreshDeps()) {
            MappingConfiguration.cleanWorkingDirectory(this.mappingsWorkingDir);
        }
        if (Files.notExists(this.tinyMappings, new LinkOption[0]) || minecraftProvider.refreshDeps()) {
            this.storeMappings(project, serviceManager, minecraftProvider, inputJar);
        } else {
            try (FileSystem fileSystem = FileSystems.newFileSystem(inputJar, (ClassLoader)null);){
                this.extractExtras(fileSystem);
            }
        }
        if (Files.notExists(this.tinyMappingsJar, new LinkOption[0]) || minecraftProvider.refreshDeps()) {
            Files.deleteIfExists(this.tinyMappingsJar);
            ZipUtils.add(this.tinyMappingsJar, "mappings/mappings.tiny", Files.readAllBytes(this.tinyMappings));
        }
    }

    public void applyToProject(Project project, DependencyInfo dependency) {
        if (this.hasUnpickDefinitions()) {
            String notation = String.format("%s:%s:%s:constants", dependency.getDependency().getGroup(), dependency.getDependency().getName(), dependency.getDependency().getVersion());
            project.getDependencies().add("mappingsConstants", (Object)notation);
            this.populateUnpickClasspath(project);
        }
        project.getDependencies().add("mappingsFinal", (Object)project.files(new Object[]{this.tinyMappingsJar.toFile()}));
    }

    private static String getMappingsClassifier(DependencyInfo dependency, boolean isV2) {
        String[] depStringSplit = dependency.getDepString().split(":");
        if (depStringSplit.length >= 4) {
            return "-" + depStringSplit[3] + (isV2 ? "-v2" : "");
        }
        return isV2 ? "-v2" : "";
    }

    private void storeMappings(Project project, SharedServiceManager serviceManager, MinecraftProvider minecraftProvider, Path inputJar) throws IOException {
        LOGGER.info(":extracting " + inputJar.getFileName());
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(inputJar);){
            MappingConfiguration.extractMappings(delegate.fs(), this.baseTinyMappings);
            this.extractExtras(delegate.fs());
        }
        if (MappingConfiguration.areMappingsV2(this.baseTinyMappings)) {
            IntermediateMappingsService intermediateMappingsService = IntermediateMappingsService.getInstance(serviceManager, project, minecraftProvider);
            MappingsMerger.mergeAndSaveMappings(this.baseTinyMappings, this.tinyMappings, minecraftProvider, intermediateMappingsService);
        } else {
            List<Path> minecraftJars = minecraftProvider.getMinecraftJars();
            if (minecraftJars.size() != 1) {
                throw new UnsupportedOperationException("V1 mappings only support single jar minecraft providers");
            }
            Files.deleteIfExists(this.tinyMappings);
            LOGGER.info(":populating field names");
            this.suggestFieldNames(minecraftJars.get(0), this.baseTinyMappings, this.tinyMappings);
        }
    }

    private static boolean areMappingsV2(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            boolean bl = MappingReader.detectFormat((Reader)reader) == MappingFormat.TINY_2_FILE;
            return bl;
        }
    }

    public static void extractMappings(Path jar, Path extractTo) throws IOException {
        try (FileSystemUtil.Delegate delegate = FileSystemUtil.getJarFileSystem(jar);){
            MappingConfiguration.extractMappings(delegate.fs(), extractTo);
        }
    }

    public static void extractMappings(FileSystem jar, Path extractTo) throws IOException {
        Files.copy(jar.getPath("mappings/mappings.tiny", new String[0]), extractTo, StandardCopyOption.REPLACE_EXISTING);
    }

    private void extractExtras(FileSystem jar) throws IOException {
        this.extractUnpickDefinitions(jar);
        this.extractSignatureFixes(jar);
    }

    private void extractUnpickDefinitions(FileSystem jar) throws IOException {
        Path unpickPath = jar.getPath("extras/definitions.unpick", new String[0]);
        Path unpickMetadataPath = jar.getPath("extras/unpick.json", new String[0]);
        if (!Files.exists(unpickPath, new LinkOption[0]) || !Files.exists(unpickMetadataPath, new LinkOption[0])) {
            return;
        }
        Files.copy(unpickPath, this.unpickDefinitions, StandardCopyOption.REPLACE_EXISTING);
        this.unpickMetadata = this.parseUnpickMetadata(unpickMetadataPath);
        this.hasUnpickDefinitions = true;
    }

    private void extractSignatureFixes(FileSystem jar) throws IOException {
        Path recordSignaturesJsonPath = jar.getPath("extras/record_signatures.json", new String[0]);
        if (!Files.exists(recordSignaturesJsonPath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(recordSignaturesJsonPath, StandardCharsets.UTF_8);){
            this.signatureFixes = (Map)LoomGradlePlugin.GSON.fromJson((Reader)reader, Map.class);
        }
    }

    private UnpickMetadata parseUnpickMetadata(Path input) throws IOException {
        JsonObject jsonObject = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(input, StandardCharsets.UTF_8), JsonObject.class);
        if (!jsonObject.has("version") || jsonObject.get("version").getAsInt() != 1) {
            throw new UnsupportedOperationException("Unsupported unpick version");
        }
        return new UnpickMetadata(jsonObject.get("unpickGroup").getAsString(), jsonObject.get("unpickVersion").getAsString());
    }

    private void populateUnpickClasspath(Project project) {
        String[] asmDeps;
        String unpickCliName = "unpick-cli";
        project.getDependencies().add("unpick", (Object)String.format("%s:%s:%s", this.unpickMetadata.unpickGroup, unpickCliName, this.unpickMetadata.unpickVersion));
        for (String asm : asmDeps = new String[]{"org.ow2.asm:asm:%s", "org.ow2.asm:asm-tree:%s", "org.ow2.asm:asm-commons:%s", "org.ow2.asm:asm-util:%s"}) {
            project.getDependencies().add("unpick", (Object)asm.formatted(Opcodes.class.getPackage().getImplementationVersion()));
        }
    }

    private void suggestFieldNames(Path inputJar, Path oldMappings, Path newMappings) {
        CommandProposeFieldNames command = new CommandProposeFieldNames();
        this.runCommand((Command)command, inputJar.toFile().getAbsolutePath(), oldMappings.toAbsolutePath().toString(), newMappings.toAbsolutePath().toString());
    }

    private void runCommand(Command command, String ... args) {
        try {
            command.run(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void cleanWorkingDirectory(Path mappingsWorkingDir) {
        try {
            if (Files.exists(mappingsWorkingDir, new LinkOption[0])) {
                Files.walkFileTree(mappingsWorkingDir, new DeletingFileVisitor());
            }
            Files.createDirectories(mappingsWorkingDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Path mappingsWorkingDir() {
        return this.mappingsWorkingDir;
    }

    private static String createMappingsIdentifier(String mappingsName, String version, String classifier, String minecraftVersion) {
        return mappingsName + "." + minecraftVersion.replace(' ', '_').replace('.', '_').replace('-', '_') + "." + version + classifier;
    }

    public String mappingsIdentifier() {
        return this.mappingsIdentifier;
    }

    public File getUnpickDefinitionsFile() {
        return this.unpickDefinitions.toFile();
    }

    public boolean hasUnpickDefinitions() {
        return this.hasUnpickDefinitions;
    }

    @Nullable
    public Map<String, String> getSignatureFixes() {
        return this.signatureFixes;
    }

    public String getBuildServiceName(String name, String from, String to) {
        return "%s:%s:%s>%S".formatted(name, this.mappingsIdentifier(), from, to);
    }

    public record UnpickMetadata(String unpickGroup, String unpickVersion) {
    }
}

