/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.DependencyInfo;
import net.fabricmc.loom.configuration.providers.minecraft.ManifestVersion;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.MirrorUtil;
import net.fabricmc.loom.util.download.DownloadBuilder;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.jetbrains.annotations.Nullable;

public final class MinecraftMetadataProvider {
    private final Options options;
    private final Function<String, DownloadBuilder> download;
    private ManifestVersion.Versions versionEntry;
    private MinecraftVersionMeta versionMeta;

    private MinecraftMetadataProvider(Options options, Function<String, DownloadBuilder> download) {
        this.options = options;
        this.download = download;
    }

    public static MinecraftMetadataProvider create(ConfigContext configContext) {
        String minecraftVersion = MinecraftMetadataProvider.resolveMinecraftVersion(configContext.project());
        Path workingDir = MinecraftProvider.minecraftWorkingDirectory(configContext.project(), minecraftVersion).toPath();
        return new MinecraftMetadataProvider(Options.create(minecraftVersion, configContext.project(), workingDir.resolve("minecraft-info.json")), configContext.extension()::download);
    }

    private static String resolveMinecraftVersion(Project project) {
        DependencyInfo dependency = DependencyInfo.create(project, "minecraft");
        return dependency.getDependency().getVersion();
    }

    public String getMinecraftVersion() {
        return this.options.minecraftVersion();
    }

    public MinecraftVersionMeta getVersionMeta() {
        try {
            if (this.versionEntry == null) {
                this.versionEntry = this.getVersionEntry();
            }
            if (this.versionMeta == null) {
                this.versionMeta = this.readVersionMeta();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        return this.versionMeta;
    }

    private ManifestVersion.Versions getVersionEntry() throws IOException {
        if (this.options.customManifestUrl() != null) {
            ManifestVersion.Versions customVersion = new ManifestVersion.Versions();
            customVersion.id = this.options.minecraftVersion();
            customVersion.url = this.options.customManifestUrl();
            return customVersion;
        }
        List<ManifestVersionSupplier> suppliers = List.of(() -> this.getVersions(false), () -> this.getExperimentalVersions(false), () -> this.getVersions(true), () -> this.getExperimentalVersions(true));
        for (ManifestVersionSupplier supplier : suppliers) {
            ManifestVersion.Versions version = supplier.get().getVersion(this.options.minecraftVersion());
            if (version == null) continue;
            return version;
        }
        throw new RuntimeException("Failed to find minecraft version: " + this.options.minecraftVersion());
    }

    private ManifestVersion getVersions(boolean forceDownload) throws IOException {
        return this.getVersions(this.options.versionManifestUrl(), this.options.versionManifestPath(), forceDownload);
    }

    private ManifestVersion getExperimentalVersions(boolean forceDownload) throws IOException {
        return this.getVersions(this.options.experimentalVersionManifestUrl(), this.options.experimentalVersionManifestPath(), forceDownload);
    }

    private ManifestVersion getVersions(String url, Path cacheFile, boolean forceDownload) throws IOException {
        DownloadBuilder builder = this.download.apply(url);
        builder = forceDownload ? builder.forceDownload() : builder.defaultCache();
        String versionManifest = builder.downloadString(cacheFile);
        return (ManifestVersion)LoomGradlePlugin.GSON.fromJson(versionManifest, ManifestVersion.class);
    }

    private MinecraftVersionMeta readVersionMeta() throws IOException {
        DownloadBuilder builder = this.download.apply(this.versionEntry.url);
        if (this.versionEntry.sha1 != null) {
            builder.sha1(this.versionEntry.sha1);
        } else {
            builder.defaultCache();
        }
        String json = builder.downloadString(this.options.minecraftMetadataPath());
        return (MinecraftVersionMeta)LoomGradlePlugin.GSON.fromJson(json, MinecraftVersionMeta.class);
    }

    public record Options(String minecraftVersion, String versionManifestUrl, String experimentalVersionManifestUrl, @Nullable String customManifestUrl, Path versionManifestPath, Path experimentalVersionManifestPath, Path minecraftMetadataPath) {
        public static Options create(String minecraftVersion, Project project, Path minecraftMetadataPath) {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            Path userCache = extension.getFiles().getUserCache().toPath();
            return new Options(minecraftVersion, MirrorUtil.getVersionManifests((ExtensionAware)project), MirrorUtil.getExperimentalVersions((ExtensionAware)project), (String)extension.getCustomMinecraftManifest().getOrNull(), userCache.resolve("version_manifest.json"), userCache.resolve("experimental_version_manifest.json"), minecraftMetadataPath);
        }
    }

    @FunctionalInterface
    private static interface ManifestVersionSupplier {
        public ManifestVersion get() throws IOException;
    }
}

