/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft.mapped;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.mods.dependency.LocalMavenHelper;
import net.fabricmc.loom.configuration.processors.MinecraftJarProcessorManager;
import net.fabricmc.loom.configuration.processors.ProcessorContextImpl;
import net.fabricmc.loom.configuration.providers.minecraft.LegacyMergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MergedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftSourceSets;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarEnvType;
import net.fabricmc.loom.configuration.providers.minecraft.SingleJarMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.SplitMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.AbstractMappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.MappedMinecraftProvider;
import net.fabricmc.loom.configuration.providers.minecraft.mapped.NamedMinecraftProvider;

public abstract class ProcessedNamedMinecraftProvider<M extends MinecraftProvider, P extends NamedMinecraftProvider<M>>
extends NamedMinecraftProvider<M> {
    private final P parentMinecraftProvider;
    private final MinecraftJarProcessorManager jarProcessorManager;

    public ProcessedNamedMinecraftProvider(P parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
        super(((AbstractMappedMinecraftProvider)parentMinecraftProvide).getProject(), ((AbstractMappedMinecraftProvider)parentMinecraftProvide).getMinecraftProvider());
        this.parentMinecraftProvider = parentMinecraftProvide;
        this.jarProcessorManager = Objects.requireNonNull(jarProcessorManager);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<MinecraftJar> provide(AbstractMappedMinecraftProvider.ProvideContext context) throws Exception {
        this.parentMinecraftProvider.provide(context.withApplyDependencies(false));
        if (context.refreshOutputs()) ** GOTO lbl-1000
        if (this.parentMinecraftProvider.getMinecraftJars().stream().map((Function<MinecraftJar, Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getProcessedPath(net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar ), (Lnet/fabricmc/loom/configuration/providers/minecraft/MinecraftJar;)Ljava/nio/file/Path;)((ProcessedNamedMinecraftProvider)this)).anyMatch((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, requiresProcessingJar(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)((MinecraftJarProcessorManager)this.jarProcessorManager))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        requiresProcessing = v0;
        minecraftJarOutputMap = this.parentMinecraftProvider.getMinecraftJars().stream().collect(Collectors.toMap(Function.identity(), (Function<MinecraftJar, MinecraftJar>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getProcessedJar(net.fabricmc.loom.configuration.providers.minecraft.MinecraftJar ), (Lnet/fabricmc/loom/configuration/providers/minecraft/MinecraftJar;)Lnet/fabricmc/loom/configuration/providers/minecraft/MinecraftJar;)((ProcessedNamedMinecraftProvider)this)));
        if (requiresProcessing) {
            this.processJars(minecraftJarOutputMap, context.configContext());
        }
        if (context.applyDependencies()) {
            this.applyDependencies();
        }
        return List.copyOf(minecraftJarOutputMap.values());
    }

    @Override
    public AbstractMappedMinecraftProvider.MavenScope getMavenScope() {
        return AbstractMappedMinecraftProvider.MavenScope.LOCAL;
    }

    private void processJars(Map<MinecraftJar, MinecraftJar> minecraftJarMap, ConfigContext configContext) throws IOException {
        for (Map.Entry<MinecraftJar, MinecraftJar> entry : minecraftJarMap.entrySet()) {
            MinecraftJar minecraftJar = entry.getKey();
            MinecraftJar outputJar = entry.getValue();
            this.deleteSimilarJars(outputJar.getPath());
            LocalMavenHelper mavenHelper = this.getMavenHelper(minecraftJar.getType());
            Path outputPath = mavenHelper.copyToMaven(minecraftJar.getPath(), null);
            assert (outputJar.getPath().equals(outputPath));
            this.jarProcessorManager.processJar(outputPath, new ProcessorContextImpl(configContext, minecraftJar));
        }
    }

    @Override
    public List<MinecraftJar.Type> getDependencyTypes() {
        return ((AbstractMappedMinecraftProvider)this.parentMinecraftProvider).getDependencyTypes();
    }

    private void applyDependencies() {
        List<MinecraftJar.Type> dependencyTargets = this.getDependencyTypes();
        if (dependencyTargets.isEmpty()) {
            return;
        }
        MinecraftSourceSets.get(this.getProject()).applyDependencies((configuration, name) -> this.getProject().getDependencies().add(configuration, (Object)this.getDependencyNotation((MinecraftJar.Type)((Object)name))), dependencyTargets);
    }

    private void deleteSimilarJars(Path jar) throws IOException {
        Files.deleteIfExists(jar);
        Path parent = jar.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            return;
        }
        for (Path path2 : Files.list(parent).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().startsWith(jar.getFileName().toString().replace(".jar", ""))).toList()) {
            Files.deleteIfExists(path2);
        }
    }

    @Override
    protected String getName(MinecraftJar.Type type) {
        return "minecraft-%s-%s".formatted(type.toString(), this.jarProcessorManager.getJarHash());
    }

    @Override
    public Path getJar(MinecraftJar.Type type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractMappedMinecraftProvider.RemappedJars> getRemappedJars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<MinecraftJar> getMinecraftJars() {
        return this.getParentMinecraftProvider().getMinecraftJars().stream().map(this::getProcessedJar).toList();
    }

    public P getParentMinecraftProvider() {
        return this.parentMinecraftProvider;
    }

    private Path getProcessedPath(MinecraftJar minecraftJar) {
        LocalMavenHelper mavenHelper = this.getMavenHelper(minecraftJar.getType());
        return mavenHelper.getOutputFile(null);
    }

    public MinecraftJar getProcessedJar(MinecraftJar minecraftJar) {
        return minecraftJar.forPath(this.getProcessedPath(minecraftJar));
    }

    public static final class SingleJarImpl
    extends ProcessedNamedMinecraftProvider<SingleJarMinecraftProvider, NamedMinecraftProvider.SingleJarImpl>
    implements MappedMinecraftProvider.SingleJar {
        private final SingleJarEnvType env;

        private SingleJarImpl(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager, SingleJarEnvType env) {
            super(parentMinecraftProvide, jarProcessorManager);
            this.env = env;
        }

        public static SingleJarImpl server(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            return new SingleJarImpl(parentMinecraftProvide, jarProcessorManager, SingleJarEnvType.SERVER);
        }

        public static SingleJarImpl client(NamedMinecraftProvider.SingleJarImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            return new SingleJarImpl(parentMinecraftProvide, jarProcessorManager, SingleJarEnvType.CLIENT);
        }

        @Override
        public MinecraftJar getEnvOnlyJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.SingleJarImpl)this.getParentMinecraftProvider()).getEnvOnlyJar());
        }

        @Override
        public SingleJarEnvType env() {
            return this.env;
        }
    }

    public static final class SplitImpl
    extends ProcessedNamedMinecraftProvider<SplitMinecraftProvider, NamedMinecraftProvider.SplitImpl>
    implements MappedMinecraftProvider.Split {
        public SplitImpl(NamedMinecraftProvider.SplitImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            super(parentMinecraftProvide, jarProcessorManager);
        }

        @Override
        public MinecraftJar getCommonJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.SplitImpl)this.getParentMinecraftProvider()).getCommonJar());
        }

        @Override
        public MinecraftJar getClientOnlyJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.SplitImpl)this.getParentMinecraftProvider()).getClientOnlyJar());
        }
    }

    public static final class LegacyMergedImpl
    extends ProcessedNamedMinecraftProvider<LegacyMergedMinecraftProvider, NamedMinecraftProvider.LegacyMergedImpl>
    implements MappedMinecraftProvider.Merged {
        public LegacyMergedImpl(NamedMinecraftProvider.LegacyMergedImpl parentMinecraftProvider, MinecraftJarProcessorManager jarProcessorManager) {
            super(parentMinecraftProvider, jarProcessorManager);
        }

        @Override
        public MinecraftJar getMergedJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.LegacyMergedImpl)this.getParentMinecraftProvider()).getMergedJar());
        }
    }

    public static final class MergedImpl
    extends ProcessedNamedMinecraftProvider<MergedMinecraftProvider, NamedMinecraftProvider.MergedImpl>
    implements MappedMinecraftProvider.Merged {
        public MergedImpl(NamedMinecraftProvider.MergedImpl parentMinecraftProvide, MinecraftJarProcessorManager jarProcessorManager) {
            super(parentMinecraftProvide, jarProcessorManager);
        }

        @Override
        public MinecraftJar getMergedJar() {
            return this.getProcessedJar(((NamedMinecraftProvider.MergedImpl)this.getParentMinecraftProvider()).getMergedJar());
        }
    }
}

