/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loom.decompilers.ClassLineNumbers;
import net.fabricmc.loom.decompilers.cache.CachedData;
import net.fabricmc.loom.decompilers.cache.CachedFileStore;
import net.fabricmc.loom.decompilers.cache.ClassEntry;
import net.fabricmc.loom.decompilers.cache.JarWalker;
import net.fabricmc.loom.util.FileSystemUtil;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CachedJarProcessor(CachedFileStore<CachedData> fileStore, String baseHash) {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedJarProcessor.class);

    public WorkRequest prepareJob(Path inputJar) throws IOException {
        boolean isIncomplete = false;
        boolean hasSomeExisting = false;
        Path incompleteJar = Files.createTempFile("loom-cache-incomplete", ".jar", new FileAttribute[0]);
        Path existingJar = Files.createTempFile("loom-cache-existing", ".jar", new FileAttribute[0]);
        Files.delete(incompleteJar);
        Files.delete(existingJar);
        HashMap<String, String> outputNameMap = new HashMap<String, String>();
        HashMap<String, ClassLineNumbers.Entry> lineNumbersMap = new HashMap<String, ClassLineNumbers.Entry>();
        int hits = 0;
        int misses = 0;
        try (FileSystemUtil.Delegate inputFs = FileSystemUtil.getJarFileSystem(inputJar, false);
             FileSystemUtil.Delegate incompleteFs = FileSystemUtil.getJarFileSystem(incompleteJar, true);
             FileSystemUtil.Delegate existingFs = FileSystemUtil.getJarFileSystem(existingJar, true);){
            List<ClassEntry> inputClasses = JarWalker.findClasses(inputFs);
            for (ClassEntry entry : inputClasses) {
                String outputFileName = entry.sourcesFileName();
                String fullHash = this.baseHash + "/" + entry.hash(inputFs.getRoot());
                CachedData entryData = this.fileStore.getEntry(fullHash);
                if (entryData == null) {
                    entry.copyTo(inputFs.getRoot(), incompleteFs.getRoot());
                    isIncomplete = true;
                    outputNameMap.put(outputFileName, fullHash);
                    LOGGER.debug("Cached entry ({}) not found, going to process {}", (Object)fullHash, (Object)outputFileName);
                    ++misses;
                    continue;
                }
                Path outputPath = existingFs.getPath(outputFileName, new String[0]);
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                Files.writeString(outputPath, (CharSequence)entryData.sources(), new OpenOption[0]);
                if (entryData.lineNumbers() != null) {
                    lineNumbersMap.put(entryData.className(), entryData.lineNumbers());
                } else {
                    LOGGER.info("Cached entry ({}) does not have line numbers", (Object)outputFileName);
                }
                hasSomeExisting = true;
                LOGGER.debug("Cached entry ({}) found: {}", (Object)fullHash, (Object)outputFileName);
                ++hits;
            }
        }
        Path outputJar = Files.createTempFile("loom-cache-output", ".jar", new FileAttribute[0]);
        Files.delete(outputJar);
        ClassLineNumbers lineNumbers = lineNumbersMap.isEmpty() ? null : new ClassLineNumbers(Collections.unmodifiableMap(lineNumbersMap));
        CacheStats stats = new CacheStats(hits, misses);
        if (isIncomplete && !hasSomeExisting) {
            Files.delete(incompleteJar);
            Files.delete(existingJar);
            LOGGER.info("No cached entries found, going to process the whole jar");
            return new FullWorkJob(inputJar, outputJar, outputNameMap).asRequest(stats, lineNumbers);
        }
        if (isIncomplete) {
            LOGGER.info("Some cached entries found, using partial work job");
            return new PartialWorkJob(incompleteJar, existingJar, outputJar, outputNameMap).asRequest(stats, lineNumbers);
        }
        LOGGER.info("All cached entries found, using completed work job");
        Files.delete(incompleteJar);
        return new CompletedWorkJob(existingJar).asRequest(stats, lineNumbers);
    }

    public void completeJob(Path output, WorkJob workJob, ClassLineNumbers lineNumbers) throws IOException {
        block41: {
            if (workJob instanceof CompletedWorkJob) {
                CompletedWorkJob completedWorkJob = (CompletedWorkJob)workJob;
                Files.move(completedWorkJob.completed(), output, new CopyOption[0]);
                return;
            }
            if (workJob instanceof WorkToDoJob) {
                WorkToDoJob workToDoJob = (WorkToDoJob)workJob;
                Map<String, String> outputNameMap = workToDoJob.outputNameMap();
                try (FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(workToDoJob.output(), false);
                     Stream<Path> walk = Files.walk(outputFs.getRoot(), new FileVisitOption[0]);){
                    Iterator iterator = walk.iterator();
                    while (iterator.hasNext()) {
                        Path fsPath = (Path)iterator.next();
                        if (fsPath.startsWith("/META-INF/") || !Files.isRegularFile(fsPath, new LinkOption[0])) continue;
                        String hash = outputNameMap.get(fsPath.toString().substring(outputFs.getRoot().toString().length()));
                        if (hash == null) {
                            throw new IllegalStateException("Unexpected output: " + fsPath);
                        }
                        String className = fsPath.toString().substring(1, fsPath.toString().length() - ".java".length());
                        String sources = Files.readString(fsPath);
                        ClassLineNumbers.Entry lineMapEntry = null;
                        if (lineNumbers != null) {
                            lineMapEntry = lineNumbers.lineMap().get(className);
                        }
                        if (lineMapEntry == null) {
                            LOGGER.info("No line numbers generated for class: {}", (Object)className);
                        }
                        CachedData cachedData = new CachedData(className, sources, lineMapEntry);
                        this.fileStore.putEntry(hash, cachedData);
                        LOGGER.debug("Saving processed entry ({}) to cache: {}", (Object)hash, (Object)fsPath);
                    }
                    break block41;
                }
            }
            throw new IllegalStateException();
        }
        if (workJob instanceof PartialWorkJob) {
            PartialWorkJob partialWorkJob = (PartialWorkJob)workJob;
            try (FileSystemUtil.Delegate outputFs = FileSystemUtil.getJarFileSystem(partialWorkJob.output(), false);
                 FileSystemUtil.Delegate existingFs = FileSystemUtil.getJarFileSystem(partialWorkJob.existing(), false);
                 Stream<Path> walk = Files.walk(existingFs.getRoot(), new FileVisitOption[0]);){
                Iterator iterator = walk.iterator();
                while (iterator.hasNext()) {
                    Path existingPath = (Path)iterator.next();
                    if (!Files.isRegularFile(existingPath, new LinkOption[0])) continue;
                    Path outputPath = outputFs.getRoot().resolve(existingPath.toString());
                    LOGGER.debug("Copying existing entry to output: {}", (Object)existingPath);
                    Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                    Files.copy(existingPath, outputPath, new CopyOption[0]);
                }
            }
            Files.delete(partialWorkJob.existing());
            Files.move(partialWorkJob.output(), output, new CopyOption[0]);
        } else if (workJob instanceof FullWorkJob) {
            FullWorkJob fullWorkJob = (FullWorkJob)workJob;
            Files.move(fullWorkJob.output, output, new CopyOption[0]);
        } else {
            throw new IllegalStateException();
        }
    }

    public record CacheStats(int hits, int misses) {
    }

    public record FullWorkJob(Path incomplete, Path output, Map<String, String> outputNameMap) implements WorkToDoJob
    {
    }

    public record WorkRequest(WorkJob job, CacheStats stats, @Nullable ClassLineNumbers lineNumbers) {
    }

    public record PartialWorkJob(Path incomplete, Path existing, Path output, Map<String, String> outputNameMap) implements WorkToDoJob
    {
    }

    public record CompletedWorkJob(Path completed) implements WorkJob
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WorkToDoJob
    extends WorkJob {
        public Path incomplete();

        public Path output();

        public Map<String, String> outputNameMap();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WorkJob {
        default public WorkRequest asRequest(CacheStats stats, @Nullable ClassLineNumbers lineNumbers) {
            return new WorkRequest(this, stats, lineNumbers);
        }
    }
}

