/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.decompilers.cache;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.loom.decompilers.cache.ClassEntry;
import net.fabricmc.loom.util.FileSystemUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarWalker {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarWalker.class);

    private JarWalker() {
    }

    public static List<ClassEntry> findClasses(Path jar) throws IOException {
        try (FileSystemUtil.Delegate fs = FileSystemUtil.getJarFileSystem(jar);){
            List<ClassEntry> list = JarWalker.findClasses(fs);
            return list;
        }
    }

    public static List<ClassEntry> findClasses(FileSystemUtil.Delegate fs) throws IOException {
        ArrayList<String> outerClasses = new ArrayList<String>();
        HashMap<String, List> innerClasses = new HashMap<String, List>();
        try (Stream<Path> walk = Files.walk(fs.getRoot(), new FileVisitOption[0]);){
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                String fileName;
                Path entry = (Path)iterator.next();
                if (!Files.isRegularFile(entry, new LinkOption[0]) || !(fileName = entry.toString().substring(fs.getRoot().toString().length())).endsWith(".class")) continue;
                boolean isInnerClass = fileName.contains("$");
                if (isInnerClass) {
                    String outerClassName = fileName.substring(0, fileName.indexOf(36)) + ".class";
                    innerClasses.computeIfAbsent(outerClassName, k -> new ArrayList()).add(fileName);
                    continue;
                }
                outerClasses.add(fileName);
            }
        }
        LOGGER.info("Found {} outer classes and {} inner classes", (Object)outerClasses.size(), (Object)innerClasses.size());
        Collections.sort(outerClasses);
        ArrayList<ClassEntry> classEntries = new ArrayList<ClassEntry>();
        for (String outerClass : outerClasses) {
            List innerClasList = (List)innerClasses.get(outerClass);
            if (innerClasList == null) {
                innerClasList = Collections.emptyList();
            } else {
                Collections.sort(innerClasList);
            }
            ClassEntry classEntry = new ClassEntry(outerClass, Collections.unmodifiableList(innerClasList));
            classEntries.add(classEntry);
        }
        return Collections.unmodifiableList(classEntries);
    }
}

