/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.loom.LoomGradlePlugin;
import net.fabricmc.loom.configuration.ide.RunConfig;
import net.fabricmc.loom.configuration.ide.RunConfigSettings;
import net.fabricmc.loom.task.AbstractLoomTask;
import net.fabricmc.loom.util.gradle.SyncTaskBuildService;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.TaskAction;

public abstract class GenVsCodeProjectTask
extends AbstractLoomTask {
    @ServiceReference(value="loomSyncTask")
    abstract Property<SyncTaskBuildService> getSyncTask();

    @TaskAction
    public void genRuns() throws IOException {
        JsonArray configurations;
        JsonObject root;
        Path launchJson;
        Path projectDir = this.getProject().getRootDir().toPath().resolve(".vscode");
        if (Files.notExists(projectDir, new LinkOption[0])) {
            Files.createDirectories(projectDir, new FileAttribute[0]);
        }
        if (Files.exists(launchJson = projectDir.resolve("launch.json"), new LinkOption[0])) {
            root = (JsonObject)LoomGradlePlugin.GSON.fromJson(Files.readString(launchJson, StandardCharsets.UTF_8), JsonObject.class);
        } else {
            root = new JsonObject();
            root.addProperty("version", "0.2.0");
        }
        if (root.has("configurations")) {
            configurations = root.getAsJsonArray("configurations");
        } else {
            configurations = new JsonArray();
            root.add("configurations", (JsonElement)configurations);
        }
        for (RunConfigSettings settings : this.getExtension().getRunConfigs()) {
            if (!settings.isIdeConfigGenerated()) continue;
            VsCodeConfiguration configuration = new VsCodeConfiguration(RunConfig.runConfig(this.getProject(), settings));
            JsonElement configurationJson = LoomGradlePlugin.GSON.toJsonTree((Object)configuration);
            LinkedList<JsonElement> toRemove = new LinkedList<JsonElement>();
            for (JsonElement jsonElement : configurations) {
                JsonObject jsonObject;
                if (!jsonElement.isJsonObject() || !(jsonObject = jsonElement.getAsJsonObject()).has("name") || !jsonObject.get("name").getAsString().equalsIgnoreCase(configuration.name)) continue;
                toRemove.add(jsonElement);
            }
            toRemove.forEach(arg_0 -> ((JsonArray)configurations).remove(arg_0));
            configurations.add(configurationJson);
            settings.makeRunDir();
        }
        String json = LoomGradlePlugin.GSON.toJson((JsonElement)root);
        Files.writeString(launchJson, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private class VsCodeConfiguration {
        public String type = "java";
        public String name;
        public String request = "launch";
        public String cwd;
        public String console = "integratedTerminal";
        public boolean stopOnEntry = false;
        public String mainClass;
        public String vmArgs;
        public String args;
        public Map<String, Object> env;
        public String projectName;

        VsCodeConfiguration(RunConfig runConfig) {
            this.name = runConfig.configName;
            this.mainClass = runConfig.mainClass;
            this.vmArgs = RunConfig.joinArguments(runConfig.vmArgs);
            this.args = RunConfig.joinArguments(runConfig.programArgs);
            this.cwd = "${workspaceFolder}/" + runConfig.runDir;
            this.env = new HashMap<String, Object>(runConfig.environmentVariables);
            this.projectName = runConfig.projectName;
            if (GenVsCodeProjectTask.this.getProject().getRootProject() != GenVsCodeProjectTask.this.getProject()) {
                Path rootPath = GenVsCodeProjectTask.this.getProject().getRootDir().toPath();
                Path projectPath = GenVsCodeProjectTask.this.getProject().getProjectDir().toPath();
                String relativePath = rootPath.relativize(projectPath).toString();
                this.cwd = "${workspaceFolder}/%s/%s".formatted(relativePath, runConfig.runDir);
            }
        }
    }

    private class VsCodeLaunch {
        public String version = "0.2.0";
        public List<VsCodeConfiguration> configurations = new ArrayList<VsCodeConfiguration>();

        private VsCodeLaunch() {
        }

        public void add(RunConfig runConfig) {
            this.configurations.add(new VsCodeConfiguration(runConfig));
        }
    }
}

