/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.task.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.build.mixin.AnnotationProcessorInvoker;
import net.fabricmc.loom.extension.RemapperExtensionHolder;
import net.fabricmc.loom.task.AbstractRemapJarTask;
import net.fabricmc.loom.task.service.MappingsService;
import net.fabricmc.loom.util.gradle.GradleUtils;
import net.fabricmc.loom.util.gradle.SourceSetHelper;
import net.fabricmc.loom.util.kotlin.KotlinClasspath;
import net.fabricmc.loom.util.kotlin.KotlinClasspathService;
import net.fabricmc.loom.util.kotlin.KotlinRemapperClassloader;
import net.fabricmc.loom.util.service.SharedService;
import net.fabricmc.loom.util.service.SharedServiceManager;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.extension.mixin.MixinExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.Nullable;

public class TinyRemapperService
implements SharedService {
    private TinyRemapper tinyRemapper;
    @Nullable
    private KotlinRemapperClassloader kotlinRemapperClassloader;
    private final Map<String, InputTag> inputTagMap = new HashMap<String, InputTag>();
    private final HashSet<Path> classpath = new HashSet();
    private boolean isRemapping = false;

    public static synchronized TinyRemapperService getOrCreate(SharedServiceManager serviceManager, AbstractRemapJarTask remapJarTask) {
        Project project = remapJarTask.getProject();
        String to = (String)remapJarTask.getTargetNamespace().get();
        String from = (String)remapJarTask.getSourceNamespace().get();
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        boolean legacyMixin = (Boolean)extension.getMixin().getUseLegacyMixinAp().get();
        @Nullable KotlinClasspathService kotlinClasspathService = KotlinClasspathService.getOrCreateIfRequired(serviceManager, project);
        boolean multiProjectOptimisation = extension.multiProjectOptimisation();
        StringJoiner joiner = new StringJoiner(":");
        joiner.add(extension.getMappingConfiguration().getBuildServiceName("remapJarService", from, to));
        joiner.add(remapJarTask.getName());
        if (kotlinClasspathService != null) {
            joiner.add("kotlin-" + kotlinClasspathService.version());
        }
        if (((Boolean)remapJarTask.getRemapperIsolation().get()).booleanValue() || !multiProjectOptimisation) {
            joiner.add(project.getPath());
        }
        ((Set)extension.getKnownIndyBsms().get()).stream().sorted().forEach(joiner::add);
        String id = joiner.toString();
        TinyRemapperService service = serviceManager.getOrCreateService(id, () -> {
            ArrayList<IMappingProvider> mappings = new ArrayList<IMappingProvider>();
            mappings.add(MappingsService.createDefault(project, serviceManager, from, to).getMappingsProvider());
            if (legacyMixin) {
                mappings.add(TinyRemapperService.gradleMixinMappingProvider(serviceManager, project.getGradle(), extension.getMappingConfiguration().mappingsIdentifier, from, to));
            }
            return new TinyRemapperService(mappings, !legacyMixin, kotlinClasspathService, (Set)extension.getKnownIndyBsms().get(), (List)extension.getRemapperExtensions().get(), from, to, project.getObjects());
        });
        ConfigurationContainer configurations = project.getConfigurations();
        ConfigurableFileCollection excludedMinecraftJars = project.files(new Object[0]);
        if (multiProjectOptimisation && !extension.isRootProject()) {
            MappingsNamespace mappingsNamespace = MappingsNamespace.of(from);
            if (mappingsNamespace != null) {
                for (Path minecraftJar : extension.getMinecraftJars(mappingsNamespace)) {
                    excludedMinecraftJars.from(new Object[]{minecraftJar.toFile()});
                }
            } else {
                project.getLogger().warn("Unable to find minecraft jar for namespace {}", (Object)from);
            }
        }
        List<Path> classPath = remapJarTask.getClasspath().minus((FileCollection)configurations.getByName("minecraftLibraries")).minus((FileCollection)configurations.getByName("minecraftRuntimeLibraries")).minus((FileCollection)excludedMinecraftJars).getFiles().stream().map(File::toPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
        service.readClasspath(classPath);
        return service;
    }

    private static IMappingProvider gradleMixinMappingProvider(SharedServiceManager serviceManager, Gradle gradle, String mappingId, String from, String to) {
        return out -> GradleUtils.allLoomProjects(gradle, project -> {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            if (!mappingId.equals(extension.getMappingConfiguration().mappingsIdentifier)) {
                return;
            }
            for (SourceSet sourceSet : SourceSetHelper.getSourceSets(project)) {
                File mixinMappings = AnnotationProcessorInvoker.getMixinMappingsForSourceSet(project, sourceSet);
                if (!mixinMappings.exists()) continue;
                MappingsService service = MappingsService.create(serviceManager, mixinMappings.getAbsolutePath(), mixinMappings.toPath(), from, to, false);
                service.getMappingsProvider().load(out);
            }
        });
    }

    private TinyRemapperService(List<IMappingProvider> mappings, boolean useMixinExtension, @Nullable KotlinClasspath kotlinClasspath, Set<String> knownIndyBsms, List<RemapperExtensionHolder> remapperExtensions, String sourceNamespace, String targetNamespace, ObjectFactory objectFactory) {
        TinyRemapper.Builder builder = TinyRemapper.newRemapper().withKnownIndyBsm(knownIndyBsms);
        for (IMappingProvider provider : mappings) {
            builder.withMappings(provider);
        }
        if (useMixinExtension) {
            builder.extension((TinyRemapper.Extension)new MixinExtension());
        }
        if (kotlinClasspath != null) {
            this.kotlinRemapperClassloader = KotlinRemapperClassloader.create(kotlinClasspath);
            builder.extension((TinyRemapper.Extension)this.kotlinRemapperClassloader.getTinyRemapperExtension());
        }
        for (RemapperExtensionHolder holder : remapperExtensions) {
            holder.apply(builder, sourceNamespace, targetNamespace, objectFactory);
        }
        this.tinyRemapper = builder.build();
    }

    public synchronized InputTag getOrCreateTag(Path file) {
        InputTag tag = this.inputTagMap.get(file.toAbsolutePath().toString());
        if (tag == null) {
            tag = this.tinyRemapper.createInputTag();
            this.inputTagMap.put(file.toAbsolutePath().toString(), tag);
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TinyRemapper getTinyRemapperForRemapping() {
        TinyRemapperService tinyRemapperService = this;
        synchronized (tinyRemapperService) {
            this.isRemapping = true;
            return Objects.requireNonNull(this.tinyRemapper, "Tiny remapper has not been setup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TinyRemapper getTinyRemapperForInputs() {
        TinyRemapperService tinyRemapperService = this;
        synchronized (tinyRemapperService) {
            if (this.isRemapping) {
                throw new IllegalStateException("Cannot read inputs as remapping has already started");
            }
            return this.tinyRemapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readClasspath(List<Path> paths) {
        ArrayList<Path> toRead = new ArrayList<Path>();
        HashSet<Path> hashSet = this.classpath;
        synchronized (hashSet) {
            for (Path path : paths) {
                if (this.classpath.contains(path)) continue;
                toRead.add(path);
                this.classpath.add(path);
            }
        }
        if (toRead.isEmpty()) {
            return;
        }
        this.tinyRemapper.readClassPath((Path[])toRead.toArray(Path[]::new));
    }

    @Override
    public void close() throws IOException {
        if (this.tinyRemapper != null) {
            this.tinyRemapper.finish();
            this.tinyRemapper = null;
        }
        if (this.kotlinRemapperClassloader != null) {
            this.kotlinRemapperClassloader.close();
        }
    }
}

