/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.RemapConfigurationSettings;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.providers.mappings.MappingConfiguration;
import net.fabricmc.loom.task.service.LorenzMappingService;
import net.fabricmc.loom.util.DeletingFileVisitor;
import net.fabricmc.loom.util.FileSystemUtil;
import net.fabricmc.loom.util.LoomVersions;
import net.fabricmc.loom.util.ZipReprocessorUtil;
import net.fabricmc.loom.util.ZipUtils;
import net.fabricmc.loom.util.service.SharedServiceManager;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.remapper.MercuryRemapper;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.slf4j.Logger;

public class SourceRemapper {
    private final Project project;
    private final SharedServiceManager serviceManager;
    private final boolean toNamed;
    private final List<Consumer<ProgressLogger>> remapTasks = new ArrayList<Consumer<ProgressLogger>>();
    private Mercury mercury;

    public SourceRemapper(Project project, SharedServiceManager serviceManager, boolean toNamed) {
        this.project = project;
        this.serviceManager = serviceManager;
        this.toNamed = toNamed;
    }

    public void scheduleRemapSources(File source, File destination, boolean reproducibleFileOrder, boolean preserveFileTimestamps, Runnable completionCallback) {
        this.remapTasks.add(logger -> {
            try {
                logger.progress("remapping sources - " + source.getName());
                this.remapSourcesInner(source, destination);
                ZipReprocessorUtil.reprocessZip(destination.toPath(), reproducibleFileOrder, preserveFileTimestamps);
                destination.setLastModified(source.lastModified());
                completionCallback.run();
            }
            catch (Exception e) {
                destination.delete();
                throw new RuntimeException("Failed to remap sources for " + source, e);
            }
        });
    }

    public void remapAll() {
        if (this.remapTasks.isEmpty()) {
            return;
        }
        this.project.getLogger().lifecycle(":remapping sources");
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)((ProjectInternal)this.project).getServices().get(ProgressLoggerFactory.class);
        ProgressLogger progressLogger = progressLoggerFactory.newOperation(SourceRemapper.class.getName());
        progressLogger.start("Remapping dependency sources", "sources");
        this.remapTasks.forEach(consumer -> consumer.accept(progressLogger));
        progressLogger.completed();
        System.gc();
    }

    private void remapSourcesInner(File source, File destination) throws Exception {
        this.project.getLogger().info(":remapping source jar");
        Mercury mercury = this.getMercuryInstance();
        if (source.equals(destination)) {
            if (source.isDirectory()) {
                throw new RuntimeException("Directories must differ!");
            }
            source = new File(destination.getAbsolutePath().substring(0, destination.getAbsolutePath().lastIndexOf(46)) + "-dev.jar");
            try {
                com.google.common.io.Files.move((File)destination, (File)source);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not rename " + destination.getName() + "!", e);
            }
        }
        Path srcPath = source.toPath();
        boolean isSrcTmp = false;
        if (!source.isDirectory()) {
            isSrcTmp = true;
            srcPath = Files.createTempDirectory("fabric-loom-src", new FileAttribute[0]);
            ZipUtils.unpackAll(source.toPath(), srcPath);
        }
        if (!destination.isDirectory() && destination.exists() && !destination.delete()) {
            throw new RuntimeException("Could not delete " + destination.getName() + "!");
        }
        FileSystemUtil.Delegate dstFs = destination.isDirectory() ? null : FileSystemUtil.getJarFileSystem(destination, true);
        Path dstPath = dstFs != null ? dstFs.get().getPath("/", new String[0]) : destination.toPath();
        try {
            mercury.rewrite(srcPath, dstPath);
        }
        catch (Exception e) {
            this.project.getLogger().warn("Could not remap " + source.getName() + " fully!", (Throwable)e);
        }
        SourceRemapper.copyNonJavaFiles(srcPath, dstPath, (Logger)this.project.getLogger(), source.toPath());
        if (dstFs != null) {
            dstFs.close();
        }
        if (isSrcTmp) {
            Files.walkFileTree(srcPath, new DeletingFileVisitor());
        }
    }

    private Mercury getMercuryInstance() {
        if (this.mercury != null) {
            return this.mercury;
        }
        LoomGradleExtension extension = LoomGradleExtension.get(this.project);
        MappingConfiguration mappingConfiguration = extension.getMappingConfiguration();
        MappingSet mappings = LorenzMappingService.create(this.serviceManager, mappingConfiguration, this.toNamed ? MappingsNamespace.INTERMEDIARY : MappingsNamespace.NAMED, this.toNamed ? MappingsNamespace.NAMED : MappingsNamespace.INTERMEDIARY).mappings();
        Mercury mercury = SourceRemapper.createMercuryWithClassPath(this.project, this.toNamed);
        mercury.setSourceCompatibilityFromRelease(SourceRemapper.getJavaCompileRelease(this.project));
        for (File file : extension.getUnmappedModCollection()) {
            Path path = file.toPath();
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            mercury.getClassPath().add(path);
        }
        for (Path intermediaryJar : extension.getMinecraftJars(MappingsNamespace.INTERMEDIARY)) {
            mercury.getClassPath().add(intermediaryJar);
        }
        for (Path intermediaryJar : extension.getMinecraftJars(MappingsNamespace.NAMED)) {
            mercury.getClassPath().add(intermediaryJar);
        }
        Set files = this.project.getConfigurations().detachedConfiguration(new Dependency[]{this.project.getDependencies().create((Object)LoomVersions.JETBRAINS_ANNOTATIONS.mavenNotation())}).resolve();
        for (File file : files) {
            mercury.getClassPath().add(file.toPath());
        }
        mercury.getProcessors().add(MercuryRemapper.create((MappingSet)mappings));
        this.mercury = mercury;
        return this.mercury;
    }

    public static int getJavaCompileRelease(Project project) {
        AtomicInteger release = new AtomicInteger(-1);
        project.getTasks().withType(JavaCompile.class, javaCompile -> {
            Property releaseProperty = javaCompile.getOptions().getRelease();
            if (!releaseProperty.isPresent()) {
                return;
            }
            int compileRelease = (Integer)releaseProperty.get();
            release.set(Math.max(release.get(), compileRelease));
        });
        int i = release.get();
        if (i < 0) {
            return Integer.parseInt(JavaVersion.current().getMajorVersion());
        }
        return i;
    }

    public static void copyNonJavaFiles(Path from, Path to, Logger logger, Path source) throws IOException {
        Files.walk(from, new FileVisitOption[0]).forEach(path -> {
            Path targetPath = to.resolve(from.relativize((Path)path).toString());
            if (!SourceRemapper.isJavaFile(path) && !Files.exists(targetPath, new LinkOption[0])) {
                try {
                    Files.copy(path, targetPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    logger.warn("Could not copy non-java sources '" + source + "' fully!", (Throwable)e);
                }
            }
        });
    }

    public static Mercury createMercuryWithClassPath(Project project, boolean toNamed) {
        Mercury m = new Mercury();
        m.setGracefulClasspathChecks(true);
        ArrayList<Path> classPath = new ArrayList<Path>();
        for (Object file : project.getConfigurations().getByName("minecraftLibraries").getFiles()) {
            classPath.add(((File)file).toPath());
        }
        if (!toNamed) {
            for (Object file : project.getConfigurations().getByName("compileClasspath").getFiles()) {
                classPath.add(((File)file).toPath());
            }
        } else {
            LoomGradleExtension extension = LoomGradleExtension.get(project);
            for (RemapConfigurationSettings entry : extension.getRemapConfigurations()) {
                for (File inputFile : ((Configuration)entry.getSourceConfiguration().get()).getFiles()) {
                    classPath.add(inputFile.toPath());
                }
            }
        }
        for (Path path : classPath) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            m.getClassPath().add(path);
        }
        return m;
    }

    private static boolean isJavaFile(Path path) {
        String name = path.getFileName().toString();
        return name.endsWith(".java") && name.length() != 5;
    }
}

