/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.build.mixin;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.build.mixin.AnnotationProcessorInvoker;
import net.fabricmc.loom.extension.MixinExtension;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;

public class KaptApInvoker
extends AnnotationProcessorInvoker<JavaCompile> {
    private final KaptExtension kaptExtension;
    private final File dummyRefmapDirectory;

    public KaptApInvoker(Project project) {
        super(project, AnnotationProcessorInvoker.getApConfigurations(project, KaptApInvoker::getKaptConfigurationName), KaptApInvoker.getInvokerTasks(project), "Kotlin");
        this.kaptExtension = (KaptExtension)this.project.getExtensions().getByType(KaptExtension.class);
        try {
            this.dummyRefmapDirectory = Files.createTempDirectory("temp_refmap", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dummyRefmapDirectory.deleteOnExit();
        this.kaptExtension.setIncludeCompileClasspath(Boolean.valueOf(false));
    }

    private static Map<SourceSet, JavaCompile> getInvokerTasks(Project project) {
        MixinExtension mixin = LoomGradleExtension.get(project).getMixin();
        return mixin.getInvokerTasksStream("java").collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.requireNonNull((JavaCompile)entry.getValue())));
    }

    @Override
    public void configureMixin() {
        super.configureMixin();
        for (Map.Entry entry : this.invokerTasks.entrySet()) {
            JavaCompile task = (JavaCompile)entry.getValue();
            SourceSet sourceSet = (SourceSet)entry.getKey();
            task.doLast(t -> {
                try {
                    String refmapName = (String)Objects.requireNonNull(MixinExtension.getMixinInformationContainer(sourceSet)).refmapNameProvider().get();
                    Path src = Paths.get(this.getRefmapDestination(task, refmapName), new String[0]);
                    Path dest = Paths.get(((Directory)task.getDestinationDirectory().get()).getAsFile().toString(), refmapName);
                    if (Files.exists(src, new LinkOption[0])) {
                        this.project.getLogger().info("Copying refmap from " + String.valueOf(src) + " to " + String.valueOf(dest));
                        Files.move(src, dest, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    this.project.getLogger().warn("Could not move refmap generated by kapt for task " + String.valueOf(task), (Throwable)e);
                }
            });
        }
    }

    private static String getKaptConfigurationName(SourceSet sourceSet) {
        String sourceSetName = sourceSet.getName();
        if (!sourceSetName.equals("main")) {
            return "kapt" + sourceSetName.substring(0, 1).toUpperCase() + sourceSetName.substring(1);
        }
        return "kapt";
    }

    @Override
    protected void passArgument(JavaCompile compileTask, String key, String value) {
        this.kaptExtension.arguments(args -> {
            args.arg(key, new String[]{value});
            return Unit.INSTANCE;
        });
    }

    @Override
    protected File getRefmapDestinationDir(JavaCompile task) {
        return this.dummyRefmapDirectory;
    }
}

