/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.mappings.mojmap;

import java.io.UncheckedIOException;
import java.nio.file.Path;
import net.fabricmc.loom.api.mappings.layered.MappingContext;
import net.fabricmc.loom.api.mappings.layered.spec.MappingsSpec;
import net.fabricmc.loom.configuration.providers.mappings.mojmap.MojangMappingLayer;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.download.DownloadException;

public record MojangMappingsSpec(boolean nameSyntheticMembers) implements MappingsSpec<MojangMappingLayer>
{
    private static final String MANIFEST_CLIENT_MAPPINGS = "client_mappings";
    private static final String MANIFEST_SERVER_MAPPINGS = "server_mappings";

    @Override
    public MojangMappingLayer createLayer(MappingContext context) {
        MinecraftVersionMeta versionInfo = context.minecraftProvider().getVersionInfo();
        MinecraftVersionMeta.Download clientDownload = versionInfo.download(MANIFEST_CLIENT_MAPPINGS);
        MinecraftVersionMeta.Download serverDownload = versionInfo.download(MANIFEST_SERVER_MAPPINGS);
        if (clientDownload == null) {
            throw new RuntimeException("Failed to find official mojang mappings for " + context.minecraftVersion());
        }
        Path clientMappings = context.workingDirectory("mojang").resolve("client.txt");
        Path serverMappings = context.workingDirectory("mojang").resolve("server.txt");
        try {
            context.download(clientDownload.url()).sha1(clientDownload.sha1()).downloadPath(clientMappings);
            context.download(serverDownload.url()).sha1(serverDownload.sha1()).downloadPath(serverMappings);
        }
        catch (DownloadException e) {
            throw new UncheckedIOException("Failed to download mappings", e);
        }
        return new MojangMappingLayer(clientMappings, serverMappings, this.nameSyntheticMembers(), context.getLogger());
    }
}

