/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MinecraftClassMerger {
    private static final String SIDE_DESCRIPTOR = "Lnet/fabricmc/api/EnvType;";
    private static final String ITF_DESCRIPTOR = "Lnet/fabricmc/api/EnvironmentInterface;";
    private static final String ITF_LIST_DESCRIPTOR = "Lnet/fabricmc/api/EnvironmentInterfaces;";
    private static final String SIDED_DESCRIPTOR = "Lnet/fabricmc/api/Environment;";

    private static void visitSideAnnotation(AnnotationVisitor av, String side) {
        av.visitEnum("value", SIDE_DESCRIPTOR, side.toUpperCase(Locale.ROOT));
        av.visitEnd();
    }

    private static void visitItfAnnotation(AnnotationVisitor av, String side, List<String> itfDescriptors) {
        for (String itf : itfDescriptors) {
            AnnotationVisitor avItf = av.visitAnnotation(null, ITF_DESCRIPTOR);
            avItf.visitEnum("value", SIDE_DESCRIPTOR, side.toUpperCase(Locale.ROOT));
            avItf.visit("itf", (Object)Type.getType((String)("L" + itf + ";")));
            avItf.visitEnd();
        }
    }

    public byte[] merge(byte[] classClient, byte[] classServer) {
        ClassReader readerC = new ClassReader(classClient);
        ClassReader readerS = new ClassReader(classServer);
        ClassWriter writer = new ClassWriter(0);
        ClassNode nodeC = new ClassNode(589824);
        readerC.accept((ClassVisitor)nodeC, 0);
        ClassNode nodeS = new ClassNode(589824);
        readerS.accept((ClassVisitor)nodeS, 0);
        ClassNode nodeOut = new ClassNode(589824);
        nodeOut.version = nodeC.version;
        nodeOut.access = nodeC.access;
        nodeOut.name = nodeC.name;
        nodeOut.signature = nodeC.signature;
        nodeOut.superName = nodeC.superName;
        nodeOut.sourceFile = nodeC.sourceFile;
        nodeOut.sourceDebug = nodeC.sourceDebug;
        nodeOut.outerClass = nodeC.outerClass;
        nodeOut.outerMethod = nodeC.outerMethod;
        nodeOut.outerMethodDesc = nodeC.outerMethodDesc;
        nodeOut.module = nodeC.module;
        nodeOut.nestHostClass = nodeC.nestHostClass;
        nodeOut.nestMembers = nodeC.nestMembers;
        nodeOut.attrs = nodeC.attrs;
        if (nodeC.invisibleAnnotations != null) {
            nodeOut.invisibleAnnotations = new ArrayList();
            nodeOut.invisibleAnnotations.addAll(nodeC.invisibleAnnotations);
        }
        if (nodeC.invisibleTypeAnnotations != null) {
            nodeOut.invisibleTypeAnnotations = new ArrayList();
            nodeOut.invisibleTypeAnnotations.addAll(nodeC.invisibleTypeAnnotations);
        }
        if (nodeC.visibleAnnotations != null) {
            nodeOut.visibleAnnotations = new ArrayList();
            nodeOut.visibleAnnotations.addAll(nodeC.visibleAnnotations);
        }
        if (nodeC.visibleTypeAnnotations != null) {
            nodeOut.visibleTypeAnnotations = new ArrayList();
            nodeOut.visibleTypeAnnotations.addAll(nodeC.visibleTypeAnnotations);
        }
        List<String> itfs = MinecraftClassMerger.mergePreserveOrder(nodeC.interfaces, nodeS.interfaces);
        nodeOut.interfaces = new ArrayList();
        ArrayList<String> clientItfs = new ArrayList<String>();
        ArrayList<String> serverItfs = new ArrayList<String>();
        for (String s : itfs) {
            boolean nc = nodeC.interfaces.contains(s);
            boolean ns = nodeS.interfaces.contains(s);
            nodeOut.interfaces.add(s);
            if (nc && !ns) {
                clientItfs.add(s);
                continue;
            }
            if (!ns || nc) continue;
            serverItfs.add(s);
        }
        if (!clientItfs.isEmpty() || !serverItfs.isEmpty()) {
            AnnotationVisitor envInterfaces = nodeOut.visitAnnotation(ITF_LIST_DESCRIPTOR, false);
            AnnotationVisitor eiArray = envInterfaces.visitArray("value");
            if (!clientItfs.isEmpty()) {
                MinecraftClassMerger.visitItfAnnotation(eiArray, "CLIENT", clientItfs);
            }
            if (!serverItfs.isEmpty()) {
                MinecraftClassMerger.visitItfAnnotation(eiArray, "SERVER", serverItfs);
            }
            eiArray.visitEnd();
            envInterfaces.visitEnd();
        }
        new Merger<InnerClassNode>(nodeC.innerClasses, nodeS.innerClasses){

            @Override
            public String getName(InnerClassNode entry) {
                return entry.name;
            }

            @Override
            public void applySide(InnerClassNode entry, String side) {
            }
        }.merge(nodeOut.innerClasses);
        new Merger<FieldNode>(nodeC.fields, nodeS.fields){

            @Override
            public String getName(FieldNode entry) {
                return entry.name + ";;" + entry.desc;
            }

            @Override
            public void applySide(FieldNode entry, String side) {
                AnnotationVisitor av = entry.visitAnnotation(MinecraftClassMerger.SIDED_DESCRIPTOR, false);
                MinecraftClassMerger.visitSideAnnotation(av, side);
            }
        }.merge(nodeOut.fields);
        new Merger<MethodNode>(nodeC.methods, nodeS.methods){

            @Override
            public String getName(MethodNode entry) {
                return entry.name + entry.desc;
            }

            @Override
            public void applySide(MethodNode entry, String side) {
                AnnotationVisitor av = entry.visitAnnotation(MinecraftClassMerger.SIDED_DESCRIPTOR, false);
                MinecraftClassMerger.visitSideAnnotation(av, side);
            }
        }.merge(nodeOut.methods);
        nodeOut.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static List<String> mergePreserveOrder(List<String> first, List<String> second) {
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        int j = 0;
        while (i < first.size() || j < second.size()) {
            int saved = i + j;
            while (i < first.size() && j < second.size() && first.get(i).equals(second.get(j))) {
                out.add(first.get(i));
                ++i;
                ++j;
            }
            while (i < first.size() && !second.contains(first.get(i))) {
                out.add(first.get(i));
                ++i;
            }
            while (j < second.size() && !first.contains(second.get(j))) {
                out.add(second.get(j));
                ++j;
            }
            if (i + j != saved) continue;
            while (i < first.size()) {
                out.add(first.get(i));
                ++i;
            }
            while (j < second.size()) {
                if (!first.contains(second.get(j))) {
                    out.add(second.get(j));
                }
                ++j;
            }
        }
        return out;
    }

    public static class SidedClassVisitor
    extends ClassVisitor {
        private final String side;

        public SidedClassVisitor(int api, ClassVisitor cv, String side) {
            super(api, cv);
            this.side = side;
        }

        public void visitEnd() {
            AnnotationVisitor av = this.cv.visitAnnotation(MinecraftClassMerger.SIDED_DESCRIPTOR, true);
            MinecraftClassMerger.visitSideAnnotation(av, this.side);
            super.visitEnd();
        }
    }

    private static abstract class Merger<T> {
        private final Map<String, T> entriesClient = new LinkedHashMap<String, T>();
        private final Map<String, T> entriesServer = new LinkedHashMap<String, T>();
        private final List<String> entryNames;

        Merger(List<T> entriesClient, List<T> entriesServer) {
            List<String> listClient = this.toMap(entriesClient, this.entriesClient);
            List<String> listServer = this.toMap(entriesServer, this.entriesServer);
            this.entryNames = MinecraftClassMerger.mergePreserveOrder(listClient, listServer);
        }

        public abstract String getName(T var1);

        public abstract void applySide(T var1, String var2);

        private List<String> toMap(List<T> entries, Map<String, T> map) {
            ArrayList<String> list = new ArrayList<String>(entries.size());
            for (T entry : entries) {
                String name = this.getName(entry);
                map.put(name, entry);
                list.add(name);
            }
            return list;
        }

        public void merge(List<T> list) {
            for (String s : this.entryNames) {
                T entryClient = this.entriesClient.get(s);
                T entryServer = this.entriesServer.get(s);
                if (entryClient != null && entryServer != null) {
                    list.add(entryClient);
                    continue;
                }
                if (entryClient != null) {
                    this.applySide(entryClient, "CLIENT");
                    list.add(entryClient);
                    continue;
                }
                this.applySide(entryServer, "SERVER");
                list.add(entryServer);
            }
        }
    }
}

