/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loom.configuration.providers.minecraft;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loom.LoomGradleExtension;
import net.fabricmc.loom.api.mappings.layered.MappingsNamespace;
import net.fabricmc.loom.configuration.ConfigContext;
import net.fabricmc.loom.configuration.providers.BundleMetadata;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftLibraryProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftMetadataProvider;
import net.fabricmc.loom.configuration.providers.minecraft.MinecraftVersionMeta;
import net.fabricmc.loom.util.download.DownloadExecutor;
import net.fabricmc.loom.util.download.GradleDownloadProgressListener;
import net.fabricmc.loom.util.gradle.ProgressGroup;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinecraftProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinecraftProvider.class);
    private final MinecraftMetadataProvider metadataProvider;
    private File minecraftClientJar;
    private File minecraftServerJar;
    private File minecraftExtractedServerJar;
    @Nullable
    private BundleMetadata serverBundleMetadata;
    private final ConfigContext configContext;

    public MinecraftProvider(MinecraftMetadataProvider metadataProvider, ConfigContext configContext) {
        this.metadataProvider = metadataProvider;
        this.configContext = configContext;
    }

    protected boolean provideClient() {
        return true;
    }

    protected boolean provideServer() {
        return true;
    }

    public void provide() throws Exception {
        this.initFiles();
        MinecraftVersionMeta.JavaVersion javaVersion = this.getVersionInfo().javaVersion();
        if (javaVersion != null) {
            int requiredMajorJavaVersion = this.getVersionInfo().javaVersion().majorVersion();
            JavaVersion requiredJavaVersion = JavaVersion.toVersion((Object)requiredMajorJavaVersion);
            if (!JavaVersion.current().isCompatibleWith(requiredJavaVersion)) {
                throw new IllegalStateException("Minecraft " + this.minecraftVersion() + " requires Java " + String.valueOf(requiredJavaVersion) + " but Gradle is using " + String.valueOf(JavaVersion.current()));
            }
        }
        this.downloadJars();
        if (this.provideServer()) {
            this.serverBundleMetadata = BundleMetadata.fromJar(this.minecraftServerJar.toPath());
        }
        MinecraftLibraryProvider libraryProvider = new MinecraftLibraryProvider(this, this.configContext.project());
        libraryProvider.provide();
    }

    protected void initFiles() {
        if (this.provideClient()) {
            this.minecraftClientJar = this.file("minecraft-client.jar");
        }
        if (this.provideServer()) {
            this.minecraftServerJar = this.file("minecraft-server.jar");
            this.minecraftExtractedServerJar = this.file("minecraft-extracted_server.jar");
        }
    }

    private void downloadJars() throws IOException {
        try (ProgressGroup progressGroup = new ProgressGroup(this.getProject(), "Download Minecraft jars");
             DownloadExecutor executor = new DownloadExecutor(2);){
            if (this.provideClient()) {
                MinecraftVersionMeta.Download client = this.getVersionInfo().download("client");
                this.getExtension().download(client.url()).sha1(client.sha1()).progress(new GradleDownloadProgressListener("Minecraft client", progressGroup::createProgressLogger)).downloadPathAsync(this.minecraftClientJar.toPath(), executor);
            }
            if (this.provideServer()) {
                MinecraftVersionMeta.Download server = this.getVersionInfo().download("server");
                this.getExtension().download(server.url()).sha1(server.sha1()).progress(new GradleDownloadProgressListener("Minecraft server", progressGroup::createProgressLogger)).downloadPathAsync(this.minecraftServerJar.toPath(), executor);
            }
        }
    }

    protected final void extractBundledServerJar() throws IOException {
        Preconditions.checkArgument((boolean)this.provideServer(), (Object)"Not configured to provide server jar");
        Objects.requireNonNull(this.getServerBundleMetadata(), "Cannot bundled mc jar from none bundled server jar");
        LOGGER.info(":Extracting server jar from bootstrap");
        if (this.getServerBundleMetadata().versions().size() != 1) {
            throw new UnsupportedOperationException("Expected only 1 version in META-INF/versions.list, but got %d".formatted(this.getServerBundleMetadata().versions().size()));
        }
        this.getServerBundleMetadata().versions().get(0).unpackEntry(this.minecraftServerJar.toPath(), this.getMinecraftExtractedServerJar().toPath(), this.configContext.project());
    }

    public File workingDir() {
        return MinecraftProvider.minecraftWorkingDirectory(this.configContext.project(), this.minecraftVersion());
    }

    public File dir(String path) {
        File dir = this.file(path);
        dir.mkdirs();
        return dir;
    }

    public File file(String path) {
        return new File(this.workingDir(), path);
    }

    public Path path(String path) {
        return this.file(path).toPath();
    }

    public File getMinecraftClientJar() {
        Preconditions.checkArgument((boolean)this.provideClient(), (Object)"Not configured to provide client jar");
        return this.minecraftClientJar;
    }

    @Nullable
    public File getMinecraftExtractedServerJar() {
        Preconditions.checkArgument((boolean)this.provideServer(), (Object)"Not configured to provide server jar");
        return this.minecraftExtractedServerJar;
    }

    public File getMinecraftServerJar() {
        Preconditions.checkArgument((boolean)this.provideServer(), (Object)"Not configured to provide server jar");
        return this.minecraftServerJar;
    }

    public String minecraftVersion() {
        return Objects.requireNonNull(this.metadataProvider, "Metadata provider not setup").getMinecraftVersion();
    }

    public MinecraftVersionMeta getVersionInfo() {
        return Objects.requireNonNull(this.metadataProvider, "Metadata provider not setup").getVersionMeta();
    }

    public boolean isLegacyVersion() {
        return !this.getVersionInfo().isVersionOrNewer("2012-07-25T22:00:00+00:00");
    }

    @Nullable
    public BundleMetadata getServerBundleMetadata() {
        return this.serverBundleMetadata;
    }

    public abstract List<Path> getMinecraftJars();

    public abstract MappingsNamespace getOfficialNamespace();

    protected Project getProject() {
        return this.configContext.project();
    }

    protected LoomGradleExtension getExtension() {
        return this.configContext.extension();
    }

    public boolean refreshDeps() {
        return this.getExtension().refreshDeps();
    }

    public static File minecraftWorkingDirectory(Project project, String version) {
        LoomGradleExtension extension = LoomGradleExtension.get(project);
        File workingDir = new File(extension.getFiles().getUserCache(), version);
        workingDir.mkdirs();
        return workingDir;
    }
}

