/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format;

public enum MappingFormat {
    TINY("Tiny", "tiny", true, true, false, false, false),
    TINY_2("Tiny v2", "tiny", true, true, true, true, true),
    ENIGMA("Enigma", null, false, true, true, true, false),
    MCP("MCP", null, false, false, true, true, false),
    SRG("SRG", "srg", false, false, false, false, false),
    TSRG("TSRG", "tsrg", false, false, false, false, false),
    TSRG2("TSRG2", "tsrg", true, false, false, true, false),
    PROGUARD("ProGuard", "map", false, true, false, false, false);

    public final String name;
    public final String fileExt;
    public final boolean hasNamespaces;
    public final boolean hasFieldDescriptors;
    public final boolean supportsComments;
    public final boolean supportsArgs;
    public final boolean supportsLocals;

    private MappingFormat(String name, String fileExt, boolean hasNamespaces, boolean hasFieldDescriptors, boolean supportsComments, boolean supportsArgs, boolean supportsLocals) {
        this.name = name;
        this.fileExt = fileExt;
        this.hasNamespaces = hasNamespaces;
        this.hasFieldDescriptors = hasFieldDescriptors;
        this.supportsComments = supportsComments;
        this.supportsArgs = supportsArgs;
        this.supportsLocals = supportsLocals;
    }

    public boolean hasSingleFile() {
        return this.fileExt != null;
    }

    public String getGlobPattern() {
        if (this.fileExt == null) {
            throw new UnsupportedOperationException("not applicable to dir based format");
        }
        return "*." + this.fileExt;
    }
}

