/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.mercury.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.Type;
import org.cadixdev.bombe.type.VoidType;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.mercury.Mercury;
import org.cadixdev.mercury.RewriteContext;
import org.cadixdev.mercury.analysis.MercuryInheritanceProvider;
import org.cadixdev.mercury.mixin.annotation.AccessorData;
import org.cadixdev.mercury.mixin.annotation.AccessorName;
import org.cadixdev.mercury.mixin.annotation.AccessorType;
import org.cadixdev.mercury.mixin.annotation.AtData;
import org.cadixdev.mercury.mixin.annotation.DescData;
import org.cadixdev.mercury.mixin.annotation.InjectData;
import org.cadixdev.mercury.mixin.annotation.InjectTarget;
import org.cadixdev.mercury.mixin.annotation.MixinClass;
import org.cadixdev.mercury.mixin.annotation.ShadowData;
import org.cadixdev.mercury.mixin.annotation.SliceData;
import org.cadixdev.mercury.mixin.util.MixinConstants;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.AST;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ASTNode;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ASTVisitor;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.Annotation;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ArrayInitializer;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.Expression;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IExtendedModifier;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IMethodBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.ITypeBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.IVariableBinding;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.InfixExpression;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.MemberValuePair;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.SimpleName;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.StringLiteral;
import org.cadixdev.mercury.shadow.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.cadixdev.mercury.util.BombeBindings;

public class MixinRemapperVisitor
extends ASTVisitor {
    final RewriteContext context;
    final MappingSet mappings;
    private final InheritanceProvider inheritanceProvider;

    MixinRemapperVisitor(RewriteContext context, MappingSet mappings) {
        this.context = context;
        this.mappings = mappings;
        this.inheritanceProvider = MercuryInheritanceProvider.get((Mercury)context.getMercury());
    }

    private void remapPrivateMixinTarget(AST ast, TypeDeclaration typeDeclaration, ITypeBinding binding) {
        for (Object rawModifier : typeDeclaration.modifiers()) {
            IExtendedModifier modifier = (IExtendedModifier)rawModifier;
            if (!modifier.isAnnotation()) {
                return;
            }
            Annotation rawAnnot = (Annotation)modifier;
            if (!rawAnnot.isNormalAnnotation()) continue;
            NormalAnnotation annot = (NormalAnnotation)rawAnnot;
            for (Object raw : annot.values()) {
                StringLiteral target;
                MemberValuePair pair = (MemberValuePair)raw;
                if (!Objects.equals("targets", pair.getName().getIdentifier())) continue;
                Expression targets = pair.getValue();
                if (targets instanceof StringLiteral) {
                    target = (StringLiteral)targets;
                    this.remapPrivateMixinTargetLiteral(ast, target);
                    continue;
                }
                if (!(targets instanceof ArrayInitializer)) continue;
                target = (ArrayInitializer)targets;
                for (Object expression : target.expressions()) {
                    if (!(expression instanceof StringLiteral)) continue;
                    this.remapPrivateMixinTargetLiteral(ast, (StringLiteral)expression);
                }
            }
        }
    }

    private void remapPrivateMixinTargetLiteral(AST ast, StringLiteral literal) {
        String className = literal.getLiteralValue();
        if (className.isEmpty()) {
            return;
        }
        boolean binaryFormat = className.contains("/");
        ClassMapping classMapping = this.mappings.getTopLevelClassMapping(className).orElse(null);
        if (classMapping == null) {
            classMapping = this.mappings.getClassMapping(className).orElse(null);
        }
        if (classMapping != null) {
            String remappedClassName = classMapping.getFullDeobfuscatedName();
            MixinRemapperVisitor.replaceExpression(ast, this.context, (Expression)literal, binaryFormat ? remappedClassName : remappedClassName.replace('/', '.'));
        }
    }

    void remapField(SimpleName node, IVariableBinding binding) {
        if (!binding.isField()) {
            return;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (declaringClass == null) {
            return;
        }
        MixinClass mixin = MixinClass.fetch(declaringClass, this.mappings);
        if (mixin == null) {
            return;
        }
        ClassMapping target = this.mappings.getOrCreateClassMapping(mixin.getTargetNames()[0]);
        for (IAnnotationBinding annotation : binding.getAnnotations()) {
            String annotationType = annotation.getAnnotationType().getBinaryName();
            if (!Objects.equals("org.spongepowered.asm.mixin.Shadow", annotationType)) continue;
            ShadowData shadow = ShadowData.from(annotation);
            boolean usedPrefix = binding.getName().startsWith(shadow.getPrefix());
            FieldSignature targetSignature = MixinRemapperVisitor.convertSignature(shadow.stripPrefix(binding.getName()), binding.getType());
            FieldSignature mixinSignature = BombeBindings.convertSignature((IVariableBinding)binding);
            mixin.copyFieldMapping(target, mixinSignature, targetSignature, deobfName -> usedPrefix ? shadow.prefix((String)deobfName) : deobfName);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean visit(MethodDeclaration node) {
        AST ast = this.context.getCompilationUnit().getAST();
        IMethodBinding binding = node.resolveBinding();
        if (binding == null) {
            if (this.context.getMercury().isGracefulClasspathChecks()) {
                return true;
            }
            throw new IllegalStateException("No binding for type declaration " + node.getName() + " in class " + this.context.getQualifiedPrimaryType());
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        MixinClass mixin = MixinClass.fetch(declaringClass, this.mappings);
        if (mixin == null) {
            return true;
        }
        if (node.getName().getIdentifier().contains("$")) {
            String[] split = node.getName().getIdentifier().split("\\$");
            ITypeBinding[] prefix = split[0];
            String name = split[1];
            if (mixin.getImplementsData().containsKey(prefix)) {
                ITypeBinding iface = mixin.getImplementsData().get(prefix);
                ClassMapping target = this.mappings.getOrCreateClassMapping(iface.getBinaryName());
                MethodSignature targetSignature = MixinRemapperVisitor.convertSignature(name, binding);
                MethodSignature mixinSignature = BombeBindings.convertSignature((IMethodBinding)binding);
                mixin.copyMethodMapping(target, mixinSignature, targetSignature, arg_0 -> MixinRemapperVisitor.lambda$visit$1((String)prefix, arg_0));
                return true;
            }
        }
        ClassMapping target = this.mappings.getOrCreateClassMapping(mixin.getTargetNames()[0]);
        for (ITypeBinding mixinTarget : mixin.getTargets(this.context.getMercury())) {
            target.complete(this.inheritanceProvider, (Object)mixinTarget);
        }
        int i = 0;
        while (true) {
            block48: {
                IMemberValuePairBinding pair3;
                NormalAnnotation originalAnnotation;
                InjectTarget[] inject;
                String annotationType;
                IAnnotationBinding annotation;
                block47: {
                    if (i >= binding.getAnnotations().length) {
                        return true;
                    }
                    annotation = binding.getAnnotations()[i];
                    annotationType = annotation.getAnnotationType().getBinaryName();
                    if (Objects.equals("org.spongepowered.asm.mixin.Shadow", annotationType)) {
                        ShadowData shadow = ShadowData.from(annotation);
                        boolean usedPrefix = binding.getName().startsWith(shadow.getPrefix());
                        MethodSignature targetSignature = MixinRemapperVisitor.convertSignature(shadow.stripPrefix(binding.getName()), binding);
                        MethodSignature mixinSignature = BombeBindings.convertSignature((IMethodBinding)binding);
                        mixin.copyMethodMapping(target, mixinSignature, targetSignature, deobfName -> usedPrefix ? shadow.prefix((String)deobfName) : deobfName);
                    }
                    if (Objects.equals("org.spongepowered.asm.mixin.Overwrite", annotationType)) {
                        MethodSignature signature = BombeBindings.convertSignature((IMethodBinding)binding);
                        mixin.copyMethodMapping(target, signature, s -> s);
                    }
                    if (!Objects.equals("org.spongepowered.asm.mixin.gen.Accessor", annotationType) && !Objects.equals("org.spongepowered.asm.mixin.gen.Invoker", annotationType)) break block47;
                    AccessorName name = AccessorName.of(binding.getName());
                    AccessorData accessor = AccessorData.from(annotation);
                    MethodSignature mixinSignature = BombeBindings.convertSignature((IMethodBinding)binding);
                    AccessorType type = AccessorType.get(Objects.equals("org.spongepowered.asm.mixin.gen.Invoker", annotationType), binding, mixinSignature, accessor);
                    boolean inflect = accessor.getTarget().isEmpty();
                    String targetName = inflect ? name.getName() : accessor.getTarget();
                    switch (type) {
                        case FIELD_GETTER: 
                        case FIELD_SETTER: {
                            Annotation rawAnnotation;
                            MethodSignature targetSignature = new FieldSignature(targetName, type == AccessorType.FIELD_GETTER ? (FieldType)mixinSignature.getDescriptor().getReturnType() : (FieldType)mixinSignature.getDescriptor().getParamTypes().get(0));
                            FieldMapping targetField = target.computeFieldMapping((FieldSignature)targetSignature).orElse(null);
                            if (targetField != null) {
                                if (inflect) {
                                    mixin.copyMethodMapping(target, mixinSignature, (FieldSignature)targetSignature, name::prefix);
                                    break;
                                }
                                rawAnnotation = (Annotation)node.modifiers().get(i);
                                MixinRemapperVisitor.replaceValueInAnnotation(ast, this.context, rawAnnotation, targetField.getDeobfuscatedName());
                                break;
                            }
                            break block48;
                        }
                        case METHOD_PROXY: {
                            Annotation rawAnnotation;
                            MethodSignature targetSignature = new MethodSignature(targetName, mixinSignature.getDescriptor());
                            MethodMapping targetMethod = target.getMethodMapping(targetSignature).orElse(null);
                            if (targetMethod != null) {
                                if (inflect) {
                                    mixin.copyMethodMapping(target, mixinSignature, targetSignature, name::prefix);
                                    break;
                                }
                                rawAnnotation = (Annotation)node.modifiers().get(i);
                                MixinRemapperVisitor.replaceValueInAnnotation(ast, this.context, rawAnnotation, targetMethod.getDeobfuscatedName());
                                break;
                            }
                            break block48;
                        }
                        case OBJECT_FACTORY: {
                            if (Objects.equals("<init>", accessor.getTarget())) break;
                            ClassMapping targetClass = this.mappings.computeClassMapping(accessor.getTarget()).orElse(null);
                            if (targetClass == null) break block48;
                            Annotation rawAnnotation = (Annotation)node.modifiers().get(i);
                            MixinRemapperVisitor.replaceValueInAnnotation(ast, this.context, rawAnnotation, targetClass.getFullDeobfuscatedName());
                        }
                    }
                }
                if (Objects.equals("org.spongepowered.asm.mixin.injection.Inject", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.Redirect", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.ModifyConstant", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.ModifyVariable", annotationType) || Objects.equals("org.spongepowered.asm.mixin.injection.ModifyArg", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.WrapWithCondition", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.v2.WrapWithCondition", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.ModifyExpressionValue", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.ModifyReceiver", annotationType) || Objects.equals("com.llamalad7.mixinextras.injector.ModifyReturnValue", annotationType)) {
                    inject = InjectData.from(annotation);
                    String[] injectTargets = new String[inject.getInjectTargets().length];
                    for (int j = 0; j < inject.getInjectTargets().length; ++j) {
                        InjectTarget injectTarget = inject.getInjectTargets()[j];
                        injectTargets[j] = this.remapInjectTarget(target, injectTarget, binding);
                    }
                    originalAnnotation = (NormalAnnotation)node.modifiers().get(i);
                    int atIndex = 0;
                    int sliceIndex = 0;
                    for (Object raw : originalAnnotation.values()) {
                        NormalAnnotation atAnnotation;
                        NormalAnnotation atAnnotation2;
                        ArrayInitializer value;
                        MemberValuePair pair2 = (MemberValuePair)raw;
                        if (Objects.equals("method", pair2.getName().getIdentifier())) {
                            this.remapMethod(ast, pair2, injectTargets);
                        }
                        if ("target".equals(pair2.getName().getIdentifier())) {
                            if (pair2.getValue() instanceof Annotation) {
                                Annotation original = (Annotation)pair2.getValue();
                                this.remapDescAnnotation(ast, declaringClass, original, inject.getDescTargets()[0]);
                            } else if (pair2.getValue() instanceof ArrayInitializer) {
                                ArrayInitializer array = (ArrayInitializer)pair2.getValue();
                                for (int j = 0; j < array.expressions().size(); ++j) {
                                    Annotation original = (Annotation)array.expressions().get(j);
                                    this.remapDescAnnotation(ast, declaringClass, original, inject.getDescTargets()[j]);
                                }
                            }
                        }
                        if (Objects.equals("at", pair2.getName().getIdentifier())) {
                            if (pair2.getValue() instanceof ArrayInitializer) {
                                value = (ArrayInitializer)pair2.getValue();
                                for (Object expression : value.expressions()) {
                                    if (expression instanceof NormalAnnotation) {
                                        atAnnotation2 = (NormalAnnotation)expression;
                                        AtData atDatum = inject.getAtData()[atIndex];
                                        this.remapAtAnnotation(ast, declaringClass, atAnnotation2, atDatum);
                                    }
                                    ++atIndex;
                                }
                            } else if (pair2.getValue() instanceof NormalAnnotation) {
                                atAnnotation = (NormalAnnotation)pair2.getValue();
                                AtData atDatum = inject.getAtData()[atIndex];
                                this.remapAtAnnotation(ast, declaringClass, atAnnotation, atDatum);
                            }
                        }
                        if (!Objects.equals("slice", pair2.getName().getIdentifier())) continue;
                        if (pair2.getValue() instanceof ArrayInitializer) {
                            value = (ArrayInitializer)pair2.getValue();
                            for (Object expression : value.expressions()) {
                                if (expression instanceof NormalAnnotation) {
                                    atAnnotation2 = (NormalAnnotation)expression;
                                    SliceData sliceDatum = inject.getSliceData()[sliceIndex];
                                    this.remapSliceAnnotation(ast, declaringClass, atAnnotation2, sliceDatum);
                                }
                                ++sliceIndex;
                            }
                            continue;
                        }
                        if (!(pair2.getValue() instanceof NormalAnnotation)) continue;
                        atAnnotation = (NormalAnnotation)pair2.getValue();
                        SliceData sliceDatum = inject.getSliceData()[sliceIndex];
                        this.remapSliceAnnotation(ast, declaringClass, atAnnotation, sliceDatum);
                    }
                }
                if (Objects.equals("com.llamalad7.mixinextras.expression.Definition", annotationType)) {
                    Object[] rawMethod = null;
                    Object[] rawField = null;
                    for (IMemberValuePairBinding pair3 : annotation.getDeclaredMemberValuePairs()) {
                        if (Objects.equals("method", pair3.getName())) {
                            rawMethod = (Object[])pair3.getValue();
                        }
                        if (!Objects.equals("field", pair3.getName())) continue;
                        rawField = (Object[])pair3.getValue();
                    }
                    originalAnnotation = (NormalAnnotation)node.modifiers().get(i);
                    for (Object raw : originalAnnotation.values()) {
                        pair3 = (MemberValuePair)raw;
                        if (Objects.equals("method", pair3.getName().getIdentifier())) {
                            assert (rawMethod != null);
                            this.remapAtLikeField(ast, rawMethod, pair3.getValue(), "INVOKE");
                            continue;
                        }
                        if (!Objects.equals("field", pair3.getName().getIdentifier())) continue;
                        assert (rawField != null);
                        this.remapAtLikeField(ast, rawField, pair3.getValue(), "FIELD");
                    }
                }
                if (Objects.equals("com.bawnorton.mixinsquared.TargetHandler", annotationType)) {
                    inject = MixinRemapperVisitor.getInjectTargets(annotation, "name");
                    String[] injectTargets = new String[inject.length];
                    for (int j = 0; j < inject.length; ++j) {
                        InjectTarget injectTarget = inject[j];
                        injectTargets[j] = this.remapInjectTarget(target, injectTarget, binding);
                    }
                    originalAnnotation = (NormalAnnotation)node.modifiers().get(i);
                    for (Object raw : originalAnnotation.values()) {
                        pair3 = (MemberValuePair)raw;
                        if (!Objects.equals("name", pair3.getName().getIdentifier())) continue;
                        this.remapMethod(ast, (MemberValuePair)pair3, injectTargets);
                    }
                }
            }
            ++i;
        }
    }

    private static InjectTarget[] getInjectTargets(IAnnotationBinding binding, String method) {
        InjectTarget[] injectTargets = new InjectTarget[]{};
        for (IMemberValuePairBinding pair : binding.getDeclaredMemberValuePairs()) {
            if (!Objects.equals(method, pair.getName())) continue;
            Object[] raw = (Object[])pair.getValue();
            injectTargets = new InjectTarget[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                injectTargets[i] = InjectTarget.of((String)raw[i]);
            }
        }
        return injectTargets;
    }

    private static AtData[] getAtDataArray(String injectionPoint, String[] array) {
        AtData[] atData = new AtData[array.length];
        for (int i = 0; i < array.length; ++i) {
            atData[i] = AtData.from(injectionPoint, array[i], null);
        }
        return atData;
    }

    private void remapMethod(AST ast, MemberValuePair pair, String[] injectTargets) {
        if (pair.getValue() instanceof StringLiteral || pair.getValue() instanceof InfixExpression) {
            MixinRemapperVisitor.replaceExpression(ast, this.context, pair.getValue(), injectTargets[0]);
        } else if (pair.getValue() instanceof ArrayInitializer) {
            ArrayInitializer array = (ArrayInitializer)pair.getValue();
            for (int j = 0; j < array.expressions().size(); ++j) {
                StringLiteral original = (StringLiteral)array.expressions().get(j);
                MixinRemapperVisitor.replaceExpression(ast, this.context, (Expression)original, injectTargets[j]);
            }
        }
    }

    private String remapInjectTarget(ClassMapping<?, ?> target, InjectTarget injectTarget, IMethodBinding binding) {
        String targetName = injectTarget.getTargetName();
        if (injectTarget.getFieldType().isPresent()) {
            Type fieldType = injectTarget.getFieldType().get();
            for (FieldMapping mapping : target.getFieldMappings()) {
                if (!Objects.equals(targetName, mapping.getObfuscatedName()) || mapping.getType().isPresent() && !Objects.equals(mapping.getType().get(), fieldType)) continue;
                FieldSignature deobfuscatedSignature = mapping.getDeobfuscatedSignature();
                String deobfuscatedFieldType = deobfuscatedSignature.getType().map(Object::toString).orElse(null);
                if (deobfuscatedFieldType == null) {
                    deobfuscatedFieldType = this.mappings.deobfuscate(fieldType).toString();
                }
                return deobfuscatedFieldType != null ? deobfuscatedSignature.getName() + ":" + deobfuscatedFieldType : deobfuscatedSignature.getName();
            }
        } else {
            MethodDescriptor methodDescriptor = injectTarget.getMethodDescriptor().orElse(null);
            boolean needsDescriptor = this.shouldCalculateDescriptor(target, targetName);
            List targetMethodParams = null;
            if (methodDescriptor == null && binding != null && needsDescriptor) {
                List<ITypeBinding> bindingParams = List.of(binding.getParameterTypes());
                int ciIndex = bindingParams.stream().filter(t -> MixinConstants.CALLBACK_TYPES.contains(t.getBinaryName())).findFirst().map(bindingParams::indexOf).orElse(-1);
                if (ciIndex != -1) {
                    ITypeBinding returnType = (ITypeBinding)bindingParams.get(ciIndex);
                    String methodParams = bindingParams.subList(0, ciIndex).stream().map(MixinRemapperVisitor::getTypeDescriptor).collect(Collectors.joining(""));
                    boolean isVoid = returnType.getBinaryName().equals("org.spongepowered.asm.mixin.injection.callback.CallbackInfo");
                    if (isVoid || returnType.getTypeParameters().length > 0) {
                        String returnTypeDesc = isVoid ? "V" : MixinRemapperVisitor.getTypeDescriptor(returnType.getTypeParameters()[0]);
                        methodDescriptor = MethodDescriptor.of((String)("(" + methodParams + ")" + returnTypeDesc));
                    } else {
                        targetMethodParams = bindingParams.subList(0, bindingParams.size() - 1);
                    }
                }
            }
            for (MethodMapping mapping : target.getMethodMappings()) {
                if (!Objects.equals(targetName, mapping.getObfuscatedName()) || !this.matchDescriptor(methodDescriptor, needsDescriptor, mapping, targetMethodParams)) continue;
                MethodSignature deobfuscatedSignature = mapping.getDeobfuscatedSignature();
                return this.shouldIncludeDescriptor(target, mapping, injectTarget.getMethodDescriptor()) ? deobfuscatedSignature.getName() + deobfuscatedSignature.getDescriptor().toString() : deobfuscatedSignature.getName();
            }
        }
        MappingSet mappings = target.getMappings();
        String targetOwner = injectTarget.getOwnerName();
        MethodDescriptor descriptor = injectTarget.getMethodDescriptor().orElse(null);
        Type type = injectTarget.getFieldType().orElse(null);
        StringBuilder remappedFull = new StringBuilder();
        if (targetOwner != null) {
            remappedFull.append("L").append(targetOwner).append(";");
        }
        remappedFull.append(targetName);
        if (descriptor != null) {
            remappedFull.append(mappings.deobfuscate(descriptor));
        }
        if (type != null) {
            remappedFull.append(':');
            remappedFull.append(mappings.deobfuscate(type));
        }
        return remappedFull.toString();
    }

    private boolean matchDescriptor(MethodDescriptor methodDescriptor, boolean needsDescriptor, MethodMapping mapping, List<ITypeBinding> targetMethodParams) {
        return methodDescriptor == null && (!needsDescriptor || this.matchParameters(mapping, targetMethodParams)) || methodDescriptor != null && methodDescriptor.equals((Object)mapping.getDescriptor());
    }

    private boolean matchParameters(MethodMapping mapping, List<ITypeBinding> mixinParams) {
        List targetParams;
        if (mixinParams != null && (targetParams = MethodDescriptor.of((String)mapping.getObfuscatedDescriptor()).getParamTypes()).size() == mixinParams.size()) {
            for (int i = 0; i < targetParams.size(); ++i) {
                if (((FieldType)targetParams.get(i)).toString().equals(MixinRemapperVisitor.getTypeDescriptor(mixinParams.get(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldIncludeDescriptor(ClassMapping<?, ?> target, MethodMapping mapping, Optional<MethodDescriptor> descriptor) {
        if (descriptor.isPresent()) return true;
        if (target.getMethodMappings().stream().map(Mapping::getDeobfuscatedName).filter(mapping.getDeobfuscatedName()::equals).count() <= 1L) return false;
        if (target.getMethodMappings().stream().map(Mapping::getObfuscatedName).filter(mapping.getObfuscatedName()::equals).count() != 1L) return false;
        return true;
    }

    private boolean shouldCalculateDescriptor(ClassMapping<?, ?> target, String targetName) {
        List<MethodMapping> candidates = target.getMethodMappings().stream().filter(m -> Objects.equals(targetName, m.getObfuscatedName())).toList();
        return candidates.size() > 1 && candidates.stream().anyMatch(m -> !Objects.equals(((MethodMapping)candidates.get(0)).getDeobfuscatedName(), m.getDeobfuscatedName()));
    }

    private void remapSliceAnnotation(AST ast, ITypeBinding declaringClass, NormalAnnotation atAnnotation, SliceData sliceDatum) {
        for (Object raw : atAnnotation.values()) {
            MemberValuePair pairRaw = (MemberValuePair)raw;
            if (!(pairRaw.getValue() instanceof NormalAnnotation)) continue;
            if (Objects.equals("from", pairRaw.getName().getIdentifier())) {
                this.remapAtAnnotation(ast, declaringClass, (NormalAnnotation)pairRaw.getValue(), sliceDatum.getFrom());
            }
            if (!Objects.equals("to", pairRaw.getName().getIdentifier())) continue;
            this.remapAtAnnotation(ast, declaringClass, (NormalAnnotation)pairRaw.getValue(), sliceDatum.getTo());
        }
    }

    private void remapAtAnnotation(AST ast, ITypeBinding declaringClass, NormalAnnotation atAnnotation, AtData atDatum) {
        this.remapAtAnnotation(ast, declaringClass, atAnnotation, atDatum, "target", "desc");
    }

    private void remapAtAnnotation(AST ast, ITypeBinding declaringClass, NormalAnnotation atAnnotation, AtData atDatum, String targetName, String descName) {
        for (Object atRaw : atAnnotation.values()) {
            MemberValuePair atRawPair = (MemberValuePair)atRaw;
            if (Objects.equals(targetName, atRawPair.getName().getIdentifier())) {
                this.remapAtAnnotation(ast, atDatum, atRawPair.getValue());
            }
            if (!Objects.equals(descName, atRawPair.getName().getIdentifier()) || !atDatum.getDesc().isPresent()) continue;
            this.remapDescAnnotation(ast, declaringClass, (Annotation)atRawPair.getValue(), atDatum.getDesc().get());
        }
    }

    private void remapAtAnnotation(AST ast, AtData atDatum, Expression originalTarget) {
        if (atDatum.getClassName().isPresent()) {
            String className = atDatum.getClassName().get();
            ClassMapping atTargetMappings = this.mappings.computeClassMapping(className).orElse(null);
            if (atTargetMappings == null) {
                return;
            }
            String deobfTargetClass = atTargetMappings.getFullDeobfuscatedName();
            if (atDatum.getTarget().isPresent()) {
                InjectTarget atTarget = atDatum.getTarget().get();
                String newTarget = this.remapInjectTarget(atTargetMappings, atTarget, null);
                String deobfTarget = "L" + deobfTargetClass + ";" + newTarget;
                MixinRemapperVisitor.replaceExpression(ast, this.context, originalTarget, deobfTarget);
            } else {
                MixinRemapperVisitor.replaceExpression(ast, this.context, originalTarget, deobfTargetClass);
            }
        } else if (atDatum.getTarget().isPresent()) {
            atDatum.getTarget().get().getMethodDescriptor().ifPresent(desc -> MixinRemapperVisitor.replaceExpression(ast, this.context, originalTarget, this.mappings.deobfuscate(desc).toString()));
        }
    }

    private void remapAtLikeField(AST ast, Object[] rawValues, Expression expression, String atInjectionPoint) {
        if (expression instanceof ArrayInitializer) {
            ArrayInitializer value = (ArrayInitializer)expression;
            List expressions = value.expressions();
            for (int i = 0; i < expressions.size(); ++i) {
                AtData atDatum = AtData.from(atInjectionPoint, (String)rawValues[i], null);
                Object expr = expressions.get(i);
                this.remapAtAnnotation(ast, atDatum, (Expression)expr);
            }
        } else {
            AtData atDatum = AtData.from(atInjectionPoint, (String)rawValues[0], null);
            this.remapAtAnnotation(ast, atDatum, expression);
        }
    }

    private void remapDescAnnotation(AST ast, ITypeBinding declaringClass, Annotation annotation, DescData descData) {
        ClassMapping owner;
        MixinClass mixin = MixinClass.fetch(declaringClass, this.mappings);
        if (mixin == null) {
            return;
        }
        ClassMapping classMapping = owner = descData.getOwnerBinding() == null ? (ClassMapping)this.mappings.getClassMapping(mixin.getTargetNames()[0]).orElse(null) : (ClassMapping)this.mappings.getClassMapping(descData.getOwnerBinding().getBinaryName()).orElse(null);
        if (owner == null) {
            return;
        }
        VoidType returnType = descData.getReturnBinding() == null ? VoidType.INSTANCE : BombeBindings.convertType((ITypeBinding)descData.getReturnBinding());
        ArrayList<FieldType> arguments = new ArrayList<FieldType>(descData.getArgBindings().length);
        for (ITypeBinding argBinding : descData.getArgBindings()) {
            arguments.add((FieldType)BombeBindings.convertType((ITypeBinding)argBinding));
        }
        MethodMapping methodMapping = owner.getMethodMapping(new MethodSignature(descData.getName(), new MethodDescriptor(arguments, (Type)returnType))).orElse(null);
        if (methodMapping != null) {
            MixinRemapperVisitor.replaceValueInAnnotation(ast, this.context, annotation, methodMapping.getDeobfuscatedName());
            return;
        }
        if (descData.getArgBindings().length != 0 || returnType != VoidType.INSTANCE) {
            // empty if block
        }
    }

    private void visit(SimpleName node, IBinding binding) {
        switch (binding.getKind()) {
            case 3: {
                this.remapField(node, ((IVariableBinding)binding).getVariableDeclaration());
            }
        }
    }

    public final boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (binding != null) {
            this.visit(node, binding);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.remapPrivateMixinTarget(node.getAST(), node, node.resolveBinding());
        return true;
    }

    private static void replaceExpression(AST ast, RewriteContext context, Expression original, String replacement) {
        StringLiteral replacementLiteral = ast.newStringLiteral();
        replacementLiteral.setLiteralValue(replacement);
        context.createASTRewrite().replace((ASTNode)original, (ASTNode)replacementLiteral, null);
    }

    private static void replaceValueInAnnotation(AST ast, RewriteContext context, Annotation rawAnnotation, String replacement) {
        if (rawAnnotation.isNormalAnnotation()) {
            NormalAnnotation annotationNode = (NormalAnnotation)rawAnnotation;
            for (Object raw : annotationNode.values()) {
                MemberValuePair pair = (MemberValuePair)raw;
                if (!Objects.equals("value", pair.getName().getIdentifier())) continue;
                StringLiteral original = (StringLiteral)pair.getValue();
                MixinRemapperVisitor.replaceExpression(ast, context, (Expression)original, replacement);
            }
        } else if (rawAnnotation.isSingleMemberAnnotation()) {
            SingleMemberAnnotation annotationNode = (SingleMemberAnnotation)rawAnnotation;
            StringLiteral original = (StringLiteral)annotationNode.getValue();
            MixinRemapperVisitor.replaceExpression(ast, context, (Expression)original, replacement);
        } else if (!rawAnnotation.isMarkerAnnotation()) {
            throw new RuntimeException("Unexpected annotation: " + rawAnnotation.getClass().getName());
        }
    }

    private static FieldSignature convertSignature(String name, ITypeBinding type) {
        return new FieldSignature(name, (FieldType)BombeBindings.convertType((ITypeBinding)type));
    }

    private static MethodSignature convertSignature(String name, IMethodBinding binding) {
        ITypeBinding[] parameterBindings = binding.getParameterTypes();
        ArrayList<FieldType> parameters = new ArrayList<FieldType>(parameterBindings.length);
        for (ITypeBinding parameterBinding : parameterBindings) {
            parameters.add((FieldType)BombeBindings.convertType((ITypeBinding)parameterBinding));
        }
        return new MethodSignature(name, new MethodDescriptor(parameters, BombeBindings.convertType((ITypeBinding)binding.getReturnType())));
    }

    private static String getTypeDescriptor(ITypeBinding binding) {
        return binding.isPrimitive() ? binding.getBinaryName() : "L" + binding.getBinaryName().replace('.', '/') + ";";
    }

    private static /* synthetic */ String lambda$visit$1(String prefix, String deobfName) {
        return prefix + "$" + deobfName;
    }
}

