/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.commands.CommandAsmTrace;
import net.fabricmc.stitch.commands.CommandGenerateIntermediary;
import net.fabricmc.stitch.commands.CommandGeneratePrefixRemapper;
import net.fabricmc.stitch.commands.CommandMatcherToTiny;
import net.fabricmc.stitch.commands.CommandMergeJar;
import net.fabricmc.stitch.commands.CommandMergeTiny;
import net.fabricmc.stitch.commands.CommandProposeFieldNames;
import net.fabricmc.stitch.commands.CommandReorderTiny;
import net.fabricmc.stitch.commands.CommandRewriteIntermediary;
import net.fabricmc.stitch.commands.CommandUpdateIntermediary;
import net.fabricmc.stitch.commands.CommandValidateRecords;
import net.fabricmc.stitch.commands.tinyv2.CommandMergeTinyV2;
import net.fabricmc.stitch.commands.tinyv2.CommandProposeV2FieldNames;
import net.fabricmc.stitch.commands.tinyv2.CommandReorderTinyV2;

public class Main {
    private static final Map<String, Command> COMMAND_MAP = new TreeMap<String, Command>();

    public static void addCommand(Command command) {
        COMMAND_MAP.put(command.name.toLowerCase(Locale.ROOT), command);
    }

    public static void main(String[] args) {
        if (args.length == 0 || !COMMAND_MAP.containsKey(args[0].toLowerCase(Locale.ROOT)) || !COMMAND_MAP.get(args[0].toLowerCase(Locale.ROOT)).isArgumentCountValid(args.length - 1)) {
            if (args.length > 0) {
                System.out.println("Invalid command: " + args[0]);
            }
            System.out.println("Available commands:");
            for (Command command : COMMAND_MAP.values()) {
                System.out.println("\t" + command.name + " " + command.getHelpString());
            }
            System.out.println();
            return;
        }
        try {
            String[] argsCommand = new String[args.length - 1];
            if (args.length > 1) {
                System.arraycopy(args, 1, argsCommand, 0, argsCommand.length);
            }
            COMMAND_MAP.get(args[0].toLowerCase(Locale.ROOT)).run(argsCommand);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static {
        Main.addCommand(new CommandAsmTrace());
        Main.addCommand(new CommandGenerateIntermediary());
        Main.addCommand(new CommandGeneratePrefixRemapper());
        Main.addCommand(new CommandMatcherToTiny());
        Main.addCommand(new CommandMergeJar());
        Main.addCommand(new CommandMergeTiny());
        Main.addCommand(new CommandProposeFieldNames());
        Main.addCommand(new CommandReorderTiny());
        Main.addCommand(new CommandRewriteIntermediary());
        Main.addCommand(new CommandUpdateIntermediary());
        Main.addCommand(new CommandReorderTinyV2());
        Main.addCommand(new CommandMergeTinyV2());
        Main.addCommand(new CommandProposeV2FieldNames());
        Main.addCommand(new CommandValidateRecords());
    }
}

