/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.fabricmc.stitch.Command;

public class CommandGeneratePrefixRemapper
extends Command {
    public CommandGeneratePrefixRemapper() {
        super("genPrefixedTiny");
    }

    @Override
    public String getHelpString() {
        return "<input JAR> <prefix> <output tinymap> [inname] [outname]";
    }

    @Override
    public boolean isArgumentCountValid(int count) {
        return count == 3 || count == 5;
    }

    @Override
    public void run(String[] args) throws Exception {
        try (FileInputStream fis = new FileInputStream(new File(args[0]));
             FileOutputStream fos = new FileOutputStream(new File(args[2]));
             OutputStreamWriter osw = new OutputStreamWriter(fos);
             BufferedWriter writer = new BufferedWriter(osw);){
            JarEntry entry;
            writer.write("v1\t" + (args.length >= 5 ? args[3] : "input") + "\t" + (args.length >= 5 ? args[4] : "output") + "\n");
            JarInputStream jis = new JarInputStream(fis);
            while ((entry = jis.getNextJarEntry()) != null) {
                if (!entry.getName().endsWith(".class") || entry.getName().indexOf(47) >= 0) continue;
                String cn = entry.getName().substring(0, entry.getName().length() - 6);
                writer.write("CLASS\t" + cn + "\t" + args[1] + cn + "\n");
            }
        }
        System.out.println("Done!");
    }
}

