/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.fabricmc.stitch.Command;

public class CommandMergeTiny
extends Command {
    private List<String> mappingBlankFillOrder = new ArrayList<String>();
    private String sharedIndexName;
    private TinyFile inputA;
    private TinyFile inputB;

    public CommandMergeTiny() {
        super("mergeTiny");
    }

    @Override
    public String getHelpString() {
        return "<input-a> <input-b> <output> [mappingBlankFillOrder...]";
    }

    @Override
    public boolean isArgumentCountValid(int count) {
        return count >= 4;
    }

    private String fixMatch(TinyEntry a, TinyEntry b, String matchA, String index) {
        if (a == null || matchA == null) {
            return matchA;
        }
        if (a.type == TinyEntryType.CLASS && a.getParent() != null && a.getParent().type == TinyEntryType.CLASS) {
            String officialPath = a.names.get(this.sharedIndexName);
            TinyEntry officialEntry = a.getParent();
            while (officialEntry.type == TinyEntryType.CLASS) {
                officialPath = officialEntry.names.get(this.sharedIndexName) + "$" + officialPath;
                officialEntry = officialEntry.getParent();
            }
            LinkedHashSet<String> matchingOrder = new LinkedHashSet<String>();
            matchingOrder.add(index);
            matchingOrder.addAll(this.mappingBlankFillOrder);
            String[] path = officialPath.split("\\$");
            a = this.inputA.root;
            b = this.inputB.root;
            StringBuilder targetName = new StringBuilder();
            for (int i = 0; i < path.length; ++i) {
                if (i > 0) {
                    targetName.append('$');
                }
                a = a != null ? a.getChild(this.sharedIndexName, path[i]) : null;
                b = b != null ? b.getChild(this.sharedIndexName, path[i]) : null;
                boolean appended = false;
                for (String mName : matchingOrder) {
                    String nameB;
                    String nameA = a != null ? a.names.get(mName) : null;
                    String string = nameB = b != null ? b.names.get(mName) : null;
                    if (nameA != null) {
                        targetName.append(nameA);
                        appended = true;
                        break;
                    }
                    if (nameB == null) continue;
                    targetName.append(nameB);
                    appended = true;
                    break;
                }
                if (appended) continue;
                throw new RuntimeException("Could not find mapping for " + officialPath + "!");
            }
            return targetName.toString();
        }
        return matchA;
    }

    private String getMatch(TinyEntry a, TinyEntry b, String index, String realIndex) {
        String matchB;
        String matchA = a != null ? a.names.get(index) : null;
        String string = matchB = b != null ? b.names.get(index) : null;
        assert (a == null || b == null || a.type == b.type);
        matchA = this.fixMatch(a, b, matchA, realIndex);
        matchB = this.fixMatch(b, a, matchB, realIndex);
        if (matchA != null) {
            if (matchB != null && !matchA.equals(matchB)) {
                throw new RuntimeException("No match: " + index + " " + matchA + " " + matchB);
            }
            return matchA;
        }
        return matchB;
    }

    private String getEntry(TinyEntry a, TinyEntry b, List<String> totalIndexList) {
        if (a != null && b != null && !a.header.equals(b.header)) {
            throw new RuntimeException("Header mismatch: " + a.header + " != " + b.header);
        }
        if (a != null && b != null && a.type != b.type) {
            throw new RuntimeException("Type mismatch: " + (Object)((Object)a.type) + " != " + (Object)((Object)b.type));
        }
        String header = a != null ? a.header : b.header;
        StringBuilder entry = new StringBuilder();
        entry.append(header);
        for (String index : totalIndexList) {
            entry.append('\t');
            String match = this.getMatch(a, b, index, index);
            if (match == null) {
                String s;
                Iterator<String> iterator = this.mappingBlankFillOrder.iterator();
                while (iterator.hasNext() && (match = this.getMatch(a, b, s = iterator.next(), index)) == null) {
                }
                if (match == null) {
                    throw new RuntimeException("TODO");
                }
            }
            entry.append(match);
        }
        entry.append('\n');
        return entry.toString();
    }

    public void write(TinyEntry inputA, TinyEntry inputB, String index, String c, BufferedWriter writer, List<String> totalIndexList, int indent) throws IOException {
        TinyEntry classB;
        TinyEntry classA = inputA != null ? inputA.getChild(index, c) : null;
        TinyEntry tinyEntry = classB = inputB != null ? inputB.getChild(index, c) : null;
        if (!(classA != null && classA.names.size() != 0 || classB != null && classB.names.size() != 0)) {
            System.out.println("Warning: empty!");
            return;
        }
        writer.write(this.getEntry(classA, classB, totalIndexList));
        TreeSet<String> subKeys = new TreeSet<String>();
        if (classA != null) {
            subKeys.addAll(classA.getChildRow(index).keySet());
        }
        if (classB != null) {
            subKeys.addAll(classB.getChildRow(index).keySet());
        }
        for (String cc : subKeys) {
            this.write(classA, classB, index, cc, writer, totalIndexList, indent + 1);
        }
    }

    public void run(File inputAf, File inputBf, File outputf, String ... mappingBlankFillOrderValues) throws IOException {
        for (String string : mappingBlankFillOrderValues) {
            if (this.mappingBlankFillOrder.contains(string)) continue;
            this.mappingBlankFillOrder.add(string);
        }
        System.out.println("Reading " + inputAf.getName());
        this.inputA = new TinyFile(inputAf);
        System.out.println("Reading " + inputBf.getName());
        this.inputB = new TinyFile(inputBf);
        System.out.println("Processing...");
        try (BufferedWriter writer = Files.newBufferedWriter(outputf.toPath(), Charset.forName("UTF-8"), new OpenOption[0]);){
            if (!this.inputA.indexList[0].equals(this.inputB.indexList[0])) {
                throw new RuntimeException("TODO");
            }
            this.sharedIndexName = this.inputA.indexList[0];
            Set<String> matchedIndexes = Collections.singleton(this.inputA.indexList[0]);
            ArrayList<String> totalIndexList = new ArrayList<String>(Arrays.asList(this.inputA.indexList));
            for (String s : this.inputB.indexList) {
                if (totalIndexList.contains(s)) continue;
                totalIndexList.add(s);
            }
            int n = totalIndexList.size();
            StringBuilder header = new StringBuilder();
            header.append("v1");
            for (String s : totalIndexList) {
                header.append('\t');
                header.append(s);
            }
            writer.write(header.append('\n').toString());
            String index = this.inputA.indexList[0];
            TreeSet<String> classKeys = new TreeSet<String>();
            classKeys.addAll(this.inputA.root.getChildRow(index).keySet());
            classKeys.addAll(this.inputB.root.getChildRow(index).keySet());
            for (String c : classKeys) {
                this.write(this.inputA.root, this.inputB.root, index, c, writer, totalIndexList, 0);
            }
        }
        System.out.println("Done!");
    }

    @Override
    public void run(String[] args) throws Exception {
        File inputAf = new File(args[0]);
        File inputBf = new File(args[1]);
        File outputf = new File(args[2]);
        String[] mbforder = new String[args.length - 3];
        for (int i = 3; i < args.length; ++i) {
            mbforder[i - 3] = args[i];
        }
        this.run(inputAf, inputBf, outputf, mbforder);
    }

    public static class TinyEntry {
        public final TinyEntryType type;
        public final String header;
        public final Map<String, String> names = new HashMap<String, String>();
        private final Map<String, Map<String, TinyEntry>> children = new HashMap<String, Map<String, TinyEntry>>();
        private TinyEntry parent;

        public TinyEntry(TinyEntryType type, String header) {
            this.type = type;
            this.header = header;
        }

        public TinyEntry getParent() {
            return this.parent;
        }

        public boolean containsChild(String key, String value) {
            Map<String, TinyEntry> map = this.children.get(key);
            return map != null && map.containsKey(value);
        }

        public TinyEntry getChild(String key, String value) {
            Map<String, TinyEntry> map = this.children.get(key);
            return map != null ? map.get(value) : null;
        }

        public void putChild(String key, String value, TinyEntry entry) {
            this.children.computeIfAbsent(key, s -> new HashMap()).put(value, entry);
        }

        public void addChild(TinyEntry entry, String nameSuffix) {
            entry.parent = this;
            for (Map.Entry<String, String> e : entry.names.entrySet()) {
                String value;
                String key = e.getKey();
                if (this.containsChild(key, value = e.getValue() + nameSuffix)) {
                    throw new RuntimeException("Duplicate TinyEntry: (" + key + ", " + value + ")!");
                }
                this.putChild(key, value, entry);
            }
        }

        public Map<String, TinyEntry> getChildRow(String key) {
            return this.children.getOrDefault(key, Collections.EMPTY_MAP);
        }
    }

    public static enum TinyEntryType {
        ROOT,
        CLASS,
        FIELD,
        METHOD;

        private static Map<String, TinyEntryType> BY_NAME;

        public static TinyEntryType byName(String s) {
            return BY_NAME.get(s);
        }

        static {
            BY_NAME = new HashMap<String, TinyEntryType>();
            for (TinyEntryType type : TinyEntryType.values()) {
                BY_NAME.put(type.name(), type);
            }
        }
    }

    public static class TinyFile {
        public final String[] indexList;
        public final TinyEntry root = new TinyEntry(TinyEntryType.ROOT, "");
        public final int typeCount;

        public TinyFile(File f) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(f.toPath(), Charset.forName("UTF-8"));){
                String line;
                String[] header = reader.readLine().trim().split("\t");
                if (header.length < 3 || !header[0].trim().equals("v1")) {
                    throw new RuntimeException("Invalid header!");
                }
                this.typeCount = header.length - 1;
                this.indexList = new String[this.typeCount];
                for (int i = 0; i < this.typeCount; ++i) {
                    this.indexList[i] = header[i + 1].trim();
                }
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    String[] parts = line.split("\t");
                    for (int i = 0; i < parts.length; ++i) {
                        parts[i] = parts[i].trim();
                    }
                    StringBuilder prefix = new StringBuilder();
                    prefix.append(parts[0]);
                    for (int i = 1; i < parts.length - this.typeCount; ++i) {
                        prefix.append('\t');
                        prefix.append(parts[i]);
                    }
                    TinyEntryType type = TinyEntryType.byName(parts[0]);
                    String[] path = parts[1].split("\\$");
                    TinyEntry parent = this.root;
                    for (int i = 0; i < (type == TinyEntryType.CLASS ? path.length - 1 : path.length); ++i) {
                        TinyEntry nextParent = parent.getChild(this.indexList[0], path[i]);
                        if (nextParent == null) {
                            nextParent = new TinyEntry(TinyEntryType.CLASS, "CLASS");
                            nextParent.names.put(this.indexList[0], path[i]);
                            parent.addChild(nextParent, "");
                        }
                        parent = nextParent;
                    }
                    TinyEntry entry = type == TinyEntryType.CLASS && parent.containsChild(this.indexList[0], path[path.length - 1]) ? parent.getChild(this.indexList[0], path[path.length - 1]) : new TinyEntry(type, prefix.toString());
                    String[] names = new String[this.typeCount];
                    for (int i = 0; i < this.typeCount; ++i) {
                        names[i] = parts[parts.length - this.typeCount + i];
                        if (type == TinyEntryType.CLASS) {
                            String[] splitly = names[i].split("\\$");
                            entry.names.put(this.indexList[i], splitly[splitly.length - 1]);
                            continue;
                        }
                        entry.names.put(this.indexList[i], names[i]);
                    }
                    switch (type) {
                        case CLASS: {
                            parent.addChild(entry, "");
                            break;
                        }
                        case FIELD: 
                        case METHOD: {
                            parent.addChild(entry, parts[2]);
                        }
                    }
                }
            }
        }
    }
}

