/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.mappings.EntryTriple;
import net.fabricmc.mappings.FieldEntry;
import net.fabricmc.mappings.Mappings;
import net.fabricmc.mappings.MappingsProvider;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.util.FieldNameFinder;

public class CommandProposeFieldNames
extends Command {
    public CommandProposeFieldNames() {
        super("proposeFieldNames");
    }

    @Override
    public String getHelpString() {
        return "<input jar> <input mappings> <output mappings>";
    }

    @Override
    public boolean isArgumentCountValid(int count) {
        return count == 3;
    }

    @Override
    public void run(String[] args) throws Exception {
        Mappings mappings;
        Map<EntryTriple, String> fieldNamesO = new FieldNameFinder().findNames(new File(args[0]));
        System.err.println("Found " + fieldNamesO.size() + " interesting names.");
        Map<Object, Object> fieldNames = new HashMap();
        try (FileInputStream fileIn = new FileInputStream(new File(args[1]));){
            mappings = MappingsProvider.readTinyMappings((InputStream)fileIn, (boolean)false);
        }
        fileIn = new FileInputStream(new File(args[1]));
        try (FileOutputStream fileOut = new FileOutputStream(new File(args[2]));
             InputStreamReader fileInReader = new InputStreamReader(fileIn);
             OutputStreamWriter fileOutWriter = new OutputStreamWriter(fileOut);
             BufferedReader reader = new BufferedReader(fileInReader);
             BufferedWriter writer = new BufferedWriter(fileOutWriter);){
            String line;
            int headerPos = -1;
            while ((line = reader.readLine()) != null) {
                String[] tabSplit = line.split("\t");
                if (headerPos < 0) {
                    if (tabSplit.length < 3) {
                        throw new RuntimeException("Invalid mapping file!");
                    }
                    for (int i = 2; i < tabSplit.length; ++i) {
                        if (!tabSplit[i].equals("named")) continue;
                        headerPos = i;
                        break;
                    }
                    if (headerPos < 0) {
                        throw new RuntimeException("Could not find 'named' mapping position!");
                    }
                    if (!tabSplit[1].equals("official")) {
                        for (FieldEntry e : mappings.getFieldEntries()) {
                            EntryTriple officialFieldMapping = e.get("official");
                            String name = fieldNamesO.get(officialFieldMapping);
                            if (name == null) continue;
                            fieldNames.put(e.get(tabSplit[1]), name);
                        }
                    } else {
                        fieldNames = fieldNamesO;
                    }
                    mappings = null;
                } else if (tabSplit[0].equals("FIELD")) {
                    EntryTriple key = new EntryTriple(tabSplit[1], tabSplit[3], tabSplit[2]);
                    String value = tabSplit[headerPos + 2];
                    if (value.startsWith("field_") && fieldNames.containsKey(key)) {
                        tabSplit[headerPos + 2] = (String)fieldNames.get(key);
                        StringBuilder builder = new StringBuilder(tabSplit[0]);
                        for (int i = 1; i < tabSplit.length; ++i) {
                            builder.append('\t');
                            builder.append(tabSplit[i]);
                        }
                        line = builder.toString();
                    }
                }
                if (!line.endsWith("\n")) {
                    line = line + "\n";
                }
                writer.write(line);
            }
        }
        finally {
            fileIn.close();
        }
    }
}

