/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import net.fabricmc.mappings.EntryTriple;
import net.fabricmc.mappings.Mappings;
import net.fabricmc.mappings.MappingsProvider;
import net.fabricmc.stitch.Command;

public class CommandReorderTiny
extends Command {
    public CommandReorderTiny() {
        super("reorderTiny");
    }

    @Override
    public String getHelpString() {
        return "<old-mapping-file> <new-mapping-file> [name order...]";
    }

    @Override
    public boolean isArgumentCountValid(int count) {
        return count >= 4;
    }

    private int compareTriples(EntryTriple a, EntryTriple b) {
        int c = a.getOwner().compareTo(b.getOwner());
        if (c == 0 && (c = a.getDesc().compareTo(b.getDesc())) == 0) {
            c = a.getName().compareTo(b.getName());
        }
        return c;
    }

    @Override
    public void run(String[] args) throws Exception {
        Mappings input;
        File fileOld = new File(args[0]);
        File fileNew = new File(args[1]);
        String[] names = new String[args.length - 2];
        System.arraycopy(args, 2, names, 0, names.length);
        System.err.println("Loading mapping file...");
        try (Closeable stream = new FileInputStream(fileOld);){
            input = MappingsProvider.readTinyMappings((InputStream)stream, (boolean)false);
        }
        System.err.println("Rewriting mappings...");
        stream = new FileOutputStream(fileNew);
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)stream);
             BufferedWriter writer = new BufferedWriter(osw);){
            StringBuilder firstLineBuilder = new StringBuilder("v1");
            for (String name : names) {
                firstLineBuilder.append('\t').append(name);
            }
            writer.write(firstLineBuilder.append('\n').toString());
            input.getClassEntries().stream().sorted(Comparator.comparing(a -> a.get(names[0]))).forEach(entry -> {
                try {
                    StringBuilder s = new StringBuilder("CLASS");
                    for (String name : names) {
                        s.append('\t').append(entry.get(name));
                    }
                    writer.write(s.append('\n').toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            input.getFieldEntries().stream().sorted((a, b) -> this.compareTriples(a.get(names[0]), b.get(names[0]))).forEach(entry -> {
                try {
                    StringBuilder s = new StringBuilder("FIELD");
                    EntryTriple first = entry.get(names[0]);
                    s.append('\t').append(first.getOwner()).append('\t').append(first.getDesc());
                    for (String name : names) {
                        s.append('\t').append(entry.get(name).getName());
                    }
                    writer.write(s.append('\n').toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            input.getMethodEntries().stream().sorted((a, b) -> this.compareTriples(a.get(names[0]), b.get(names[0]))).forEach(entry -> {
                try {
                    StringBuilder s = new StringBuilder("METHOD");
                    EntryTriple first = entry.get(names[0]);
                    s.append('\t').append(first.getOwner()).append('\t').append(first.getDesc());
                    for (String name : names) {
                        s.append('\t').append(entry.get(name).getName());
                    }
                    writer.write(s.append('\n').toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        finally {
            ((FileOutputStream)stream).close();
        }
        System.err.println("Done!");
    }
}

