/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.mappings.ClassEntry;
import net.fabricmc.mappings.EntryTriple;
import net.fabricmc.mappings.FieldEntry;
import net.fabricmc.mappings.Mappings;
import net.fabricmc.mappings.MethodEntry;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GenMap {
    private final Map<String, Class> map = new HashMap<String, Class>();

    public void addClass(String from, String to) {
        this.map.put(from, new Class(to));
    }

    public void addField(EntryTriple from, EntryTriple to) {
        this.map.get(from.getOwner()).fieldMaps.put(from, to);
    }

    public void addMethod(EntryTriple from, EntryTriple to) {
        this.map.get(from.getOwner()).methodMaps.put(from, to);
    }

    public void load(Mappings mappings, String from, String to) {
        for (ClassEntry classEntry : mappings.getClassEntries()) {
            this.map.put(classEntry.get(from), new Class(classEntry.get(to)));
        }
        for (FieldEntry fieldEntry : mappings.getFieldEntries()) {
            this.map.get(fieldEntry.get(from).getOwner()).fieldMaps.put(fieldEntry.get(from), fieldEntry.get(to));
        }
        for (MethodEntry methodEntry : mappings.getMethodEntries()) {
            this.map.get(methodEntry.get(from).getOwner()).methodMaps.put(methodEntry.get(from), methodEntry.get(to));
        }
    }

    public @Nullable String getClass(String from) {
        return this.map.containsKey(from) ? this.map.get(from).name : null;
    }

    private @Nullable EntryTriple get(EntryTriple entry, Function<Class, Map<EntryTriple, EntryTriple>> mapGetter) {
        if (this.map.containsKey(entry.getOwner())) {
            return mapGetter.apply(this.map.get(entry.getOwner())).get(entry);
        }
        return null;
    }

    public @Nullable EntryTriple getField(String owner, String name, String desc) {
        return this.get(new EntryTriple(owner, name, desc), c -> ((Class)c).fieldMaps);
    }

    public @Nullable EntryTriple getField(EntryTriple entry) {
        return this.get(entry, c -> ((Class)c).fieldMaps);
    }

    public @Nullable EntryTriple getMethod(String owner, String name, String desc) {
        return this.get(new EntryTriple(owner, name, desc), c -> ((Class)c).methodMaps);
    }

    public @Nullable EntryTriple getMethod(EntryTriple entry) {
        return this.get(entry, c -> ((Class)c).methodMaps);
    }

    private static class Class {
        private final String name;
        private final Map<EntryTriple, EntryTriple> fieldMaps = new HashMap<EntryTriple, EntryTriple>();
        private final Map<EntryTriple, EntryTriple> methodMaps = new HashMap<EntryTriple, EntryTriple>();

        public Class(String name) {
            this.name = name;
        }
    }

    public static class Dummy
    extends GenMap {
        @Override
        public @Nullable String getClass(String from) {
            return from;
        }

        @Override
        public @Nullable EntryTriple getField(String owner, String name, String desc) {
            return new EntryTriple(owner, name, desc);
        }

        @Override
        public @Nullable EntryTriple getField(EntryTriple entry) {
            return entry;
        }

        @Override
        public @Nullable EntryTriple getMethod(String owner, String name, String desc) {
            return new EntryTriple(owner, name, desc);
        }

        @Override
        public @Nullable EntryTriple getMethod(EntryTriple entry) {
            return entry;
        }
    }
}

