/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.fabricmc.mappings.EntryTriple;
import net.fabricmc.mappings.MappingsProvider;
import net.fabricmc.stitch.commands.GenMap;
import net.fabricmc.stitch.representation.AbstractJarEntry;
import net.fabricmc.stitch.representation.ClassStorage;
import net.fabricmc.stitch.representation.JarClassEntry;
import net.fabricmc.stitch.representation.JarFieldEntry;
import net.fabricmc.stitch.representation.JarMethodEntry;
import net.fabricmc.stitch.representation.JarRootEntry;
import net.fabricmc.stitch.util.MatcherUtil;
import net.fabricmc.stitch.util.Pair;
import net.fabricmc.stitch.util.StitchUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

class GenState {
    private final Map<String, Integer> counters = new HashMap<String, Integer>();
    private final Map<AbstractJarEntry, Integer> values = new IdentityHashMap<AbstractJarEntry, Integer>();
    private GenMap oldToIntermediary;
    private GenMap newToOld;
    private GenMap newToIntermediary;
    private boolean interactive = true;
    private boolean writeAll = false;
    private Scanner scanner = new Scanner(System.in);
    private String targetNamespace = "net/minecraft/";
    private final List<Pattern> obfuscatedPatterns = new ArrayList<Pattern>();
    private final Map<JarMethodEntry, String> methodNames = new IdentityHashMap<JarMethodEntry, String>();

    public GenState() {
        this.obfuscatedPatterns.add(Pattern.compile("^[^/]*$"));
    }

    public void setWriteAll(boolean writeAll) {
        this.writeAll = writeAll;
    }

    public void disableInteractive() {
        this.interactive = false;
    }

    public String next(AbstractJarEntry entry, String name) {
        return name + "_" + this.values.computeIfAbsent(entry, e -> {
            int v = this.counters.getOrDefault(name, 1);
            this.counters.put(name, v + 1);
            return v;
        });
    }

    public void setTargetNamespace(String namespace) {
        this.targetNamespace = namespace.lastIndexOf("/") != namespace.length() - 1 ? namespace + "/" : namespace;
    }

    public void clearObfuscatedPatterns() {
        this.obfuscatedPatterns.clear();
    }

    public void addObfuscatedPattern(String regex) throws PatternSyntaxException {
        this.obfuscatedPatterns.add(Pattern.compile(regex));
    }

    public void setCounter(String key, int value) {
        this.counters.put(key, value);
    }

    public Map<String, Integer> getCounters() {
        return Collections.unmodifiableMap(this.counters);
    }

    public void generate(File file, JarRootEntry jarEntry, JarRootEntry jarOld) throws IOException {
        if (file.exists()) {
            System.err.println("Target file exists - loading...");
            this.newToIntermediary = new GenMap();
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.newToIntermediary.load(MappingsProvider.readTinyMappings((InputStream)inputStream), "official", "intermediary");
            }
        }
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter writer = new BufferedWriter(fileWriter);){
            writer.write("v1\tofficial\tintermediary\n");
            for (JarClassEntry c : jarEntry.getClasses()) {
                this.addClass(writer, c, jarOld, jarEntry, this.targetNamespace);
            }
            this.writeCounters(writer);
        }
    }

    public static boolean isMappedClass(ClassStorage storage, JarClassEntry c) {
        return !c.isAnonymous();
    }

    public static boolean isMappedField(ClassStorage storage, JarClassEntry c, JarFieldEntry f) {
        return GenState.isUnmappedFieldName(f.getName());
    }

    public static boolean isUnmappedFieldName(String name) {
        return name.length() <= 2 || name.length() == 3 && name.charAt(2) == '_';
    }

    public static boolean isMappedMethod(ClassStorage storage, JarClassEntry c, JarMethodEntry m) {
        return GenState.isUnmappedMethodName(m.getName()) && m.isSource(storage, c);
    }

    public static boolean isUnmappedMethodName(String name) {
        return (name.length() <= 2 || name.length() == 3 && name.charAt(2) == '_') && name.charAt(0) != '<';
    }

    private @Nullable String getFieldName(ClassStorage storage, JarClassEntry c, JarFieldEntry f) {
        EntryTriple findEntry;
        if (!GenState.isMappedField(storage, c, f)) {
            return null;
        }
        if (this.newToIntermediary != null && (findEntry = this.newToIntermediary.getField(c.getFullyQualifiedName(), f.getName(), f.getDescriptor())) != null) {
            if (findEntry.getName().contains("field_")) {
                return findEntry.getName();
            }
            String newName = this.next(f, "field");
            System.out.println(findEntry.getName() + " is now " + newName);
            return newName;
        }
        if (this.newToOld != null && (findEntry = this.newToOld.getField(c.getFullyQualifiedName(), f.getName(), f.getDescriptor())) != null && (findEntry = this.oldToIntermediary.getField(findEntry)) != null) {
            if (findEntry.getName().contains("field_")) {
                return findEntry.getName();
            }
            String newName = this.next(f, "field");
            System.out.println(findEntry.getName() + " is now " + newName);
            return newName;
        }
        return this.next(f, "field");
    }

    private String getPropagation(ClassStorage storage, JarClassEntry classEntry) {
        if (classEntry == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(classEntry.getFullyQualifiedName());
        ArrayList<String> strings = new ArrayList<String>();
        String scs = this.getPropagation(storage, classEntry.getSuperClass(storage));
        if (!scs.isEmpty()) {
            strings.add(scs);
        }
        for (JarClassEntry ce : classEntry.getInterfaces(storage)) {
            scs = this.getPropagation(storage, ce);
            if (scs.isEmpty()) continue;
            strings.add(scs);
        }
        if (!strings.isEmpty()) {
            builder.append("<-");
            if (strings.size() == 1) {
                builder.append((String)strings.get(0));
            } else {
                builder.append("[");
                builder.append(StitchUtil.join(",", strings));
                builder.append("]");
            }
        }
        return builder.toString();
    }

    private String getNamesListEntry(ClassStorage storage, JarClassEntry classEntry) {
        StringBuilder builder = new StringBuilder(this.getPropagation(storage, classEntry));
        if (classEntry.isInterface()) {
            builder.append("(itf)");
        }
        return builder.toString();
    }

    private Set<JarMethodEntry> findNames(ClassStorage storageOld, ClassStorage storageNew, JarClassEntry c, JarMethodEntry m, Map<String, Set<String>> names) {
        HashSet<JarMethodEntry> allEntries = new HashSet<JarMethodEntry>();
        this.findNames(storageOld, storageNew, c, m, names, allEntries);
        return allEntries;
    }

    private void findNames(ClassStorage storageOld, ClassStorage storageNew, JarClassEntry c, JarMethodEntry m, Map<String, Set<String>> names, Set<JarMethodEntry> usedMethods) {
        if (!usedMethods.add(m)) {
            return;
        }
        String suffix = "." + m.getName() + m.getDescriptor();
        if ((m.getAccess() & 0x40) != 0) {
            suffix = suffix + "(bridge)";
        }
        List<JarClassEntry> ccList = m.getMatchingEntries(storageNew, c);
        for (JarClassEntry cc : ccList) {
            EntryTriple findEntry = null;
            if (this.newToIntermediary != null && (findEntry = this.newToIntermediary.getMethod(cc.getFullyQualifiedName(), m.getName(), m.getDescriptor())) != null) {
                names.computeIfAbsent(findEntry.getName(), s -> new TreeSet()).add(this.getNamesListEntry(storageNew, cc) + suffix);
            }
            if (findEntry != null || this.newToOld == null || (findEntry = this.newToOld.getMethod(cc.getFullyQualifiedName(), m.getName(), m.getDescriptor())) == null) continue;
            EntryTriple newToOldEntry = findEntry;
            if ((findEntry = this.oldToIntermediary.getMethod(newToOldEntry)) != null) {
                names.computeIfAbsent(findEntry.getName(), s -> new TreeSet()).add(this.getNamesListEntry(storageNew, cc) + suffix);
                continue;
            }
            JarClassEntry oldBase = storageOld.getClass(newToOldEntry.getOwner(), false);
            if (oldBase == null) continue;
            JarMethodEntry oldM = oldBase.getMethod(newToOldEntry.getName() + newToOldEntry.getDesc());
            List<JarClassEntry> cccList = oldM.getMatchingEntries(storageOld, oldBase);
            for (JarClassEntry ccc : cccList) {
                findEntry = this.oldToIntermediary.getMethod(ccc.getFullyQualifiedName(), oldM.getName(), oldM.getDescriptor());
                if (findEntry == null) continue;
                names.computeIfAbsent(findEntry.getName(), s -> new TreeSet()).add(this.getNamesListEntry(storageOld, ccc) + suffix);
            }
        }
        for (JarClassEntry mc : ccList) {
            for (Pair<JarClassEntry, String> pair : mc.getRelatedMethods(m)) {
                this.findNames(storageOld, storageNew, pair.getLeft(), pair.getLeft().getMethod(pair.getRight()), names, usedMethods);
            }
        }
    }

    private @Nullable String getMethodName(ClassStorage storageOld, ClassStorage storageNew, JarClassEntry c, JarMethodEntry m) {
        if (!GenState.isMappedMethod(storageNew, c, m)) {
            return null;
        }
        if (this.methodNames.containsKey(m)) {
            return this.methodNames.get(m);
        }
        if (this.newToOld != null || this.newToIntermediary != null) {
            HashMap<String, Set<String>> names = new HashMap<String, Set<String>>();
            Set<JarMethodEntry> allEntries = this.findNames(storageOld, storageNew, c, m, names);
            for (JarMethodEntry mm : allEntries) {
                if (!this.methodNames.containsKey(mm)) continue;
                return this.methodNames.get(mm);
            }
            if (names.size() > 1) {
                int i;
                System.out.println("Conflict detected - matched same target name!");
                ArrayList nameList = new ArrayList(names.keySet());
                Collections.sort(nameList);
                for (int i2 = 0; i2 < nameList.size(); ++i2) {
                    String s = (String)nameList.get(i2);
                    System.out.println(i2 + 1 + ") " + s + " <- " + StitchUtil.join(", ", (Collection)names.get(s)));
                }
                if (!this.interactive) {
                    throw new RuntimeException("Conflict detected!");
                }
                while (true) {
                    String cmd = this.scanner.nextLine();
                    try {
                        i = Integer.parseInt(cmd);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        continue;
                    }
                    if (i >= 1 && i <= nameList.size()) break;
                }
                for (JarMethodEntry mm : allEntries) {
                    this.methodNames.put(mm, (String)nameList.get(i - 1));
                }
                System.out.println("OK!");
                return (String)nameList.get(i - 1);
            }
            if (names.size() == 1) {
                String s = (String)names.keySet().iterator().next();
                for (JarMethodEntry mm : allEntries) {
                    this.methodNames.put(mm, s);
                }
                if (s.contains("method_")) {
                    return s;
                }
                String newName = this.next(m, "method");
                System.out.println(s + " is now " + newName);
                return newName;
            }
        }
        return this.next(m, "method");
    }

    private void addClass(BufferedWriter writer, JarClassEntry c, ClassStorage storageOld, ClassStorage storage, String translatedPrefix) throws IOException {
        String className = c.getName();
        String cname = "";
        String prefixSaved = translatedPrefix;
        if (!this.obfuscatedPatterns.stream().anyMatch(p -> p.matcher(className).matches())) {
            translatedPrefix = c.getFullyQualifiedName();
        } else if (!GenState.isMappedClass(storage, c)) {
            cname = c.getName();
        } else {
            String[] r;
            String findName;
            cname = null;
            if (this.newToIntermediary != null && (findName = this.newToIntermediary.getClass(c.getFullyQualifiedName())) != null) {
                r = findName.split("\\$");
                cname = r[r.length - 1];
                if (r.length == 1) {
                    translatedPrefix = "";
                }
            }
            if (cname == null && this.newToOld != null && (findName = this.newToOld.getClass(c.getFullyQualifiedName())) != null && (findName = this.oldToIntermediary.getClass(findName)) != null) {
                r = findName.split("\\$");
                cname = r[r.length - 1];
                if (r.length == 1) {
                    translatedPrefix = "";
                }
            }
            if (cname != null && !cname.contains("class_")) {
                String newName = this.next(c, "class");
                System.out.println(cname + " is now " + newName);
                cname = newName;
                translatedPrefix = prefixSaved;
            }
            if (cname == null) {
                cname = this.next(c, "class");
            }
        }
        writer.write("CLASS\t" + c.getFullyQualifiedName() + "\t" + translatedPrefix + cname + "\n");
        for (JarFieldEntry f : c.getFields()) {
            String fName = this.getFieldName(storage, c, f);
            if (fName == null) {
                fName = f.getName();
            }
            if (fName == null) continue;
            writer.write("FIELD\t" + c.getFullyQualifiedName() + "\t" + f.getDescriptor() + "\t" + f.getName() + "\t" + fName + "\n");
        }
        for (JarMethodEntry m : c.getMethods()) {
            String mName = this.getMethodName(storageOld, storage, c, m);
            if (mName == null && !m.getName().startsWith("<") && m.isSource(storage, c)) {
                mName = m.getName();
            }
            if (mName == null) continue;
            writer.write("METHOD\t" + c.getFullyQualifiedName() + "\t" + m.getDescriptor() + "\t" + m.getName() + "\t" + mName + "\n");
        }
        for (JarClassEntry cc : c.getInnerClasses()) {
            this.addClass(writer, cc, storageOld, storage, translatedPrefix + cname + "$");
        }
    }

    public void prepareRewrite(File oldMappings) throws IOException {
        this.oldToIntermediary = new GenMap();
        this.newToOld = new GenMap.Dummy();
        this.readCounters(oldMappings);
        try (FileInputStream inputStream = new FileInputStream(oldMappings);){
            this.oldToIntermediary.load(MappingsProvider.readTinyMappings((InputStream)inputStream), "official", "intermediary");
        }
    }

    public void prepareUpdate(File oldMappings, File matches) throws IOException {
        this.oldToIntermediary = new GenMap();
        this.newToOld = new GenMap();
        this.readCounters(oldMappings);
        try (FileInputStream inputStream = new FileInputStream(oldMappings);){
            this.oldToIntermediary.load(MappingsProvider.readTinyMappings((InputStream)inputStream), "official", "intermediary");
        }
        try (FileReader fileReader = new FileReader(matches);
             BufferedReader reader = new BufferedReader(fileReader);){
            MatcherUtil.read(reader, true, this.newToOld::addClass, this.newToOld::addField, this.newToOld::addMethod);
        }
    }

    private void readCounters(File counterFile) throws IOException {
        Path counterPath = this.getExternalCounterFile();
        if (counterPath != null && Files.exists(counterPath, new LinkOption[0])) {
            counterFile = counterPath.toFile();
        }
        try (FileReader fileReader = new FileReader(counterFile);
             BufferedReader reader = new BufferedReader(fileReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("# INTERMEDIARY-COUNTER")) continue;
                String[] parts = line.split(" ");
                this.counters.put(parts[2], Integer.parseInt(parts[3]));
            }
        }
    }

    private void writeCounters(BufferedWriter writer) throws IOException {
        StringJoiner counterLines = new StringJoiner("\n");
        for (Map.Entry<String, Integer> counter : this.counters.entrySet()) {
            counterLines.add("# INTERMEDIARY-COUNTER " + counter.getKey() + " " + counter.getValue());
        }
        writer.write(counterLines.toString());
        Path counterPath = this.getExternalCounterFile();
        if (counterPath != null) {
            Files.write(counterPath, counterLines.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    private Path getExternalCounterFile() {
        if (System.getProperty("stitch.counter") != null) {
            return Paths.get(System.getProperty("stitch.counter"), new String[0]);
        }
        return null;
    }
}

