/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands.tinyv2;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.commands.tinyv2.Mapping;
import net.fabricmc.stitch.commands.tinyv2.TinyClass;
import net.fabricmc.stitch.commands.tinyv2.TinyField;
import net.fabricmc.stitch.commands.tinyv2.TinyFile;
import net.fabricmc.stitch.commands.tinyv2.TinyHeader;
import net.fabricmc.stitch.commands.tinyv2.TinyLocalVariable;
import net.fabricmc.stitch.commands.tinyv2.TinyMethod;
import net.fabricmc.stitch.commands.tinyv2.TinyMethodParameter;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Reader;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Writer;
import net.fabricmc.stitch.util.Pair;

public class CommandMergeTinyV2
extends Command {
    private static final TinyMethod EMPTY_METHOD = new TinyMethod(null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());

    public CommandMergeTinyV2() {
        super("mergeTinyV2");
    }

    @Override
    public String getHelpString() {
        return "<input-a> <input-b> <output>";
    }

    @Override
    public boolean isArgumentCountValid(int count) {
        return count == 3;
    }

    @Override
    public void run(String[] args) throws IOException {
        Path inputA = Paths.get(args[0], new String[0]);
        Path inputB = Paths.get(args[1], new String[0]);
        System.out.println("Reading " + inputA);
        TinyFile tinyFileA = TinyV2Reader.read(inputA);
        System.out.println("Reading " + inputB);
        TinyFile tinyFileB = TinyV2Reader.read(inputB);
        TinyHeader headerA = tinyFileA.getHeader();
        TinyHeader headerB = tinyFileB.getHeader();
        if (headerA.getNamespaces().size() != 2) {
            throw new IllegalArgumentException(inputA + " must have exactly 2 namespaces.");
        }
        if (headerB.getNamespaces().size() != 2) {
            throw new IllegalArgumentException(inputB + " must have exactly 2 namespaces.");
        }
        if (!headerA.getNamespaces().get(0).equals(headerB.getNamespaces().get(0))) {
            throw new IllegalArgumentException(String.format("The input tiny files must have the same namespaces as the first column. (%s has %s while %s has %s)", inputA, headerA.getNamespaces().get(0), inputB, headerB.getNamespaces().get(0)));
        }
        System.out.println("Merging " + inputA + " with " + inputB);
        TinyFile mergedFile = this.merge(tinyFileA, tinyFileB);
        TinyV2Writer.write(mergedFile, Paths.get(args[2], new String[0]));
        System.out.println("Merged mappings written to " + Paths.get(args[2], new String[0]));
    }

    private TinyFile merge(TinyFile inputA, TinyFile inputB) {
        TinyHeader mergedHeader = this.mergeHeaders(inputA.getHeader(), inputB.getHeader());
        List<String> keyUnion = this.keyUnion(inputA.getClassEntries(), inputB.getClassEntries());
        Map<String, TinyClass> inputAClasses = inputA.mapClassesByFirstNamespace();
        Map<String, TinyClass> inputBClasses = inputB.mapClassesByFirstNamespace();
        List<TinyClass> mergedClasses = this.map(keyUnion, key -> {
            TinyClass classA = (TinyClass)inputAClasses.get(key);
            TinyClass classB = (TinyClass)inputBClasses.get(key);
            classA = this.matchEnclosingClassIfNeeded((String)key, classA, inputAClasses);
            classB = this.matchEnclosingClassIfNeeded((String)key, classB, inputBClasses);
            return this.mergeClasses((String)key, classA, classB);
        });
        return new TinyFile(mergedHeader, mergedClasses);
    }

    private TinyClass matchEnclosingClassIfNeeded(String key, TinyClass tinyClass, Map<String, TinyClass> mappings) {
        if (tinyClass == null) {
            String partlyMatchedClassName = this.matchEnclosingClass(key, mappings);
            return new TinyClass(Arrays.asList(key, partlyMatchedClassName));
        }
        return tinyClass;
    }

    @Nonnull
    private String matchEnclosingClass(String sharedName, Map<String, TinyClass> inputBClassBySharedNamespace) {
        String[] path = sharedName.split(CommandMergeTinyV2.escape("$"));
        int parts = path.length;
        for (int i = parts - 2; i >= 0; --i) {
            String currentPath = String.join((CharSequence)"$", Arrays.copyOfRange(path, 0, i + 1));
            TinyClass match = inputBClassBySharedNamespace.get(currentPath);
            if (match == null || match.getClassNames().get(1).isEmpty()) continue;
            return match.getClassNames().get(1) + "$" + String.join((CharSequence)"$", Arrays.copyOfRange(path, i + 1, path.length));
        }
        return sharedName;
    }

    private TinyClass mergeClasses(String sharedClassName, @Nonnull TinyClass classA, @Nonnull TinyClass classB) {
        List<String> mergedNames = this.mergeNames(sharedClassName, classA, classB);
        List<String> mergedComments = this.mergeComments(classA.getComments(), classB.getComments());
        List<Pair<String, String>> methodKeyUnion = this.union(this.mapToFirstNamespaceAndDescriptor(classA), this.mapToFirstNamespaceAndDescriptor(classB));
        Map<Pair<String, String>, TinyMethod> methodsA = classA.mapMethodsByFirstNamespaceAndDescriptor();
        Map<Pair<String, String>, TinyMethod> methodsB = classB.mapMethodsByFirstNamespaceAndDescriptor();
        List<TinyMethod> mergedMethods = this.map(methodKeyUnion, k -> this.mergeMethods((String)k.getLeft(), (TinyMethod)methodsA.get(k), (TinyMethod)methodsB.get(k)));
        List<String> fieldKeyUnion = this.keyUnion(classA.getFields(), classB.getFields());
        Map<String, TinyField> fieldsA = classA.mapFieldsByFirstNamespace();
        Map<String, TinyField> fieldsB = classB.mapFieldsByFirstNamespace();
        List<TinyField> mergedFields = this.map(fieldKeyUnion, k -> this.mergeFields((String)k, (TinyField)fieldsA.get(k), (TinyField)fieldsB.get(k)));
        return new TinyClass(mergedNames, mergedMethods, mergedFields, mergedComments);
    }

    private TinyMethod mergeMethods(String sharedMethodName, @Nullable TinyMethod methodA, @Nullable TinyMethod methodB) {
        String descriptor;
        List<String> mergedNames = this.mergeNames(sharedMethodName, methodA, methodB);
        if (methodA == null) {
            methodA = EMPTY_METHOD;
        }
        if (methodB == null) {
            methodB = EMPTY_METHOD;
        }
        List<String> mergedComments = this.mergeComments(methodA.getComments(), methodB.getComments());
        String string = descriptor = methodA.getMethodDescriptorInFirstNamespace() != null ? methodA.getMethodDescriptorInFirstNamespace() : methodB.getMethodDescriptorInFirstNamespace();
        if (descriptor == null) {
            throw new RuntimeException("no descriptor for key " + sharedMethodName);
        }
        ArrayList<TinyMethodParameter> mergedParameters = new ArrayList<TinyMethodParameter>();
        this.addParameters(methodA, mergedParameters, 2);
        this.addParameters(methodB, mergedParameters, 1);
        ArrayList<TinyLocalVariable> mergedLocalVariables = new ArrayList<TinyLocalVariable>();
        this.addLocalVariables(methodA, mergedLocalVariables, 2);
        this.addLocalVariables(methodB, mergedLocalVariables, 1);
        return new TinyMethod(descriptor, mergedNames, mergedParameters, mergedLocalVariables, mergedComments);
    }

    private void addParameters(TinyMethod method, List<TinyMethodParameter> addTo, int emptySpacePos) {
        for (TinyMethodParameter localVariable : method.getParameters()) {
            ArrayList<String> names = new ArrayList<String>(localVariable.getParameterNames());
            names.add(emptySpacePos, "");
            addTo.add(new TinyMethodParameter(localVariable.getLvIndex(), names, localVariable.getComments()));
        }
    }

    private void addLocalVariables(TinyMethod method, List<TinyLocalVariable> addTo, int emptySpacePos) {
        for (TinyLocalVariable localVariable : method.getLocalVariables()) {
            ArrayList<String> names = new ArrayList<String>(localVariable.getLocalVariableNames());
            names.add(emptySpacePos, "");
            addTo.add(new TinyLocalVariable(localVariable.getLvIndex(), localVariable.getLvStartOffset(), localVariable.getLvTableIndex(), names, localVariable.getComments()));
        }
    }

    private TinyField mergeFields(String sharedFieldName, @Nullable TinyField fieldA, @Nullable TinyField fieldB) {
        String descriptor;
        List<String> mergedNames = this.mergeNames(sharedFieldName, fieldA, fieldB);
        List<String> mergedComments = this.mergeComments(fieldA != null ? fieldA.getComments() : Collections.emptyList(), fieldB != null ? fieldB.getComments() : Collections.emptyList());
        String string = fieldA != null ? fieldA.getFieldDescriptorInFirstNamespace() : (descriptor = fieldB != null ? fieldB.getFieldDescriptorInFirstNamespace() : null);
        if (descriptor == null) {
            throw new RuntimeException("no descriptor for key " + sharedFieldName);
        }
        return new TinyField(descriptor, mergedNames, mergedComments);
    }

    private TinyHeader mergeHeaders(TinyHeader headerA, TinyHeader headerB) {
        ArrayList<String> namespaces = new ArrayList<String>(headerA.getNamespaces());
        namespaces.add(headerB.getNamespaces().get(1));
        return new TinyHeader(namespaces, headerA.getMajorVersion(), headerA.getMinorVersion(), headerA.getProperties());
    }

    private List<String> mergeComments(Collection<String> commentsA, Collection<String> commentsB) {
        return this.union(commentsA, commentsB);
    }

    private <T extends Mapping> List<String> keyUnion(Collection<T> mappingsA, Collection<T> mappingB) {
        return this.union(mappingsA.stream().map(m -> m.getMapping().get(0)), mappingB.stream().map(m -> m.getMapping().get(0)));
    }

    private Stream<Pair<String, String>> mapToFirstNamespaceAndDescriptor(TinyClass tinyClass) {
        return tinyClass.getMethods().stream().map(m -> Pair.of(m.getMapping().get(0), m.getMethodDescriptorInFirstNamespace()));
    }

    private List<String> mergeNames(String key, @Nullable Mapping mappingA, @Nullable Mapping mappingB) {
        ArrayList<String> merged = new ArrayList<String>();
        merged.add(key);
        merged.add(this.mappingExists(mappingA) ? mappingA.getMapping().get(1) : key);
        merged.add(this.mappingExists(mappingB) ? mappingB.getMapping().get(1) : key);
        return merged;
    }

    private boolean mappingExists(@Nullable Mapping mapping) {
        return mapping != null && !mapping.getMapping().get(1).isEmpty();
    }

    private <T> List<T> union(Stream<T> list1, Stream<T> list2) {
        return this.union(list1.collect(Collectors.toList()), list2.collect(Collectors.toList()));
    }

    private <T> List<T> union(Collection<T> list1, Collection<T> list2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(list1);
        set.addAll(list2);
        return new ArrayList(set);
    }

    private static String escape(String str) {
        return Pattern.quote(str);
    }

    private <S, E> List<E> map(List<S> from, Function<S, E> mapper) {
        return from.stream().map(mapper).collect(Collectors.toList());
    }
}

