/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands.tinyv2;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.mappings.EntryTriple;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.commands.tinyv2.TinyClass;
import net.fabricmc.stitch.commands.tinyv2.TinyField;
import net.fabricmc.stitch.commands.tinyv2.TinyFile;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Reader;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Writer;
import net.fabricmc.stitch.util.FieldNameFinder;

public class CommandProposeV2FieldNames
extends Command {
    public CommandProposeV2FieldNames() {
        super("proposeV2FieldNames");
    }

    @Override
    public String getHelpString() {
        return "<input jar> <input mappings> <output mappings> <should replace>";
    }

    @Override
    public boolean isArgumentCountValid(int count) {
        return count == 4;
    }

    private Map<EntryTriple, TinyField> generatedNamesOfClass(TinyClass tinyClass) {
        return tinyClass.getFields().stream().collect(Collectors.toMap(field -> new EntryTriple(tinyClass.getClassNames().get(0), field.getFieldNames().get(0), field.getFieldDescriptorInFirstNamespace()), field -> field));
    }

    @Override
    public void run(String[] args) throws Exception {
        File inputJar = new File(args[0]);
        Path inputMappings = Paths.get(args[1], new String[0]);
        Path outputMappings = Paths.get(args[2], new String[0]);
        Boolean shouldReplace = this.parseBooleanOrNull(args[3]);
        if (!inputJar.exists()) {
            throw new IllegalArgumentException("Cannot find input jar at " + inputJar);
        }
        if (!Files.exists(inputMappings, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot find input mappings at " + inputMappings);
        }
        if (Files.exists(outputMappings, new LinkOption[0])) {
            System.out.println("Warning: existing file will be replaced by output mappings");
        }
        if (shouldReplace == null) {
            throw new IllegalArgumentException("<should replace> must be 'true' or 'false'");
        }
        Map<EntryTriple, String> generatedFieldNames = new FieldNameFinder().findNames(new File(args[0]));
        System.err.println("Found " + generatedFieldNames.size() + " interesting names.");
        TinyFile tinyFile = TinyV2Reader.read(Paths.get(args[1], new String[0]));
        HashMap fieldsMap = new HashMap();
        tinyFile.getClassEntries().stream().map(this::generatedNamesOfClass).forEach(map -> map.forEach(fieldsMap::put));
        Map<String, TinyClass> classMap = tinyFile.mapClassesByFirstNamespace();
        int replaceCount = 0;
        for (Map.Entry<EntryTriple, String> entry : generatedFieldNames.entrySet()) {
            EntryTriple key = entry.getKey();
            String newName = entry.getValue();
            TinyField field = (TinyField)fieldsMap.get(key);
            if (field != null) {
                if (!shouldReplace.booleanValue()) continue;
                field.getFieldNames().set(1, newName);
                ++replaceCount;
                continue;
            }
            TinyClass tinyClass = classMap.get(key.getOwner());
            if (tinyClass == null) continue;
            tinyClass.getFields().add(new TinyField(key.getDesc(), Lists.newArrayList((Object[])new String[]{key.getName(), newName}), Lists.newArrayList()));
            ++replaceCount;
        }
        System.err.println("Replaced " + replaceCount + " names in the mappings.");
        Path newMappingsLocation = Paths.get(args[2], new String[0]);
        TinyV2Writer.write(tinyFile, newMappingsLocation);
    }

    @Nullable
    private Boolean parseBooleanOrNull(String booleanLiteral) {
        String lowerCase = booleanLiteral.toLowerCase();
        if (lowerCase.equals("true")) {
            return Boolean.TRUE;
        }
        if (lowerCase.equals("false")) {
            return Boolean.FALSE;
        }
        return null;
    }
}

