/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands.tinyv2;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.stitch.Command;
import net.fabricmc.stitch.commands.tinyv2.TinyClass;
import net.fabricmc.stitch.commands.tinyv2.TinyField;
import net.fabricmc.stitch.commands.tinyv2.TinyFile;
import net.fabricmc.stitch.commands.tinyv2.TinyLocalVariable;
import net.fabricmc.stitch.commands.tinyv2.TinyMethod;
import net.fabricmc.stitch.commands.tinyv2.TinyMethodParameter;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Reader;
import net.fabricmc.stitch.commands.tinyv2.TinyV2Writer;

public class CommandReorderTinyV2
extends Command {
    private static final Collection<String> primitiveTypeNames = Arrays.asList("B", "C", "D", "F", "I", "J", "S", "Z");

    public CommandReorderTinyV2() {
        super("reorderTinyV2");
    }

    @Override
    public String getHelpString() {
        return "<old-mapping-file> <new-mapping-file> [new name order...]";
    }

    @Override
    public boolean isArgumentCountValid(int count) {
        return count >= 4;
    }

    @Override
    public void run(String[] args) throws Exception {
        Path oldMappingFile = Paths.get(args[0], new String[0]);
        Path newMappingFile = Paths.get(args[1], new String[0]);
        List<String> newOrder = Arrays.asList(Arrays.copyOfRange(args, 2, args.length));
        TinyFile tinyFile = TinyV2Reader.read(oldMappingFile);
        this.validateNamespaces(newOrder, tinyFile);
        Map<String, TinyClass> mappingCopy = tinyFile.getClassEntries().stream().collect(Collectors.toMap(c -> c.getClassNames().get(0), c -> new TinyClass(new ArrayList<String>(c.getClassNames()), c.getMethods(), c.getFields(), c.getComments())));
        int newFirstNamespaceOldIndex = tinyFile.getHeader().getNamespaces().indexOf(newOrder.get(0));
        this.reorder(tinyFile, newOrder);
        this.remapDescriptors(tinyFile, mappingCopy, newFirstNamespaceOldIndex);
        TinyV2Writer.write(tinyFile, newMappingFile);
    }

    private void validateNamespaces(List<String> newOrder, TinyFile tinyFile) {
        HashSet<String> providedNamespacesOrderless;
        HashSet<String> fileNamespacesOrderless = new HashSet<String>(tinyFile.getHeader().getNamespaces());
        if (!fileNamespacesOrderless.equals(providedNamespacesOrderless = new HashSet<String>(newOrder))) {
            throw new IllegalArgumentException("The tiny file has different namespaces than those specified. specified: " + providedNamespacesOrderless.toString() + ", file: " + fileNamespacesOrderless.toString());
        }
    }

    private void reorder(TinyFile tinyFile, List<String> newOrder) {
        HashMap<Integer, Integer> indexMapping = new HashMap<Integer, Integer>();
        for (int i = 0; i < newOrder.size(); ++i) {
            indexMapping.put(tinyFile.getHeader().getNamespaces().indexOf(newOrder.get(i)), i);
        }
        this.visitNames(tinyFile, names -> {
            for (int i = names.size(); i < newOrder.size(); ++i) {
                names.add("");
            }
            ArrayList namesCopy = new ArrayList(names);
            for (int i = 0; i < namesCopy.size(); ++i) {
                names.set((Integer)indexMapping.get(i), (String)namesCopy.get(i));
            }
        });
    }

    private void remapDescriptors(TinyFile tinyFile, Map<String, TinyClass> mappings, int targetNamespace) {
        for (TinyClass tinyClass : tinyFile.getClassEntries()) {
            for (TinyMethod method : tinyClass.getMethods()) {
                this.remapMethodDescriptor(method, mappings, targetNamespace);
            }
            for (TinyField field : tinyClass.getFields()) {
                this.remapFieldDescriptor(field, mappings, targetNamespace);
            }
        }
    }

    private void visitNames(TinyFile tinyFile, Consumer<List<String>> namesVisitor) {
        namesVisitor.accept(tinyFile.getHeader().getNamespaces());
        for (TinyClass tinyClass : tinyFile.getClassEntries()) {
            namesVisitor.accept(tinyClass.getClassNames());
            for (TinyMethod method : tinyClass.getMethods()) {
                namesVisitor.accept(method.getMethodNames());
                for (TinyMethodParameter parameter : method.getParameters()) {
                    namesVisitor.accept(parameter.getParameterNames());
                }
                for (TinyLocalVariable localVariable : method.getLocalVariables()) {
                    namesVisitor.accept(localVariable.getLocalVariableNames());
                }
            }
            for (TinyField field : tinyClass.getFields()) {
                namesVisitor.accept(field.getFieldNames());
            }
        }
    }

    private void remapFieldDescriptor(TinyField field, Map<String, TinyClass> mappings, int targetNamespace) {
        String newDescriptor = this.remapType(field.getFieldDescriptorInFirstNamespace(), mappings, targetNamespace);
        field.setFieldDescriptorInFirstNamespace(newDescriptor);
    }

    private void remapMethodDescriptor(TinyMethod method, Map<String, TinyClass> mappings, int targetNamespace) {
        String descriptor = method.getMethodDescriptorInFirstNamespace();
        String[] paramsAndReturnType = descriptor.split(Pattern.quote(")"));
        if (paramsAndReturnType.length != 2) {
            throw new IllegalArgumentException("method descriptor '" + descriptor + "' is of an unknown format.");
        }
        List<String> params = this.parseParameterDescriptors(paramsAndReturnType[0].substring(1));
        String returnType = paramsAndReturnType[1];
        List paramsMapped = params.stream().map(p -> this.remapType((String)p, mappings, targetNamespace)).collect(Collectors.toList());
        String returnTypeMapped = returnType.equals("V") ? "V" : this.remapType(returnType, mappings, targetNamespace);
        String newDescriptor = "(" + String.join((CharSequence)"", paramsMapped) + ")" + returnTypeMapped;
        method.setMethodDescriptorInFirstNamespace(newDescriptor);
    }

    private List<String> parseParameterDescriptors(String concatenatedParameterDescriptors) {
        ArrayList<String> parameterDescriptors = new ArrayList<String>();
        boolean inClassName = false;
        int inArrayNestingLevel = 0;
        StringBuilder currentClassName = new StringBuilder();
        for (int i = 0; i < concatenatedParameterDescriptors.length(); ++i) {
            char c = concatenatedParameterDescriptors.charAt(i);
            if (inClassName) {
                if (c == ';') {
                    if (currentClassName.length() == 0) {
                        throw new IllegalArgumentException("Empty class name in parameter list " + concatenatedParameterDescriptors + " at position " + i);
                    }
                    parameterDescriptors.add(Strings.repeat((String)"[", (int)inArrayNestingLevel) + "L" + currentClassName.toString() + ";");
                    inArrayNestingLevel = 0;
                    currentClassName = new StringBuilder();
                    inClassName = false;
                    continue;
                }
                currentClassName.append(c);
                continue;
            }
            if (primitiveTypeNames.contains(Character.toString(c))) {
                parameterDescriptors.add(Strings.repeat((String)"[", (int)inArrayNestingLevel) + c);
                inArrayNestingLevel = 0;
                continue;
            }
            if (c == '[') {
                ++inArrayNestingLevel;
                continue;
            }
            if (c == 'L') {
                inClassName = true;
                continue;
            }
            throw new IllegalArgumentException("Unexpected special character " + c + " in parameter descriptor list " + concatenatedParameterDescriptors);
        }
        return parameterDescriptors;
    }

    private String remapType(String type, Map<String, TinyClass> mappings, int targetNamespaceIndex) {
        if (type.isEmpty()) {
            throw new IllegalArgumentException("types cannot be empty strings");
        }
        if (primitiveTypeNames.contains(type)) {
            return type;
        }
        if (type.charAt(0) == '[') {
            return "[" + this.remapType(type.substring(1), mappings, targetNamespaceIndex);
        }
        if (type.charAt(0) == 'L' && type.charAt(type.length() - 1) == ';') {
            String className = type.substring(1, type.length() - 1);
            TinyClass mapping = mappings.get(className);
            String remappedName = mapping != null ? mapping.getClassNames().get(targetNamespaceIndex) : className;
            return "L" + remappedName + ";";
        }
        throw new IllegalArgumentException("type descriptor '" + type + "' is of an unknown format.");
    }
}

