/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands.tinyv2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.stitch.commands.tinyv2.Mapping;
import net.fabricmc.stitch.commands.tinyv2.TinyField;
import net.fabricmc.stitch.commands.tinyv2.TinyMethod;
import net.fabricmc.stitch.util.Pair;

public class TinyClass
implements Comparable<TinyClass>,
Mapping {
    private final List<String> classNames;
    private final Collection<TinyMethod> methods;
    private final Collection<TinyField> fields;
    private final Collection<String> comments;

    public String toString() {
        return "TinyClass(names = [" + String.join((CharSequence)", ", this.classNames) + "], " + this.methods.size() + " methods, " + this.fields.size() + " fields, " + this.comments.size() + " comments)";
    }

    public TinyClass(List<String> classNames, Collection<TinyMethod> methods, Collection<TinyField> fields, Collection<String> comments) {
        this.classNames = classNames;
        this.methods = methods;
        this.fields = fields;
        this.comments = comments;
    }

    public TinyClass(List<String> classNames) {
        this.classNames = classNames;
        this.methods = new ArrayList<TinyMethod>();
        this.fields = new ArrayList<TinyField>();
        this.comments = new ArrayList<String>();
    }

    public Map<Pair<String, String>, TinyMethod> mapMethodsByFirstNamespaceAndDescriptor() {
        return this.methods.stream().collect(Collectors.toMap(m -> Pair.of(m.getMethodNames().get(0), m.getMethodDescriptorInFirstNamespace()), m -> m));
    }

    public Map<String, TinyField> mapFieldsByFirstNamespace() {
        return this.fields.stream().collect(Collectors.toMap(f -> f.getFieldNames().get(0), f -> f));
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public Collection<TinyMethod> getMethods() {
        return this.methods;
    }

    public Collection<TinyField> getFields() {
        return this.fields;
    }

    public Collection<String> getComments() {
        return this.comments;
    }

    @Override
    public int compareTo(TinyClass o) {
        return this.classNames.get(0).compareTo(o.classNames.get(0));
    }

    @Override
    public List<String> getMapping() {
        return this.classNames;
    }
}

