/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands.tinyv2;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.stitch.commands.tinyv2.Mapping;
import net.fabricmc.stitch.commands.tinyv2.TinyLocalVariable;
import net.fabricmc.stitch.commands.tinyv2.TinyMethodParameter;

public class TinyMethod
implements Comparable<TinyMethod>,
Mapping {
    private String methodDescriptorInFirstNamespace;
    private final List<String> methodNames;
    private final Collection<TinyMethodParameter> parameters;
    private final Collection<TinyLocalVariable> localVariables;
    private final Collection<String> comments;

    public String toString() {
        return "TinyMethod(names = [" + String.join((CharSequence)", ", this.methodNames) + "], desc = " + this.methodDescriptorInFirstNamespace + ", " + this.parameters.size() + " params, " + this.localVariables.size() + " vars, " + this.comments.size() + " comments)";
    }

    public TinyMethod(String methodDescriptorInFirstNamespace, List<String> methodNames, Collection<TinyMethodParameter> parameters, Collection<TinyLocalVariable> localVariables, Collection<String> comments) {
        this.methodDescriptorInFirstNamespace = methodDescriptorInFirstNamespace;
        this.methodNames = methodNames;
        this.parameters = parameters;
        this.localVariables = localVariables;
        this.comments = comments;
    }

    public Map<String, TinyMethodParameter> mapParametersByFirstNamespace() {
        return this.parameters.stream().collect(Collectors.toMap(p -> p.getParameterNames().get(0), p -> p));
    }

    public Map<String, TinyLocalVariable> mapLocalVariablesByFirstNamespace() {
        return this.localVariables.stream().collect(Collectors.toMap(lv -> lv.getLocalVariableNames().get(0), lv -> lv));
    }

    public String getMethodDescriptorInFirstNamespace() {
        return this.methodDescriptorInFirstNamespace;
    }

    public List<String> getMethodNames() {
        return this.methodNames;
    }

    public Collection<TinyMethodParameter> getParameters() {
        return this.parameters;
    }

    public Collection<TinyLocalVariable> getLocalVariables() {
        return this.localVariables;
    }

    public Collection<String> getComments() {
        return this.comments;
    }

    @Override
    public int compareTo(TinyMethod o) {
        return (this.methodNames.get(0) + this.methodDescriptorInFirstNamespace).compareTo(o.methodNames.get(0) + o.methodDescriptorInFirstNamespace);
    }

    public void setMethodDescriptorInFirstNamespace(String methodDescriptorInFirstNamespace) {
        this.methodDescriptorInFirstNamespace = methodDescriptorInFirstNamespace;
    }

    @Override
    public List<String> getMapping() {
        return this.methodNames;
    }
}

