/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands.tinyv2;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.mapping.reader.v2.MappingGetter;
import net.fabricmc.mapping.reader.v2.TinyMetadata;
import net.fabricmc.mapping.reader.v2.TinyV2Factory;
import net.fabricmc.mapping.reader.v2.TinyVisitor;
import net.fabricmc.stitch.commands.tinyv2.TinyClass;
import net.fabricmc.stitch.commands.tinyv2.TinyField;
import net.fabricmc.stitch.commands.tinyv2.TinyFile;
import net.fabricmc.stitch.commands.tinyv2.TinyHeader;
import net.fabricmc.stitch.commands.tinyv2.TinyLocalVariable;
import net.fabricmc.stitch.commands.tinyv2.TinyMethod;
import net.fabricmc.stitch.commands.tinyv2.TinyMethodParameter;

public class TinyV2Reader {
    public static TinyFile read(Path readFrom) throws IOException {
        Visitor visitor = new Visitor();
        try (BufferedReader reader = Files.newBufferedReader(readFrom);){
            TinyV2Factory.visit((BufferedReader)reader, (TinyVisitor)visitor);
        }
        return visitor.getAST();
    }

    private static class Visitor
    implements TinyVisitor {
        private TinyHeader header;
        private int namespaceAmount;
        private Set<TinyClass> classes = new HashSet<TinyClass>();
        private TinyClass currentClass;
        private TinyField currentField;
        private TinyMethod currentMethod;
        private TinyMethodParameter currentParameter;
        private TinyLocalVariable currentLocalVariable;
        private CommentType currentCommentType;
        private boolean inComment = false;

        private Visitor() {
        }

        private List<String> getNames(MappingGetter getter) {
            return Lists.newArrayList((Object[])getter.getRawNames());
        }

        public void start(TinyMetadata metadata) {
            this.header = new TinyHeader(new ArrayList<String>(metadata.getNamespaces()), metadata.getMajorVersion(), metadata.getMinorVersion(), metadata.getProperties());
            this.namespaceAmount = this.header.getNamespaces().size();
        }

        public void pushClass(MappingGetter name) {
            this.currentClass = new TinyClass(this.getNames(name), new HashSet<TinyMethod>(), new HashSet<TinyField>(), new ArrayList<String>());
            this.classes.add(this.currentClass);
            this.currentCommentType = CommentType.CLASS;
        }

        public void pushField(MappingGetter name, String descriptor) {
            this.currentField = new TinyField(descriptor, this.getNames(name), new ArrayList<String>());
            this.currentClass.getFields().add(this.currentField);
            this.currentCommentType = CommentType.FIELD;
        }

        public void pushMethod(MappingGetter name, String descriptor) {
            this.currentMethod = new TinyMethod(descriptor, this.getNames(name), new HashSet<TinyMethodParameter>(), new HashSet<TinyLocalVariable>(), new ArrayList<String>());
            this.currentClass.getMethods().add(this.currentMethod);
            this.currentCommentType = CommentType.METHOD;
        }

        public void pushParameter(MappingGetter name, int localVariableIndex) {
            this.currentParameter = new TinyMethodParameter(localVariableIndex, this.getNames(name), new ArrayList<String>());
            this.currentMethod.getParameters().add(this.currentParameter);
            this.currentCommentType = CommentType.PARAMETER;
        }

        public void pushLocalVariable(MappingGetter name, int localVariableIndex, int localVariableStartOffset, int localVariableTableIndex) {
            this.currentLocalVariable = new TinyLocalVariable(localVariableIndex, localVariableStartOffset, localVariableTableIndex, this.getNames(name), new ArrayList<String>());
            this.currentMethod.getLocalVariables().add(this.currentLocalVariable);
            this.currentCommentType = CommentType.LOCAL_VARIABLE;
        }

        public void pushComment(String comment) {
            if (this.inComment) {
                throw new RuntimeException("commenting on comment");
            }
            switch (this.currentCommentType) {
                case CLASS: {
                    this.currentClass.getComments().add(comment);
                    break;
                }
                case FIELD: {
                    this.currentField.getComments().add(comment);
                    break;
                }
                case METHOD: {
                    this.currentMethod.getComments().add(comment);
                    break;
                }
                case PARAMETER: {
                    this.currentParameter.getComments().add(comment);
                    break;
                }
                case LOCAL_VARIABLE: {
                    this.currentLocalVariable.getComments().add(comment);
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected comment without parent");
                }
            }
            this.inComment = true;
        }

        public void pop(int count) {
            block5: for (int i = 0; i < count; ++i) {
                if (this.inComment) {
                    this.inComment = false;
                    continue;
                }
                CommentType last = this.currentCommentType;
                switch (last) {
                    case CLASS: {
                        this.currentCommentType = null;
                        continue block5;
                    }
                    case FIELD: 
                    case METHOD: {
                        this.currentCommentType = CommentType.CLASS;
                        continue block5;
                    }
                    case PARAMETER: 
                    case LOCAL_VARIABLE: {
                        this.currentCommentType = CommentType.METHOD;
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("visit stack is empty!");
                    }
                }
            }
        }

        private TinyFile getAST() {
            return new TinyFile(this.header, this.classes);
        }

        private static enum CommentType {
            CLASS,
            FIELD,
            METHOD,
            PARAMETER,
            LOCAL_VARIABLE;

        }
    }
}

