/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.commands.tinyv2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.stitch.commands.tinyv2.TinyClass;
import net.fabricmc.stitch.commands.tinyv2.TinyField;
import net.fabricmc.stitch.commands.tinyv2.TinyFile;
import net.fabricmc.stitch.commands.tinyv2.TinyHeader;
import net.fabricmc.stitch.commands.tinyv2.TinyLocalVariable;
import net.fabricmc.stitch.commands.tinyv2.TinyMethod;
import net.fabricmc.stitch.commands.tinyv2.TinyMethodParameter;

public class TinyV2Writer {
    private BufferedWriter writer;
    private static final String TO_ESCAPE = "\\\n\r\u0000\t";
    private static final String ESCAPED = "\\nr0t";

    public static void write(TinyFile tinyFile, Path writeTo) throws IOException {
        new TinyV2Writer().instanceWrite(tinyFile, writeTo);
    }

    private TinyV2Writer() {
    }

    private void instanceWrite(TinyFile tinyFile, Path writeTo) throws IOException {
        try {
            this.writer = Files.newBufferedWriter(writeTo, new OpenOption[0]);
            this.writeHeader(tinyFile.getHeader());
            tinyFile.getClassEntries().stream().sorted().forEach(this::writeClass);
        }
        finally {
            this.writer.close();
        }
    }

    private void writeHeader(TinyHeader header) {
        this.writeLine(0, header.getNamespaces(), "tiny", Integer.toString(header.getMajorVersion()), Integer.toString(header.getMinorVersion()));
        header.getProperties().forEach((key, value) -> this.writeLine(1, (String)value));
    }

    private void writeClass(TinyClass tinyClass) {
        this.writeLine(0, tinyClass.getClassNames(), "c");
        for (String comment : tinyClass.getComments()) {
            this.writeComment(1, comment);
        }
        tinyClass.getMethods().stream().sorted().forEach(this::writeMethod);
        tinyClass.getFields().stream().sorted().forEach(this::writeField);
    }

    private void writeMethod(TinyMethod method) {
        this.writeLine(1, method.getMethodNames(), "m", method.getMethodDescriptorInFirstNamespace());
        for (String comment : method.getComments()) {
            this.writeComment(2, comment);
        }
        method.getParameters().stream().sorted().forEach(this::writeMethodParameter);
        method.getLocalVariables().stream().sorted().forEach(this::writeLocalVariable);
    }

    private void writeMethodParameter(TinyMethodParameter parameter) {
        this.writeLine(2, parameter.getParameterNames(), "p", Integer.toString(parameter.getLvIndex()));
        for (String comment : parameter.getComments()) {
            this.writeComment(3, comment);
        }
    }

    private void writeLocalVariable(TinyLocalVariable localVariable) {
        this.writeLine(2, localVariable.getLocalVariableNames(), "v", Integer.toString(localVariable.getLvIndex()), Integer.toString(localVariable.getLvStartOffset()), Integer.toString(localVariable.getLvTableIndex()));
        for (String comment : localVariable.getComments()) {
            this.writeComment(3, comment);
        }
    }

    private void writeField(TinyField field) {
        this.writeLine(1, field.getFieldNames(), "f", field.getFieldDescriptorInFirstNamespace());
        for (String comment : field.getComments()) {
            this.writeComment(2, comment);
        }
    }

    private void writeComment(int indentLevel, String comment) {
        this.writeLine(indentLevel, "c", TinyV2Writer.escapeComment(comment));
    }

    private static String escapeComment(String old) {
        StringBuilder sb = new StringBuilder(old.length());
        for (int i = 0; i < old.length(); ++i) {
            char c = old.charAt(i);
            int t = TO_ESCAPE.indexOf(c);
            if (t == -1) {
                sb.append(c);
                continue;
            }
            sb.append('\\').append(ESCAPED.charAt(t));
        }
        return sb.toString();
    }

    private void write(int indentLevel, String ... tabSeparatedStrings) {
        try {
            for (int i = 0; i < indentLevel; ++i) {
                this.writer.write(9);
            }
            this.writer.write(String.join((CharSequence)"\t", tabSeparatedStrings));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(int indentLevel, List<String> names, String ... tabSeparatedStrings) {
        try {
            this.write(indentLevel, tabSeparatedStrings);
            this.writer.write("\t");
            this.writer.write(String.join((CharSequence)"\t", names));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine() {
        try {
            this.writer.write(10);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(int indentLevel, List<String> names, String ... tabSeparatedStrings) {
        this.write(indentLevel, names, tabSeparatedStrings);
        this.writeLine();
    }

    private void writeLine(int indentLevel, String ... tabSeparatedStrings) {
        this.write(indentLevel, tabSeparatedStrings);
        this.writeLine();
    }

    private static class Indents {
        public static final int HEADER = 0;
        public static final int PROPERTY = 1;
        public static final int CLASS = 0;
        public static final int METHOD = 1;
        public static final int FIELD = 1;
        public static final int PARAMETER = 2;
        public static final int LOCAL_VARIABLE = 2;
        public static final int CLASS_COMMENT = 1;
        public static final int METHOD_COMMENT = 2;
        public static final int FIELD_COMMENT = 2;
        public static final int PARAMETER_COMMENT = 3;
        public static final int LOCAL_VARIABLE_COMMENT = 3;

        private Indents() {
        }
    }

    private static class Prefixes {
        public static final String PARAMETER = "p";
        public static final String METHOD = "m";
        public static final String VARIABLE = "v";
        public static final String HEADER = "tiny";
        public static final String FIELD = "f";
        public static final String COMMENT = "c";
        public static final String CLASS = "c";

        private Prefixes() {
        }
    }
}

