/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.representation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import net.fabricmc.stitch.representation.ClassStorage;
import net.fabricmc.stitch.representation.JarClassEntry;
import net.fabricmc.stitch.util.StitchUtil;

public class ClassPropagationTree {
    private final ClassStorage jar;
    private final Set<JarClassEntry> relevantClasses;
    private final Set<JarClassEntry> topmostClasses;

    public ClassPropagationTree(ClassStorage jar, JarClassEntry baseClass) {
        this.jar = jar;
        this.relevantClasses = StitchUtil.newIdentityHashSet();
        this.topmostClasses = StitchUtil.newIdentityHashSet();
        LinkedList<JarClassEntry> queue = new LinkedList<JarClassEntry>();
        queue.add(baseClass);
        while (!queue.isEmpty()) {
            JarClassEntry entry = (JarClassEntry)queue.remove();
            if (entry == null || this.relevantClasses.contains(entry)) continue;
            this.relevantClasses.add(entry);
            int qSize = queue.size();
            queue.addAll(entry.getSubclasses(jar));
            queue.addAll(entry.getImplementers(jar));
            if (qSize == queue.size()) {
                this.topmostClasses.add(entry);
            }
            queue.addAll(entry.getInterfaces(jar));
            JarClassEntry superClass = entry.getSuperClass(jar);
            if (superClass == null) continue;
            queue.add(superClass);
        }
    }

    public Collection<JarClassEntry> getClasses() {
        return Collections.unmodifiableSet(this.relevantClasses);
    }

    public Collection<JarClassEntry> getTopmostClasses() {
        return Collections.unmodifiableSet(this.topmostClasses);
    }
}

