/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.representation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.stitch.representation.AbstractJarEntry;
import net.fabricmc.stitch.representation.Access;
import net.fabricmc.stitch.representation.ClassStorage;
import net.fabricmc.stitch.representation.JarFieldEntry;
import net.fabricmc.stitch.representation.JarMethodEntry;
import net.fabricmc.stitch.util.Pair;
import org.objectweb.asm.commons.Remapper;

public class JarClassEntry
extends AbstractJarEntry {
    String fullyQualifiedName;
    final Map<String, JarClassEntry> innerClasses;
    final Map<String, JarFieldEntry> fields;
    final Map<String, JarMethodEntry> methods;
    final Map<String, Set<Pair<JarClassEntry, String>>> relatedMethods;
    String signature;
    String superclass;
    List<String> interfaces;
    List<String> subclasses;
    List<String> implementers;

    protected JarClassEntry(String name, String fullyQualifiedName) {
        super(name);
        this.fullyQualifiedName = fullyQualifiedName;
        this.innerClasses = new TreeMap(Comparator.naturalOrder());
        this.fields = new TreeMap(Comparator.naturalOrder());
        this.methods = new TreeMap(Comparator.naturalOrder());
        this.relatedMethods = new HashMap<String, Set<Pair<JarClassEntry, String>>>();
        this.subclasses = new ArrayList<String>();
        this.implementers = new ArrayList<String>();
    }

    protected void populate(int access, String signature, String superclass, String[] interfaces) {
        this.setAccess(access);
        this.signature = signature;
        this.superclass = superclass;
        this.interfaces = Arrays.asList(interfaces);
    }

    protected void populateParents(ClassStorage storage) {
        JarClassEntry superEntry = this.getSuperClass(storage);
        if (superEntry != null) {
            superEntry.subclasses.add(this.fullyQualifiedName);
        }
        for (JarClassEntry itf : this.getInterfaces(storage)) {
            if (itf == null) continue;
            itf.implementers.add(this.fullyQualifiedName);
        }
    }

    public Collection<Pair<JarClassEntry, String>> getRelatedMethods(JarMethodEntry m) {
        return this.relatedMethods.getOrDefault(m.getKey(), Collections.EMPTY_SET);
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSuperClassName() {
        return this.superclass;
    }

    public JarClassEntry getSuperClass(ClassStorage storage) {
        return storage.getClass(this.superclass, false);
    }

    public List<String> getInterfaceNames() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public List<JarClassEntry> getInterfaces(ClassStorage storage) {
        return this.toClassEntryList(storage, this.interfaces);
    }

    public List<String> getSubclassNames() {
        return Collections.unmodifiableList(this.subclasses);
    }

    public List<JarClassEntry> getSubclasses(ClassStorage storage) {
        return this.toClassEntryList(storage, this.subclasses);
    }

    public List<String> getImplementerNames() {
        return Collections.unmodifiableList(this.implementers);
    }

    public List<JarClassEntry> getImplementers(ClassStorage storage) {
        return this.toClassEntryList(storage, this.implementers);
    }

    private List<JarClassEntry> toClassEntryList(ClassStorage storage, List<String> stringList) {
        if (stringList == null) {
            return Collections.emptyList();
        }
        return stringList.stream().map(s -> storage.getClass((String)s, false)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public JarClassEntry getInnerClass(String name) {
        return this.innerClasses.get(name);
    }

    public JarFieldEntry getField(String name) {
        return this.fields.get(name);
    }

    public JarMethodEntry getMethod(String name) {
        return this.methods.get(name);
    }

    public Collection<JarClassEntry> getInnerClasses() {
        return this.innerClasses.values();
    }

    public Collection<JarFieldEntry> getFields() {
        return this.fields.values();
    }

    public Collection<JarMethodEntry> getMethods() {
        return this.methods.values();
    }

    public boolean isInterface() {
        return Access.isInterface(this.getAccess());
    }

    public boolean isAnonymous() {
        return this.getName().matches("[0-9]+");
    }

    @Override
    public String getKey() {
        return this.getFullyQualifiedName();
    }

    public void remap(Remapper remapper) {
        String oldName = this.fullyQualifiedName;
        this.fullyQualifiedName = remapper.map(this.fullyQualifiedName);
        String[] s = this.fullyQualifiedName.split("\\$");
        this.name = s[s.length - 1];
        if (this.superclass != null) {
            this.superclass = remapper.map(this.superclass);
        }
        this.interfaces = this.interfaces.stream().map(arg_0 -> ((Remapper)remapper).map(arg_0)).collect(Collectors.toList());
        this.subclasses = this.subclasses.stream().map(arg_0 -> ((Remapper)remapper).map(arg_0)).collect(Collectors.toList());
        this.implementers = this.implementers.stream().map(arg_0 -> ((Remapper)remapper).map(arg_0)).collect(Collectors.toList());
        HashMap<String, JarClassEntry> innerClassOld = new HashMap<String, JarClassEntry>(this.innerClasses);
        HashMap<String, JarFieldEntry> fieldsOld = new HashMap<String, JarFieldEntry>(this.fields);
        HashMap<String, JarMethodEntry> methodsOld = new HashMap<String, JarMethodEntry>(this.methods);
        HashMap<String, String> methodKeyRemaps = new HashMap<String, String>();
        this.innerClasses.clear();
        this.fields.clear();
        this.methods.clear();
        for (Map.Entry entry : innerClassOld.entrySet()) {
            ((JarClassEntry)entry.getValue()).remap(remapper);
            this.innerClasses.put(((JarClassEntry)entry.getValue()).name, (JarClassEntry)entry.getValue());
        }
        for (Map.Entry entry : fieldsOld.entrySet()) {
            ((JarFieldEntry)entry.getValue()).remap(this, oldName, remapper);
            this.fields.put(((JarFieldEntry)entry.getValue()).getKey(), (JarFieldEntry)entry.getValue());
        }
        for (Map.Entry entry : methodsOld.entrySet()) {
            ((JarMethodEntry)entry.getValue()).remap(this, oldName, remapper);
            this.methods.put(((JarMethodEntry)entry.getValue()).getKey(), (JarMethodEntry)entry.getValue());
            methodKeyRemaps.put((String)entry.getKey(), ((JarMethodEntry)entry.getValue()).getKey());
        }
        HashMap<String, Set<Pair<JarClassEntry, String>>> relatedMethodsOld = new HashMap<String, Set<Pair<JarClassEntry, String>>>(this.relatedMethods);
        this.relatedMethods.clear();
        for (Map.Entry entry : relatedMethodsOld.entrySet()) {
            this.relatedMethods.put(methodKeyRemaps.getOrDefault(entry.getKey(), (String)entry.getKey()), (Set)entry.getValue());
        }
    }
}

