/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.representation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fabricmc.stitch.representation.AbstractJarEntry;
import net.fabricmc.stitch.representation.Access;
import net.fabricmc.stitch.representation.ClassStorage;
import net.fabricmc.stitch.representation.JarClassEntry;
import net.fabricmc.stitch.util.StitchUtil;
import org.objectweb.asm.commons.Remapper;

public class JarMethodEntry
extends AbstractJarEntry {
    protected String desc;
    protected String signature;

    protected JarMethodEntry(int access, String name, String desc, String signature) {
        super(name);
        this.setAccess(access);
        this.desc = desc;
        this.signature = signature;
    }

    public String getDescriptor() {
        return this.desc;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    protected String getKey() {
        return super.getKey() + this.desc;
    }

    public boolean isSource(ClassStorage storage, JarClassEntry c) {
        if (Access.isPrivateOrStatic(this.getAccess())) {
            return true;
        }
        Set<JarClassEntry> entries = StitchUtil.newIdentityHashSet();
        entries.add(c);
        this.getMatchingSources(entries, storage, c);
        return entries.size() == 1;
    }

    public List<JarClassEntry> getMatchingEntries(ClassStorage storage, JarClassEntry c) {
        if (Access.isPrivateOrStatic(this.getAccess())) {
            return Collections.singletonList(c);
        }
        Set<JarClassEntry> entries = StitchUtil.newIdentityHashSet();
        Set<JarClassEntry> entriesNew = StitchUtil.newIdentityHashSet();
        entries.add(c);
        int lastSize = 0;
        while (entries.size() > lastSize) {
            lastSize = entries.size();
            for (JarClassEntry cc2 : entries) {
                this.getMatchingSources(entriesNew, storage, cc2);
            }
            entries.addAll(entriesNew);
            entriesNew.clear();
            for (JarClassEntry cc2 : entries) {
                this.getMatchingEntries(entriesNew, storage, cc2, 0);
            }
            entries.addAll(entriesNew);
            entriesNew.clear();
        }
        entries.removeIf(cc -> cc.getMethod(this.getKey()) == null);
        return new ArrayList<JarClassEntry>(entries);
    }

    void getMatchingSources(Collection<JarClassEntry> entries, ClassStorage storage, JarClassEntry c) {
        JarClassEntry superClass;
        JarMethodEntry m = c.getMethod(this.getKey());
        if (m != null && !Access.isPrivateOrStatic(m.getAccess())) {
            entries.add(c);
        }
        if ((superClass = c.getSuperClass(storage)) != null) {
            this.getMatchingSources(entries, storage, superClass);
        }
        for (JarClassEntry itf : c.getInterfaces(storage)) {
            this.getMatchingSources(entries, storage, itf);
        }
    }

    void getMatchingEntries(Collection<JarClassEntry> entries, ClassStorage storage, JarClassEntry c, int indent) {
        entries.add(c);
        for (JarClassEntry cc : c.getSubclasses(storage)) {
            this.getMatchingEntries(entries, storage, cc, indent + 1);
        }
        for (JarClassEntry cc : c.getImplementers(storage)) {
            this.getMatchingEntries(entries, storage, cc, indent + 1);
        }
    }

    public void remap(JarClassEntry classEntry, String oldOwner, Remapper remapper) {
        String pastDesc = this.desc;
        this.name = remapper.mapMethodName(oldOwner, this.name, pastDesc);
        this.desc = remapper.mapMethodDesc(pastDesc);
    }
}

