/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.representation;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.fabricmc.stitch.representation.ClassPropagationTree;
import net.fabricmc.stitch.representation.JarClassEntry;
import net.fabricmc.stitch.representation.JarFieldEntry;
import net.fabricmc.stitch.representation.JarMethodEntry;
import net.fabricmc.stitch.representation.JarRootEntry;
import net.fabricmc.stitch.util.StitchUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;

public class JarReader {
    private final JarRootEntry jar;
    private boolean joinMethodEntries = true;
    private Remapper remapper;

    public JarReader(JarRootEntry jar) {
        this.jar = jar;
    }

    public void apply() throws IOException {
        try (FileInputStream fileStream = new FileInputStream(this.jar.file);
             JarInputStream jarStream = new JarInputStream(fileStream);){
            JarEntry jarEntry;
            while ((jarEntry = jarStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                ClassReader reader = new ClassReader((InputStream)jarStream);
                VisitorClass visitor = new VisitorClass(StitchUtil.ASM_VERSION, null);
                reader.accept((ClassVisitor)visitor, 7);
            }
        }
        System.err.println("Read " + this.jar.getAllClasses().size() + " (" + this.jar.getClasses().size() + ") classes.");
        this.jar.getAllClasses().forEach(c -> c.populateParents(this.jar));
        System.err.println("Populated subclass entries.");
        if (this.joinMethodEntries) {
            System.err.println("Joining MethodEntries...");
            Set traversedClasses = StitchUtil.newIdentityHashSet();
            int joinedMethods = 1;
            int n = 0;
            Set checkedMethods = StitchUtil.newIdentityHashSet();
            for (JarClassEntry entry : this.jar.getAllClasses()) {
                if (traversedClasses.contains(entry)) continue;
                ClassPropagationTree tree = new ClassPropagationTree(this.jar, entry);
                if (tree.getClasses().size() == 1) {
                    traversedClasses.add(entry);
                    continue;
                }
                for (JarClassEntry c2 : tree.getClasses()) {
                    for (JarMethodEntry m : c2.getMethods()) {
                        List<JarClassEntry> mList;
                        if (!checkedMethods.add(m) || (mList = m.getMatchingEntries(this.jar, c2)).size() <= 1) continue;
                        for (int i = 0; i < mList.size(); ++i) {
                            JarClassEntry key = mList.get(i);
                            JarMethodEntry value = key.getMethod(m.getKey());
                            if (value == m) continue;
                            key.methods.put(m.getKey(), m);
                            ++joinedMethods;
                        }
                    }
                }
                traversedClasses.addAll(tree.getClasses());
            }
            System.err.println("Joined " + joinedMethods + " MethodEntries (" + n + " unique, " + traversedClasses.size() + " classes).");
        }
        System.err.println("Collecting additional information...");
        if (this.remapper != null) {
            System.err.println("Remapping...");
            HashMap<String, JarClassEntry> classTree = new HashMap<String, JarClassEntry>(this.jar.classTree);
            this.jar.classTree.clear();
            for (Map.Entry entry : classTree.entrySet()) {
                ((JarClassEntry)entry.getValue()).remap(this.remapper);
                this.jar.classTree.put(((JarClassEntry)entry.getValue()).getKey(), (JarClassEntry)entry.getValue());
            }
        }
        System.err.println("- Done. -");
    }

    private class VisitorClass
    extends ClassVisitor {
        private JarClassEntry entry;

        public VisitorClass(int api, ClassVisitor classVisitor) {
            super(api, classVisitor);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.entry = JarReader.this.jar.getClass(name, true);
            this.entry.populate(access, signature, superName, interfaces);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            JarFieldEntry field = new JarFieldEntry(access, name, descriptor, signature);
            this.entry.fields.put(field.getKey(), field);
            return new VisitorField(this.api, super.visitField(access, name, descriptor, signature, value), this.entry, field);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            JarMethodEntry method = new JarMethodEntry(access, name, descriptor, signature);
            this.entry.methods.put(method.getKey(), method);
            return new VisitorMethod(this.api, super.visitMethod(access, name, descriptor, signature, exceptions), this.entry, method);
        }
    }

    private class VisitorMethod
    extends MethodVisitor {
        final JarClassEntry classEntry;
        final JarMethodEntry entry;

        public VisitorMethod(int api, MethodVisitor methodVisitor, JarClassEntry classEntry, JarMethodEntry entry) {
            super(api, methodVisitor);
            this.classEntry = classEntry;
            this.entry = entry;
        }
    }

    private class VisitorBridge
    extends VisitorMethod {
        private final boolean hasBridgeFlag;
        private final List<MethodRef> methodRefs;

        public VisitorBridge(int api, int access, MethodVisitor methodVisitor, JarClassEntry classEntry, JarMethodEntry entry) {
            super(api, methodVisitor, classEntry, entry);
            this.methodRefs = new ArrayList<MethodRef>();
            this.hasBridgeFlag = (access & 0x40) != 0;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            this.methodRefs.add(new MethodRef(owner, name, descriptor));
        }

        public void visitEnd() {
        }
    }

    private static class MethodRef {
        final String owner;
        final String name;
        final String descriptor;

        MethodRef(String owner, String name, String descriptor) {
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
        }
    }

    private class VisitorField
    extends FieldVisitor {
        private final JarClassEntry classEntry;
        private final JarFieldEntry entry;

        public VisitorField(int api, FieldVisitor fieldVisitor, JarClassEntry classEntry, JarFieldEntry entry) {
            super(api, fieldVisitor);
            this.classEntry = classEntry;
            this.entry = entry;
        }
    }

    private class VisitorClassStageTwo
    extends ClassVisitor {
        private JarClassEntry entry;

        public VisitorClassStageTwo(int api, ClassVisitor classVisitor) {
            super(api, classVisitor);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.entry = JarReader.this.jar.getClass(name, true);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            JarMethodEntry method = new JarMethodEntry(access, name, descriptor, signature);
            this.entry.methods.put(method.getKey(), method);
            if ((access & 0x1040) != 0) {
                return new VisitorBridge(this.api, access, super.visitMethod(access, name, descriptor, signature, exceptions), this.entry, method);
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }

    public static class Builder {
        private final JarReader reader;

        private Builder(JarReader reader) {
            this.reader = reader;
        }

        public static Builder create(JarRootEntry jar) {
            return new Builder(new JarReader(jar));
        }

        public Builder joinMethodEntries(boolean value) {
            this.reader.joinMethodEntries = value;
            return this;
        }

        public Builder withRemapper(Remapper remapper) {
            this.reader.remapper = remapper;
            return this;
        }

        public JarReader build() {
            return this.reader;
        }
    }
}

