/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.representation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.stitch.representation.AbstractJarEntry;
import net.fabricmc.stitch.representation.ClassStorage;
import net.fabricmc.stitch.representation.JarClassEntry;

public class JarRootEntry
extends AbstractJarEntry
implements ClassStorage {
    final Object syncObject = new Object();
    final File file;
    final Map<String, JarClassEntry> classTree;
    final List<JarClassEntry> allClasses;

    public JarRootEntry(File file) {
        super(file.getName());
        this.file = file;
        this.classTree = new TreeMap(Comparator.naturalOrder());
        this.allClasses = new ArrayList<JarClassEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JarClassEntry getClass(String name, boolean create) {
        JarClassEntry entry;
        if (name == null) {
            return null;
        }
        String[] nameSplit = name.split("\\$");
        int i = 0;
        if ((entry = this.classTree.get(nameSplit[i++])) == null && create) {
            entry = new JarClassEntry(nameSplit[0], nameSplit[0]);
            Object object = this.syncObject;
            synchronized (object) {
                this.allClasses.add(entry);
                this.classTree.put(entry.getName(), entry);
            }
        }
        StringBuilder fullyQualifiedBuilder = new StringBuilder(nameSplit[0]);
        while (i < nameSplit.length && entry != null) {
            fullyQualifiedBuilder.append('$');
            fullyQualifiedBuilder.append(nameSplit[i]);
            JarClassEntry parent = entry;
            if ((entry = entry.getInnerClass(nameSplit[i++])) != null || !create) continue;
            entry = new JarClassEntry(nameSplit[i - 1], fullyQualifiedBuilder.toString());
            Object object = this.syncObject;
            synchronized (object) {
                this.allClasses.add(entry);
                parent.innerClasses.put(entry.getName(), entry);
            }
        }
        return entry;
    }

    public Collection<JarClassEntry> getClasses() {
        return this.classTree.values();
    }

    public Collection<JarClassEntry> getAllClasses() {
        return Collections.unmodifiableList(this.allClasses);
    }
}

