/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.fabricmc.mappings.EntryTriple;
import net.fabricmc.stitch.util.NameFinderVisitor;
import net.fabricmc.stitch.util.StitchUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class FieldNameFinder {
    public Map<EntryTriple, String> findNames(Iterable<byte[]> classes) throws Exception {
        HashMap<String, List<MethodNode>> methods = new HashMap<String, List<MethodNode>>();
        HashMap<String, Set<String>> enumFields = new HashMap<String, Set<String>>();
        for (byte[] data : classes) {
            ClassReader reader = new ClassReader(data);
            NameFinderVisitor vClass = new NameFinderVisitor(StitchUtil.ASM_VERSION, enumFields, methods);
            reader.accept((ClassVisitor)vClass, 4);
        }
        return this.findNames(enumFields, methods);
    }

    public Map<EntryTriple, String> findNames(Map<String, Set<String>> allEnumFields, Map<String, List<MethodNode>> classes) throws Exception {
        Analyzer analyzer = new Analyzer((Interpreter)new SourceInterpreter());
        HashMap<EntryTriple, String> fieldNames = new HashMap<EntryTriple, String>();
        HashMap<String, Set> fieldNamesUsed = new HashMap<String, Set>();
        HashMap<String, Set> fieldNamesDuplicate = new HashMap<String, Set>();
        for (Map.Entry<String, List<MethodNode>> entry : classes.entrySet()) {
            String owner = entry.getKey();
            Set enumFields = allEnumFields.getOrDefault(owner, Collections.emptySet());
            for (MethodNode mn : entry.getValue()) {
                Frame[] frames = analyzer.analyze(owner, mn);
                InsnList instrs = mn.instructions;
                for (int i = 1; i < instrs.size(); ++i) {
                    AbstractInsnNode instr1 = instrs.get(i - 1);
                    AbstractInsnNode instr2 = instrs.get(i);
                    String s = null;
                    if (instr2.getOpcode() == 179 && ((FieldInsnNode)instr2).owner.equals(owner) && (instr1 instanceof MethodInsnNode && ((MethodInsnNode)instr1).owner.equals(owner) || enumFields.contains(((FieldInsnNode)instr2).desc + ((FieldInsnNode)instr2).name)) && (instr1.getOpcode() == 184 || instr1.getOpcode() == 183 && "<init>".equals(((MethodInsnNode)instr1).name))) {
                        for (int j = 0; j < frames[i - 1].getStackSize(); ++j) {
                            SourceValue sv = (SourceValue)frames[i - 1].getStack(j);
                            for (AbstractInsnNode ci : sv.insns) {
                                if (!(ci instanceof LdcInsnNode) || !(((LdcInsnNode)ci).cst instanceof String) || s != null) continue;
                                s = (String)((LdcInsnNode)ci).cst;
                            }
                        }
                    }
                    if (s == null) continue;
                    if (s.contains(":")) {
                        s = s.substring(s.indexOf(58) + 1);
                    }
                    if (s.contains("/")) {
                        int separator = s.indexOf(47);
                        String sFirst = s.substring(0, separator);
                        String sLast = s.contains(".") && s.indexOf(46) > separator ? s.substring(separator + 1, s.indexOf(46)) : s.substring(separator + 1);
                        if (sFirst.endsWith("s")) {
                            sFirst = sFirst.substring(0, sFirst.length() - 1);
                        }
                        s = sLast + "_" + sFirst;
                    }
                    String oldS = s;
                    boolean hasAlpha = false;
                    for (int j = 0; j < s.length(); ++j) {
                        char c = s.charAt(j);
                        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                            hasAlpha = true;
                        }
                        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_')) {
                            s = s.substring(0, j) + "_" + s.substring(j + 1);
                            continue;
                        }
                        if (j <= 0 || !Character.isUpperCase(s.charAt(j)) || !Character.isLowerCase(s.charAt(j - 1))) continue;
                        s = s.substring(0, j) + "_" + s.substring(j, j + 1).toLowerCase(Locale.ROOT) + s.substring(j + 1);
                    }
                    if (!hasAlpha) continue;
                    s = s.toUpperCase(Locale.ROOT);
                    Set usedNames = fieldNamesUsed.computeIfAbsent(((FieldInsnNode)instr2).owner, a -> new HashSet());
                    Set usedNamesDuplicate = fieldNamesDuplicate.computeIfAbsent(((FieldInsnNode)instr2).owner, a -> new HashSet());
                    if (!usedNamesDuplicate.contains(s) && !usedNames.add(s)) {
                        System.err.println("Warning: Duplicate key: " + s + " (" + oldS + ")!");
                        usedNamesDuplicate.add(s);
                        usedNames.remove(s);
                    }
                    if (!usedNames.contains(s)) continue;
                    fieldNames.put(new EntryTriple(((FieldInsnNode)instr2).owner, ((FieldInsnNode)instr2).name, ((FieldInsnNode)instr2).desc), s);
                }
            }
        }
        return fieldNames;
    }

    public Map<EntryTriple, String> findNames(File file) {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        try {
            try (FileInputStream fis = new FileInputStream(file);
                 JarInputStream jis = new JarInputStream(fis);){
                JarEntry entry;
                byte[] buffer = new byte[32768];
                while ((entry = jis.getNextJarEntry()) != null) {
                    int l;
                    if (!entry.getName().endsWith(".class")) continue;
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    while ((l = jis.read(buffer, 0, buffer.length)) > 0) {
                        stream.write(buffer, 0, l);
                    }
                    byteArrays.add(stream.toByteArray());
                }
            }
            return this.findNames(byteArrays);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

