/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.function.BiConsumer;
import net.fabricmc.mappings.EntryTriple;

public final class MatcherUtil {
    private MatcherUtil() {
    }

    public static void read(BufferedReader reader, boolean invert, BiConsumer<String, String> classMappingConsumer, BiConsumer<EntryTriple, EntryTriple> fieldMappingConsumer, BiConsumer<EntryTriple, EntryTriple> methodMappingConsumer) throws IOException {
        String line;
        String ownerFrom = null;
        String ownerTo = null;
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\t");
            if (parts[0].equals("c") && parts.length == 3) {
                ownerFrom = parts[1].substring(1, parts[1].length() - 1);
                ownerTo = parts[2].substring(1, parts[2].length() - 1);
                if (invert) {
                    classMappingConsumer.accept(ownerTo, ownerFrom);
                    continue;
                }
                classMappingConsumer.accept(ownerFrom, ownerTo);
                continue;
            }
            if (!parts[0].equals("") || ownerFrom == null || parts.length < 2) continue;
            if (parts[1].equals("f") && parts.length == 4) {
                String[] fieldFrom = parts[2].split(";;");
                String[] fieldTo = parts[3].split(";;");
                if (invert) {
                    fieldMappingConsumer.accept(new EntryTriple(ownerTo, fieldTo[0], fieldTo[1]), new EntryTriple(ownerFrom, fieldFrom[0], fieldFrom[1]));
                    continue;
                }
                fieldMappingConsumer.accept(new EntryTriple(ownerFrom, fieldFrom[0], fieldFrom[1]), new EntryTriple(ownerTo, fieldTo[0], fieldTo[1]));
                continue;
            }
            if (!parts[1].equals("m") || parts.length != 4) continue;
            String[] methodFrom = MatcherUtil.toMethodArray(parts[2]);
            String[] methodTo = MatcherUtil.toMethodArray(parts[3]);
            if (invert) {
                methodMappingConsumer.accept(new EntryTriple(ownerTo, methodTo[0], methodTo[1]), new EntryTriple(ownerFrom, methodFrom[0], methodFrom[1]));
                continue;
            }
            methodMappingConsumer.accept(new EntryTriple(ownerFrom, methodFrom[0], methodFrom[1]), new EntryTriple(ownerTo, methodTo[0], methodTo[1]));
        }
    }

    private static String[] toMethodArray(String part) {
        int parenPos = part.indexOf(40);
        return new String[]{part.substring(0, parenPos), part.substring(parenPos)};
    }
}

