/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

public class NameFinderVisitor
extends ClassVisitor {
    private String owner;
    private final Map<String, Set<String>> allEnumFields;
    private final Map<String, List<MethodNode>> allMethods;

    public NameFinderVisitor(int api, Map<String, Set<String>> allEnumFields, Map<String, List<MethodNode>> allMethods) {
        super(api);
        this.allMethods = allMethods;
        this.allEnumFields = allEnumFields;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.owner = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if ((access & 0x4000) != 0 && !this.allEnumFields.computeIfAbsent(this.owner, s -> new HashSet()).add(descriptor + name)) {
            throw new IllegalArgumentException("Found two enum fields with the same name \"" + name + "\"!");
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ("<clinit>".equals(name)) {
            MethodNode node = new MethodNode(this.api, access, name, descriptor, signature, exceptions);
            this.allMethods.computeIfAbsent(this.owner, s -> new ArrayList()).add(node);
            return node;
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }
}

