/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.util;

import java.util.Objects;

public final class Pair<K, V> {
    private final K left;
    private final V right;

    private Pair(K left, V right) {
        this.left = left;
        this.right = right;
    }

    public static <K, V> Pair<K, V> of(K left, V right) {
        return new Pair<K, V>(left, right);
    }

    public K getLeft() {
        return this.left;
    }

    public V getRight() {
        return this.right;
    }

    protected Object clone() throws CloneNotSupportedException {
        return new Pair<K, V>(this.left, this.right);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return Objects.equals(other.left, this.left) && Objects.equals(other.right, this.right);
    }

    public int hashCode() {
        if (this.left == null && this.right == null) {
            return 0;
        }
        if (this.left == null) {
            return this.right.hashCode();
        }
        if (this.right == null) {
            return this.left.hashCode();
        }
        return this.left.hashCode() * 19 + this.right.hashCode();
    }

    public String toString() {
        return "Pair(" + this.left + "," + this.right + ")";
    }
}

