/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.stitch.util.StitchUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.RecordComponentNode;

public class RecordValidator
implements AutoCloseable {
    private static final String[] REQUIRED_METHOD_SIGNATURES = new String[]{"toString()Ljava/lang/String;", "hashCode()I", "equals(Ljava/lang/Object;)Z"};
    private final StitchUtil.FileSystemDelegate inputFs;
    private final Path inputJar;
    private final boolean printInfo;
    private final List<String> errors = new LinkedList<String>();

    public RecordValidator(File jarFile, boolean printInfo) throws IOException {
        this.inputFs = StitchUtil.getJarFileSystem(jarFile, false);
        this.inputJar = this.inputFs.get().getPath("/", new String[0]);
        this.printInfo = printInfo;
    }

    public void validate() throws IOException, RecordValidationException {
        Files.walkFileTree(this.inputJar, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs.isDirectory()) {
                    return FileVisitResult.CONTINUE;
                }
                if (file.getFileName().toString().endsWith(".class")) {
                    byte[] classBytes = Files.readAllBytes(file);
                    RecordValidator.this.validateClass(classBytes);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (!this.errors.isEmpty()) {
            throw new RecordValidationException(this.errors);
        }
    }

    private boolean validateClass(byte[] classBytes) {
        ClassNode classNode = new ClassNode(StitchUtil.ASM_VERSION);
        ClassReader classReader = new ClassReader(classBytes);
        classReader.accept((ClassVisitor)classNode, 0);
        if ((classNode.access & 0x10000) == 0) {
            return false;
        }
        for (RecordComponentNode component : classNode.recordComponents) {
            boolean foundMethod = false;
            for (Object method : classNode.methods) {
                if (!((MethodNode)method).name.equals(component.name) || !((MethodNode)method).desc.equals("()" + component.descriptor)) continue;
                foundMethod = true;
                break;
            }
            boolean foundField = false;
            for (FieldNode field : classNode.fields) {
                if (!field.name.equals(component.name) || !field.desc.equals(component.descriptor)) continue;
                foundField = true;
                break;
            }
            if (!foundMethod) {
                this.errors.add(String.format("Could not find matching getter method for %s()%s in %s", component.name, component.descriptor, classNode.name));
            }
            if (foundField) continue;
            this.errors.add(String.format("Could not find matching field for %s;%s in %s", component.name, component.descriptor, classNode.name));
        }
        for (String requiredMethodSignature : REQUIRED_METHOD_SIGNATURES) {
            boolean foundMethod = false;
            for (MethodNode method : classNode.methods) {
                if (!(method.name + method.desc).equals(requiredMethodSignature)) continue;
                foundMethod = true;
                break;
            }
            if (foundMethod) continue;
            this.errors.add(String.format("Could not find required method %s in %s", requiredMethodSignature, classNode.name));
        }
        if (this.printInfo) {
            this.printInfo(classNode);
        }
        return true;
    }

    private void printInfo(ClassNode classNode) {
        StringBuilder sb = new StringBuilder();
        sb.append("Found record ").append(classNode.name).append(" with components:\n");
        for (RecordComponentNode componentNode : classNode.recordComponents) {
            sb.append('\t').append(componentNode.name).append("\t").append(componentNode.descriptor).append('\n');
        }
        String toString = this.extractToString(classNode);
        if (toString != null) {
            sb.append("toString: ").append(toString).append('\n');
        }
        System.out.print(sb.append('\n').toString());
    }

    private String extractToString(ClassNode classNode) {
        MethodNode methodNode = null;
        for (MethodNode method : classNode.methods) {
            if (!(method.name + method.desc).equals("toString()Ljava/lang/String;")) continue;
            methodNode = method;
            break;
        }
        if (methodNode == null) {
            return null;
        }
        for (AbstractInsnNode insnNode : methodNode.instructions) {
            if (!(insnNode instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode invokeDynamic = (InvokeDynamicInsnNode)insnNode;
            if (!invokeDynamic.name.equals("toString") || !invokeDynamic.desc.equals(String.format("(L%s;)Ljava/lang/String;", classNode.name)) || !invokeDynamic.bsm.getName().equals("bootstrap") || !invokeDynamic.bsm.getOwner().equals("java/lang/runtime/ObjectMethods")) continue;
            for (Object bsmArg : invokeDynamic.bsmArgs) {
                if (!(bsmArg instanceof String)) continue;
                return (String)bsmArg;
            }
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        this.inputFs.close();
    }

    public static class RecordValidationException
    extends Exception {
        public final List<String> errors;

        public RecordValidationException(List<String> errors) {
            this.errors = errors;
        }
    }
}

