/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.stitch.util;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class SyntheticParameterClassVisitor
extends ClassVisitor {
    private String className;
    private int synthetic;
    private String syntheticArgs;
    private boolean backoff = false;

    public SyntheticParameterClassVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        if ((access & 0x4000) != 0) {
            this.synthetic = 2;
            this.syntheticArgs = "(Ljava/lang/String;I";
        }
        if (version >= 55) {
            this.backoff = true;
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (this.synthetic == 0 && name.equals(this.className) && innerName != null && outerName != null && (access & 8) == 0) {
            this.synthetic = 1;
            this.syntheticArgs = "(L" + outerName + ";";
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return mv != null && this.synthetic != 0 && name.equals("<init>") && descriptor.startsWith(this.syntheticArgs) && !this.backoff ? new SyntheticMethodVisitor(this.api, this.synthetic, mv) : mv;
    }

    private class SyntheticMethodVisitor
    extends MethodVisitor {
        private final int offset;

        SyntheticMethodVisitor(int api, int offset, MethodVisitor methodVisitor) {
            super(api, methodVisitor);
            this.offset = offset;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            return super.visitParameterAnnotation(parameter - this.offset, descriptor, visible);
        }

        public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
            super.visitAnnotableParameterCount(parameterCount - this.offset, visible);
        }
    }
}

