/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.constantmappers.datadriven.parser.v2;

import daomephsta.unpick.constantmappers.datadriven.parser.v2.UnpickV2Reader;

public class UnpickV2Writer
implements UnpickV2Reader.Visitor {
    private final StringBuilder writeBuffer = new StringBuilder();

    @Override
    public void startVisit() {
        if (this.writeBuffer.length() != 0) {
            return;
        }
        this.writeBuffer.append("v2").append(System.lineSeparator());
    }

    @Override
    public void visitFlagConstantDefinition(String group, String owner, String name, String value, String descriptor) {
        UnpickV2Writer.appendJoining(this.writeBuffer, " ", "flag", group, owner, name);
        if (value != null && descriptor != null) {
            UnpickV2Writer.appendJoining(this.writeBuffer.append(' '), " ", value, descriptor);
        } else if (value != null || descriptor != null) {
            throw new IllegalArgumentException("value and descriptor must both have a value or both be null");
        }
        this.writeBuffer.append(System.lineSeparator());
    }

    @Override
    public void visitSimpleConstantDefinition(String group, String owner, String name, String value, String descriptor) {
        UnpickV2Writer.appendJoining(this.writeBuffer, " ", "constant", group, owner, name);
        if (value != null && descriptor != null) {
            UnpickV2Writer.appendJoining(this.writeBuffer.append(' '), " ", value, descriptor);
        } else if (value != null || descriptor != null) {
            throw new IllegalArgumentException("value and descriptor must both have a value or both be null");
        }
        this.writeBuffer.append(System.lineSeparator());
    }

    @Override
    public UnpickV2Reader.TargetMethodDefinitionVisitor visitTargetMethodDefinition(String owner, String name, String descriptor) {
        UnpickV2Writer.appendJoining(this.writeBuffer, " ", "target_method", owner, name, descriptor).append(System.lineSeparator());
        return new TargetMethodWriter(this.writeBuffer);
    }

    public String getOutput() {
        return this.writeBuffer.toString();
    }

    private static StringBuilder appendJoining(StringBuilder thisArg, CharSequence delimiter, String ... elements) {
        thisArg.append(elements[0]);
        for (int e = 1; e < elements.length; ++e) {
            thisArg.append(delimiter).append(elements[e]);
        }
        return thisArg;
    }

    private static class TargetMethodWriter
    implements UnpickV2Reader.TargetMethodDefinitionVisitor {
        private final StringBuilder writeBuffer;

        TargetMethodWriter(StringBuilder writeBuffer) {
            this.writeBuffer = writeBuffer;
        }

        @Override
        public void visitParameterGroupDefinition(int parameterIndex, String group) {
            this.writeBuffer.append("\t");
            UnpickV2Writer.appendJoining(this.writeBuffer, " ", "param", Integer.toString(parameterIndex), group);
            this.writeBuffer.append(System.lineSeparator());
        }

        @Override
        public void visitReturnGroupDefinition(String group) {
            this.writeBuffer.append("\t");
            UnpickV2Writer.appendJoining(this.writeBuffer, " ", "return", group);
            this.writeBuffer.append(System.lineSeparator());
        }
    }
}

