/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.Buildable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;

public interface ComponentBuilder<C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>>
extends Buildable.Builder<C>,
ComponentBuilderApplicable,
ComponentLike {
    @Contract(value="_ -> this")
    public @NonNull B append(@NonNull Component var1);

    @Contract(value="_ -> this")
    default public @NonNull B append(@NonNull ComponentLike component) {
        return this.append(component.asComponent());
    }

    @Contract(value="_ -> this")
    default public @NonNull B append(@NonNull ComponentBuilder<?, ?> builder) {
        return this.append((Component)builder.build());
    }

    @Contract(value="_ -> this")
    public @NonNull B append(Component ... var1);

    @Contract(value="_ -> this")
    public @NonNull B append(ComponentLike ... var1);

    @Contract(value="_ -> this")
    public @NonNull B append(@NonNull Iterable<? extends ComponentLike> var1);

    @Contract(value="_ -> this")
    default public @NonNull B apply(@NonNull Consumer<? super ComponentBuilder<?, ?>> consumer) {
        consumer.accept(this);
        return (B)this;
    }

    @Contract(value="_ -> this")
    public @NonNull B applyDeep(@NonNull Consumer<? super ComponentBuilder<?, ?>> var1);

    @Contract(value="_ -> this")
    public @NonNull B mapChildren(@NonNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> var1);

    @Contract(value="_ -> this")
    public @NonNull B mapChildrenDeep(@NonNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> var1);

    @Contract(value="_ -> this")
    public @NonNull B style(@NonNull Style var1);

    @Contract(value="_ -> this")
    public @NonNull B style(@NonNull Consumer<Style.Builder> var1);

    @Contract(value="_ -> this")
    public @NonNull B font(@Nullable Key var1);

    @Contract(value="_ -> this")
    public @NonNull B color(@Nullable TextColor var1);

    @Contract(value="_ -> this")
    public @NonNull B colorIfAbsent(@Nullable TextColor var1);

    @Contract(value="_ -> this")
    default public @NonNull B decorations(@NonNull Set<TextDecoration> decorations, boolean flag) {
        TextDecoration.State state = TextDecoration.State.byBoolean(flag);
        decorations.forEach(decoration -> this.decoration((TextDecoration)decoration, state));
        return (B)this;
    }

    @Contract(value="_ -> this")
    default public @NonNull B decorate(@NonNull TextDecoration decoration) {
        return this.decoration(decoration, TextDecoration.State.TRUE);
    }

    @Contract(value="_ -> this")
    default public @NonNull B decorate(TextDecoration ... decorations) {
        int length = decorations.length;
        for (int i = 0; i < length; ++i) {
            this.decorate(decorations[i]);
        }
        return (B)this;
    }

    @Contract(value="_, _ -> this")
    default public @NonNull B decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    @Contract(value="_, _ -> this")
    public @NonNull B decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

    @Contract(value="_ -> this")
    public @NonNull B clickEvent(@Nullable ClickEvent var1);

    @Contract(value="_ -> this")
    public @NonNull B hoverEvent(@Nullable HoverEventSource<?> var1);

    @Contract(value="_ -> this")
    public @NonNull B insertion(@Nullable String var1);

    @Contract(value="_ -> this")
    default public @NonNull B mergeStyle(@NonNull Component that) {
        return this.mergeStyle(that, Style.Merge.all());
    }

    @Contract(value="_, _ -> this")
    default public @NonNull B mergeStyle(@NonNull Component that, Style.Merge ... merges) {
        return this.mergeStyle(that, Style.Merge.of(merges));
    }

    @Contract(value="_, _ -> this")
    public @NonNull B mergeStyle(@NonNull Component var1, @NonNull Set<Style.Merge> var2);

    @Contract(value="-> this")
    public @NonNull B resetStyle();

    @Override
    public @NonNull C build();

    @Contract(value="_ -> this")
    default public @NonNull B applicableApply(@NonNull ComponentBuilderApplicable applicable) {
        applicable.componentBuilderApply(this);
        return (B)this;
    }

    @Override
    default public void componentBuilderApply(@NonNull ComponentBuilder<?, ?> component) {
        component.append(this);
    }

    @Override
    default public @NonNull Component asComponent() {
        return this.build();
    }
}

