/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.serializer.configurate4.ComponentTypeSerializer;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class BookTypeSerializer
implements TypeSerializer<Book> {
    static final BookTypeSerializer INSTANCE = new BookTypeSerializer();
    static final String TITLE = "title";
    static final String AUTHOR = "author";
    static final String PAGES = "pages";

    private BookTypeSerializer() {
    }

    public Book deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        Component title = (Component)value.node(new Object[]{TITLE}).get(Component.class);
        Component author = (Component)value.node(new Object[]{AUTHOR}).get(Component.class);
        List pages = (List)value.node(new Object[]{PAGES}).get(ComponentTypeSerializer.LIST_TYPE);
        if (title == null || author == null || pages == null) {
            throw new SerializationException("title, author, and pages fields are all required to deserialize a Book");
        }
        return Book.book((Component)title, (Component)author, (Collection)pages);
    }

    public void serialize(@NonNull Type type, @Nullable Book obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(new Object[]{TITLE}).set(Component.class, (Object)obj.title());
        value.node(new Object[]{AUTHOR}).set(Component.class, (Object)obj.author());
        value.node(new Object[]{PAGES}).set(ComponentTypeSerializer.LIST_TYPE, (Object)obj.pages());
    }
}

