/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import net.kyori.adventure.serializer.configurate4.KeySerializer;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class ComponentTypeSerializer
implements TypeSerializer<Component> {
    static final TypeToken<List<Component>> LIST_TYPE = new TypeToken<List<Component>>(){};
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";
    static final String NBT_STORAGE = "storage";
    private final @Nullable ComponentSerializer<Component, ? extends Component, String> stringSerial;
    private final boolean preferString;

    ComponentTypeSerializer(@Nullable ComponentSerializer<Component, ? extends Component, String> stringSerial, boolean preferString) {
        this.stringSerial = stringSerial;
        this.preferString = preferString;
    }

    public @NonNull Component deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        return this.deserialize0(type, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @NonNull BuildableComponent<?, ?> deserialize0(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        Style style;
        TextComponent.Builder component;
        Map children;
        if (!value.isList() && !value.isMap()) {
            String str = value.getString();
            if (str != null) {
                if (this.stringSerial == null) return Component.text((String)str);
                Component ret = this.stringSerial.deserialize((Object)str);
                if (ret instanceof BuildableComponent) return (BuildableComponent)ret;
                throw new SerializationException("Result " + ret + " is not builable");
            }
        } else {
            if (value.isList()) {
                ComponentBuilder parent = null;
                for (ConfigurationNode childElement : value.childrenList()) {
                    BuildableComponent<?, ?> child = this.deserialize0((Type)((Object)Component.class), childElement);
                    if (parent == null) {
                        parent = child.toBuilder();
                        continue;
                    }
                    parent.append(child);
                }
                if (parent != null) return parent.build();
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
            if (!value.isMap()) {
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
        }
        if ((children = value.childrenMap()).containsKey(TEXT)) {
            component = Component.text().content(((ConfigurationNode)children.get(TEXT)).getString());
        } else if (children.containsKey(TRANSLATE)) {
            String key = ((ConfigurationNode)children.get(TRANSLATE)).getString();
            if (!children.containsKey(TRANSLATE_WITH)) {
                component = Component.translatable().key(key);
            } else {
                ConfigurationNode with = (ConfigurationNode)children.get(TRANSLATE_WITH);
                if (!with.isList()) {
                    throw new SerializationException("Expected with to be a list");
                }
                List args = (List)with.get(LIST_TYPE);
                component = Component.translatable().key(key).args(args);
            }
        } else if (children.containsKey(SCORE)) {
            ConfigurationNode score = (ConfigurationNode)children.get(SCORE);
            ConfigurationNode name = score.node(new Object[]{SCORE_NAME});
            ConfigurationNode objective = score.node(new Object[]{SCORE_OBJECTIVE});
            if (name.virtual() || objective.virtual()) {
                throw new SerializationException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(name.getString()).objective(objective.getString());
            ConfigurationNode scoreValue = score.node(new Object[]{SCORE_VALUE});
            component = !scoreValue.virtual() ? builder.value(scoreValue.getString()) : builder;
        } else if (children.containsKey(SELECTOR)) {
            component = Component.selector().pattern(((ConfigurationNode)children.get(SELECTOR)).getString());
        } else if (children.containsKey(KEYBIND)) {
            component = Component.keybind().keybind(((ConfigurationNode)children.get(KEYBIND)).getString());
        } else {
            boolean interpret;
            if (!children.containsKey(NBT)) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            String nbt = ((ConfigurationNode)children.get(NBT)).getString();
            boolean bl = interpret = children.containsKey(NBT_INTERPRET) && ((ConfigurationNode)children.get(NBT_INTERPRET)).getBoolean();
            if (children.containsKey(NBT_BLOCK)) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)((ConfigurationNode)children.get(NBT_BLOCK)).get(BlockNBTPosSerializer.INSTANCE.type());
                component = ComponentTypeSerializer.nbt(Component.blockNBT(), nbt, interpret).pos(pos);
            } else if (children.containsKey(NBT_ENTITY)) {
                component = ComponentTypeSerializer.nbt(Component.entityNBT(), nbt, interpret).selector(((ConfigurationNode)children.get(NBT_ENTITY)).getString());
            } else {
                if (!children.containsKey(NBT_STORAGE)) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                component = ComponentTypeSerializer.nbt(Component.storageNBT(), nbt, interpret).storage((Key)((ConfigurationNode)children.get(NBT_STORAGE)).get(KeySerializer.INSTANCE.type()));
            }
        }
        if (children.containsKey(EXTRA)) {
            ConfigurationNode extra = (ConfigurationNode)children.get(EXTRA);
            for (ConfigurationNode child : extra.childrenList()) {
                component.append(this.deserialize0((Type)((Object)Component.class), child));
            }
        }
        if ((style = (Style)value.get(Style.class, (Object)Style.empty())).isEmpty()) return component.build();
        component.style(style);
        return component.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialize(@NonNull Type type, @Nullable Component src, @NonNull ConfigurationNode value) throws SerializationException {
        value.set(null);
        if (src == null) {
            return;
        }
        if (this.stringSerial != null && this.preferString) {
            try {
                value.set(this.stringSerial.serialize(src));
                return;
            }
            catch (Exception ex) {
                throw new SerializationException((Throwable)ex);
            }
        }
        if (src instanceof TextComponent) {
            value.node(new Object[]{TEXT}).set((Object)((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            value.node(new Object[]{TRANSLATE}).set((Object)tc.key());
            if (!tc.args().isEmpty()) {
                ConfigurationNode with = value.node(new Object[]{TRANSLATE_WITH});
                for (Component arg : tc.args()) {
                    with.appendListNode().set(Component.class, (Object)arg);
                }
            }
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            ConfigurationNode score = value.node(new Object[]{SCORE});
            score.node(new Object[]{SCORE_NAME}).set((Object)sc.name());
            score.node(new Object[]{SCORE_OBJECTIVE}).set((Object)sc.objective());
            @Nullable String scoreValue = sc.value();
            if (scoreValue != null) {
                score.node(new Object[]{SCORE_VALUE}).set((Object)scoreValue);
            }
        } else if (src instanceof SelectorComponent) {
            value.node(new Object[]{SELECTOR}).set((Object)((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            value.node(new Object[]{KEYBIND}).set((Object)((KeybindComponent)src).keybind());
        } else {
            if (!(src instanceof NBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
            NBTComponent nc = (NBTComponent)src;
            value.node(new Object[]{NBT}).set((Object)nc.nbtPath());
            value.node(new Object[]{NBT_INTERPRET}).set((Object)nc.interpret());
            if (src instanceof BlockNBTComponent) {
                value.node(new Object[]{NBT_BLOCK}).set(BlockNBTPosSerializer.INSTANCE.type(), (Object)((BlockNBTComponent)nc).pos());
            } else if (src instanceof EntityNBTComponent) {
                value.node(new Object[]{NBT_ENTITY}).set((Object)((EntityNBTComponent)nc).selector());
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                value.node(new Object[]{NBT_STORAGE}).set(KeySerializer.INSTANCE.type(), (Object)((StorageNBTComponent)nc).storage());
            }
        }
        List children = src.children();
        if (!children.isEmpty()) {
            value.node(new Object[]{EXTRA}).set(LIST_TYPE, (Object)children);
        }
        if (!src.hasStyling()) return;
        value.set(Style.class, (Object)src.style());
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return (B)builder.nbtPath(nbt).interpret(interpret);
    }

    private static SerializationException notSureHowToDeserialize(ConfigurationNode element) {
        return new SerializationException("Don't know how to turn " + element + " into a Component");
    }

    private static SerializationException notSureHowToSerialize(Component component) {
        return new SerializationException("Don't know how to serialize " + component + " as a Component");
    }
}

