/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import io.leangen.geantyref.TypeToken;
import java.util.Objects;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import net.kyori.adventure.serializer.configurate4.BookTypeSerializer;
import net.kyori.adventure.serializer.configurate4.ComponentTypeSerializer;
import net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import net.kyori.adventure.serializer.configurate4.DurationSerializer;
import net.kyori.adventure.serializer.configurate4.HoverEventShowEntitySerializer;
import net.kyori.adventure.serializer.configurate4.HoverEventShowItemSerializer;
import net.kyori.adventure.serializer.configurate4.IndexSerializer;
import net.kyori.adventure.serializer.configurate4.KeySerializer;
import net.kyori.adventure.serializer.configurate4.SoundSerializer;
import net.kyori.adventure.serializer.configurate4.SoundStopSerializer;
import net.kyori.adventure.serializer.configurate4.StyleSerializer;
import net.kyori.adventure.serializer.configurate4.TextColorSerializer;
import net.kyori.adventure.serializer.configurate4.TitleSerializer;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.util.UnmodifiableCollections;

final class ConfigurateComponentSerializerImpl
implements ConfigurateComponentSerializer {
    static final ConfigurateComponentSerializer INSTANCE = new Builder().build();
    private final TypeSerializerCollection serializers;
    private final ConfigurationOptions ownNodeOptions;
    private final @Nullable ComponentSerializer<Component, ?, String> stringSerializer;
    private final boolean serializeStringComponents;

    private ConfigurateComponentSerializerImpl(@NonNull Builder builder) {
        this.stringSerializer = builder.stringSerializer;
        this.serializeStringComponents = builder.outputStringComponents;
        this.serializers = this.makeSerializers(TypeSerializerCollection.defaults().childBuilder());
        this.ownNodeOptions = ConfigurationOptions.defaults().serializers(this.serializers).nativeTypes(UnmodifiableCollections.toSet((Object[])new Class[]{String.class, Integer.class, Boolean.class, Double.class, Float.class}));
    }

    public @NonNull Component deserialize(@NonNull ConfigurationNode input) {
        try {
            @Nullable Component deserialized = (Component)input.get(Component.class);
            if (deserialized != null) {
                return deserialized;
            }
        }
        catch (SerializationException e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("No value present");
    }

    public @NonNull ConfigurationNode serialize(@NonNull Component component) {
        BasicConfigurationNode base = BasicConfigurationNode.root((ConfigurationOptions)this.ownNodeOptions);
        try {
            base.set(Component.class, (Object)component);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Unable to serialize component " + component, e);
        }
        return base;
    }

    private @NonNull TypeSerializerCollection makeSerializers(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TypeSerializerCollection.Builder serializers) {
        return serializers.register(Book.class, (TypeSerializer)BookTypeSerializer.INSTANCE).register(Title.class, (TypeSerializer)TitleSerializer.INSTANCE).register(Sound.class, (TypeSerializer)SoundSerializer.INSTANCE).register(SoundStop.class, (TypeSerializer)SoundStopSerializer.INSTANCE).register(Component.class, (TypeSerializer)new ComponentTypeSerializer(this.stringSerializer, this.serializeStringComponents)).register((ScalarSerializer)KeySerializer.INSTANCE).register((ScalarSerializer)DurationSerializer.INSTANCE).register(Style.class, (TypeSerializer)StyleSerializer.INSTANCE).register((ScalarSerializer)TextColorSerializer.INSTANCE).register((ScalarSerializer)BlockNBTPosSerializer.INSTANCE).registerExact(new IndexSerializer(TypeToken.get(ClickEvent.Action.class), ClickEvent.Action.NAMES)).registerExact(new IndexSerializer(new TypeToken<HoverEvent.Action<?>>(){}, HoverEvent.Action.NAMES)).registerExact(new IndexSerializer(TypeToken.get(Sound.Source.class), Sound.Source.NAMES)).registerExact(new IndexSerializer(TypeToken.get(TextDecoration.class), TextDecoration.NAMES)).registerExact(HoverEvent.ShowEntity.class, (TypeSerializer)HoverEventShowEntitySerializer.INSTANCE).registerExact(HoverEvent.ShowItem.class, (TypeSerializer)HoverEventShowItemSerializer.INSTANCE).build();
    }

    @Override
    public @NonNull TypeSerializerCollection serializers() {
        return this.serializers;
    }

    static class Builder
    implements ConfigurateComponentSerializer.Builder {
        private @Nullable ComponentSerializer<Component, ?, String> stringSerializer;
        private boolean outputStringComponents = false;

        Builder() {
        }

        @Override
        public @NonNull ConfigurateComponentSerializer.Builder scalarSerializer(@NonNull ComponentSerializer<Component, ?, String> stringSerializer) {
            this.stringSerializer = Objects.requireNonNull(stringSerializer, "stringSerializer");
            return this;
        }

        @Override
        public @NonNull ConfigurateComponentSerializer.Builder outputStringComponents(boolean stringComponents) {
            this.outputStringComponents = stringComponents;
            return this;
        }

        @Override
        public @NonNull ConfigurateComponentSerializer build() {
            return new ConfigurateComponentSerializerImpl(this);
        }
    }
}

