/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

final class HoverEventShowEntitySerializer
implements TypeSerializer<HoverEvent.ShowEntity> {
    static final HoverEventShowEntitySerializer INSTANCE = new HoverEventShowEntitySerializer();
    static final String ENTITY_TYPE = "type";
    static final String ID = "id";
    static final String NAME = "name";

    private HoverEventShowEntitySerializer() {
    }

    public HoverEvent.ShowEntity deserialize(@NonNull Type type, @NonNull ConfigurationNode value) throws SerializationException {
        Key typeId = (Key)value.node(new Object[]{ENTITY_TYPE}).get(Key.class);
        UUID id = (UUID)value.node(new Object[]{ID}).get(UUID.class);
        if (typeId == null || id == null) {
            throw new SerializationException("A show entity hover event needs type and id fields to be deserialized");
        }
        @Nullable Component name = (Component)value.node(new Object[]{NAME}).get(Component.class);
        return HoverEvent.ShowEntity.of((Key)typeId, (UUID)id, (Component)name);
    }

    public void serialize(@NonNull Type type, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HoverEvent.ShowEntity obj, @NonNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(new Object[]{ENTITY_TYPE}).set(Key.class, (Object)obj.type());
        value.node(new Object[]{ID}).set(UUID.class, (Object)obj.id());
        value.node(new Object[]{NAME}).set(Component.class, (Object)obj.name());
    }
}

